package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NoplateEnterService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.NoplateEnterRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * 缴费通知下发接口
 *
 * @author fangct
 */
@Service
public class PncNoplateEnterServiceImpl implements NoplateEnterService, NotifyService<NoplateEnterRequest> {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private AlarmService alarmService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    @Override
    public ObjectResponse<Void> noplateEnter(NoplateEnterRequest noplateEnterRequest) {
        String parkCode = noplateEnterRequest.getParkCode();
        noplateEnterRequest.setParkCode(null);
        String messageId = downHandle.signAndSendAsyncResult(parkCode, DownServiceEnum.无牌车入场.getServiceName(),
                noplateEnterRequest, noplateEnterRequest.getTopic());
        if (StringUtils.isEmpty(messageId)){
            alarmService.switchFailHandler(parkCode, null, noplateEnterRequest.getChannelId());
            return ObjectResponse.failed(CodeConstants.ERROR,"下发消息失败");
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<NoplateEnterRequest> sendInfoRecord) {
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }
}
