package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.park.domain.entity.park.ChannelRuleExtend;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.ChannelRuleExtendRequest;
import com.icetech.cloudcenter.domain.request.pnc.ChannelRulesRequest;
import com.icetech.cloudcenter.domain.request.pnc.DeviceRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkConfigRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.park.ChannelRuleExtendService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

@Service
@Slf4j
public class PassageWayConfServiceImpl extends AbstractService implements DownSendService {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkConfigServiceImpl parkConfigDownService;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private ChannelRuleExtendService channelRuleExtendService;

    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        String version = redisUtils.hGet(RedisConstants.PNC_VERSION, String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_407, TextConstant.getDefaultMessage(TextConstant.TWO, "找不到车场版本"));
        }
        int versionIndex = PncVersionEnum.getIndex(version);
        if (versionIndex < PncVersionEnum.版本4.getIndex()) {
            log.info("端网云车场[{}]版本过低: [{}] -> [{}]", sendRequest.getParkId(), version, versionIndex);
            return ObjectResponse.failed(CodeConstants.ERROR_407, TextConstant.getVersionMessage(version, PncVersionEnum.版本4.getVersion()));
        }

        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(serviceId);
        if (!ObjectResponse.isSuccess(channelResp))
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TWO, "未找到通道信息"));
        ParkInoutdevice channel = channelResp.getData();
        log.debug("根据通道ID[{}]查询到通道信息：{}", serviceId, channel);
        ParkConfig parkConfig = null;
        ChannelRulesRequest channelRulesRequest = new ChannelRulesRequest();
        if (channel.getStatus() == 1) {
            channelRulesRequest.setOperType(3);
            channelRulesRequest.setInandoutCode(channel.getInandoutCode());
        } else {
            channelRulesRequest.setInandoutCode(channel.getInandoutCode());
            if (channel.getRegionId() != null) {
                ObjectResponse<ParkRegion> parkRegionById = parkService.getParkRegionById(channel.getRegionId());
                if (ObjectResponse.isSuccess(parkRegionById)) {
                    ParkRegion data = parkRegionById.getData();
                    channelRulesRequest.setRegionCode(data.getRegionCode());
                }
            }

            ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(sendRequest.getParkId());
            if (!ObjectResponse.isSuccess(configObjectResponse)) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TWO, "车场配置未找到"));
            }
            parkConfig = configObjectResponse.getData();

            int rangeType = NumberUtils.toPrimitive(channel.getRangeType(), 1);
            channelRulesRequest.setRangeType(rangeType);
            channelRulesRequest.setDiffWorkDay(NumberUtils.toPrimitive(channel.getDiffWorkDay(), 0));
            channelRulesRequest.setIsMaster(channel.getIsMaster());
            channelRulesRequest.setInandoutName(channel.getInandoutName());
            channelRulesRequest.setIsOpenVaguetype(channel.getIsOpenVaguetype());
            channelRulesRequest.setVagueType(channel.getVaguetype());
            channelRulesRequest.setInandoutType(channel.getInandoutType());
            channelRulesRequest.setIsCharge(channel.getIsFee());
            if (rangeType == 1) {
                channelRulesRequest.setIsAllowTempcarrun(channel.getIsAllowTempcarrun());
                channelRulesRequest.setIsAllowNocardrun(channel.getIsAllowNocardrun());
                channelRulesRequest.setIsAllowYellowcarrun(channel.getIsAllowYellowcarrun());
                channelRulesRequest.setIsAllowNewenergycarrun(channel.getIsAllowNewenergycarrun());
                channelRulesRequest.setIsAllowVisitCar(channel.getIsAllowVisitCar());
                channelRulesRequest.setIsAllowMonthCar(channel.getIsAllowMonthCar());
                if (channel.getIsAllowMonthCar() != null && channel.getIsAllowMonthCar() == 1) {
                    channelRulesRequest.setOverTimeDay(parkConfig.getOverTimeDay());
                    channelRulesRequest.setIsOverTimeMonth(parkConfig.getIsAllowOvertimeCar());
                }
                channelRulesRequest.setOverTimeMonthlyCard(parkConfig.getIsExpireMc());
                channelRulesRequest.setExpireMcDays(parkConfig.getExpireMcDays());
                channelRulesRequest.setIsAllowBackCar(channel.getIsAllowBackCar());
                channelRulesRequest.setIsAllowABcar(channel.getIsAllowAbcar());
                channelRulesRequest.setIsAllowBluerun(channel.getIsAllowBluerun());
                channelRulesRequest.setIsAllowStoredCar(channel.getIsAllowStoredCar());
                channelRulesRequest.setIsVipCar(channel.getIsAllowVipCar());
                if (channel.getIsAllowVipCar() != null && channel.getIsAllowVipCar() == 1) {
                    channelRulesRequest.setVipCarType(channel.getVipCarTypeId());
                }
            } else {
                List<ChannelRuleExtend> channelRuleExtends = channelRuleExtendService.getChannelRuleExtendsByChannelId(channel.getId());
                List<ChannelRuleExtendRequest> channelRuleExtendRequests = new ArrayList<>();
                for (ChannelRuleExtend channelRuleExtend : channelRuleExtends) {
                    ChannelRuleExtendRequest channelRuleExtendRequest = new ChannelRuleExtendRequest();
                    BeanUtils.copyProperties(channelRuleExtend, channelRuleExtendRequest);
                    if (channelRuleExtend.getStartDate() != null) {
                        channelRuleExtendRequest.setStartDate(DateTools.getFormat(DateTools.DF_, channelRuleExtend.getStartDate()));
                    }
                    if (channelRuleExtend.getEndDate() != null) {
                        channelRuleExtendRequest.setEndDate(DateTools.getFormat(DateTools.DF_, channelRuleExtend.getEndDate()));
                    }
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
                    if (channelRuleExtend.getStartTime() != null) {
                        channelRuleExtendRequest.setStartTime(channelRuleExtend.getStartTime().format(dtf));
                    }
                    if (channelRuleExtend.getEndTime() != null) {
                        channelRuleExtendRequest.setEndTime(channelRuleExtend.getEndTime().format(dtf));
                    }
                    channelRuleExtendRequest.setIsVipCar(channelRuleExtend.getIsAllowVipCar());
                    channelRuleExtendRequest.setVipCarType(channelRuleExtend.getVipCarTypeId());
                    channelRuleExtendRequest.setIsAllowABcar(channelRuleExtend.getIsAllowAbcar());
                    if (channelRuleExtend.getIsAllowMonthCar() != null && channelRuleExtend.getIsAllowMonthCar() == 1) {
                        channelRuleExtendRequest.setOverTimeDay(parkConfig.getOverTimeDay());
                        channelRuleExtendRequest.setIsOverTimeMonth(parkConfig.getIsAllowOvertimeCar());
                    }
                    channelRulesRequest.setOverTimeMonthlyCard(parkConfig.getIsExpireMc());
                    channelRulesRequest.setExpireMcDays(parkConfig.getExpireMcDays());
                    channelRuleExtendRequests.add(channelRuleExtendRequest);
                }
                channelRulesRequest.setChannelRules(channelRuleExtendRequests);
            }
            channelRulesRequest.setScreenType(channel.getDisplayTerminal());
            if (channel.getDisplayTerminal() == 2) {
                channelRulesRequest.setIsSupportTTS(1);
            } else {
                if (channel.getTtsType() == 1) {
                    channelRulesRequest.setIsSupportTTS(1);
                } else {
                    channelRulesRequest.setIsSupportTTS(2);
                }
            }
            channelRulesRequest.setCtrlCardModel(channel.getLedcardType());
            ObjectResponse<List<ParkDevice>> deviceListByChannelId = parkDeviceService.getDeviceListByChannelId(channel.getId(), null);
            if (ObjectResponse.isSuccess(deviceListByChannelId)) {
                List<DeviceRequest> list = new ArrayList<>();
                List<ParkDevice> data = deviceListByChannelId.getData();
                for (int i = 0; i < data.size(); i++) {
                    ParkDevice parkDevice = data.get(i);
                    DeviceRequest deviceRequest = null;
                    if (parkDevice.getType() == 1) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 2) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 3) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 5) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setPort(Integer.valueOf(parkDevice.getPort()));
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 8) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                    }
                    if (!Objects.isNull(deviceRequest)) {
                        list.add(deviceRequest);
                    }
                }
                channelRulesRequest.setDevices(list);
            }
        }
        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.通道信息.getServiceName(),
                channelRulesRequest, serviceId);
        if (StringUtils.isEmpty(messageId)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }

        if (sendRequest.getTaskId() != null  // 从任务触发而非从车场高级配置下发触发
                && versionIndex < PncVersionEnum.版本2400.getIndex() // 低于语音屏显按通道配置版本需重新下发车场高级配置
                && channel.getStatus() != 1 && parkConfig != null) {
            ObjectResponse<Park> parkResp = parkService.findByParkId(parkConfig.getParkId());
            Park park = parkResp.getData();
            ParkConfigRequest parkConfigRequest = parkConfigDownService.buildRequest(park, parkConfig, channel);
            messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.车场配置.getServiceName(), parkConfigRequest, serviceId);
            if (StringUtils.isEmpty(messageId)) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
            }
        }
        return ObjectResponse.success();
    }
}
