package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.ParkRegionRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

@Service
@Slf4j
public class ParkRegionServiceImpl extends AbstractService implements DownSendService {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ChargeService chargeService;
    @Autowired
    private RedisUtils redisUtils;
    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                String.valueOf(sendRequest.getParkId()), String.class);
        if(version == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_407, TextConstant.getDefaultMessage(TWO, "找不到车场版本"));
        }
        if((PncVersionEnum.getIndex(version) < PncVersionEnum.getIndex(PncVersionEnum.版本4.getVersion()))) {
            return ObjectResponse.failed(CodeConstants.ERROR_407, TextConstant.getVersionMessage(version, PncVersionEnum.版本4.getVersion()));
        }
        ObjectResponse<ParkRegion> parkRegionById = parkService.getParkRegionById(serviceId);
        if (!ObjectResponse.isSuccess(parkRegionById)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TWO, "车场区域未找到"));
        }
        ParkRegionRequest parkRegionRequest = new ParkRegionRequest();
        ParkRegion region = parkRegionById.getData();
        parkRegionRequest.setRegionCode(region.getRegionCode());
        parkRegionRequest.setRegionName(region.getRegionName());
        parkRegionRequest.setOperType(1);
        parkRegionRequest.setIsNewEnergyDiffBill(region.getIsNewEnergyDiffBill() == null ? 0 : region.getIsNewEnergyDiffBill());
        if (region.getStatus() == 1) {
            parkRegionRequest.setOperType(3);
        }
        parkRegionRequest.setRegionTotalPark(region.getRegionPark());
        parkRegionRequest.setFreeSpace(region.getFreePark());
        parkRegionRequest.setIsSonRegion(region.getRegionType() == null ? 2 : region.getRegionType());
        if (region.getFatherRelationId() == 0) {
            parkRegionRequest.setRegionType(0);
        } else {
            parkRegionRequest.setRegionType(1);
            ObjectResponse<ParkRegion> parkRegionById1 = parkService.getParkRegionById(region.getFatherRelationId());
            if (ObjectResponse.isSuccess(parkRegionById1)) {
                ParkRegion data1 = parkRegionById1.getData();
                parkRegionRequest.setParentCode(data1.getRegionCode());
            }
        }
        parkRegionRequest.setIsFullForbidEnter(region.getIsFullForbidenter());
        parkRegionRequest.setIsFullForbidMonthEnter(region.getIsFullForbidMonthEnter());
        parkRegionRequest.setIsFullForbidVIPEnter(region.getIsFullForbidVIPEnter());
        parkRegionRequest.setVipCarType(region.getVipCarTypeId());
        parkRegionRequest.setIsFullForbidReservEnter(region.getIsFullForbidReservEnter());
        parkRegionRequest.setIsFullForbidBlackEnter(region.getIsFullForbidblackenter());
        parkRegionRequest.setIsFullForbidStoreEnter(region.getIsFullForbidStoreEnter());
        parkRegionRequest.setFullEmptyNum(region.getFullEmptynum());
        ObjectResponse<List<RegionChargeconfig>> configs = chargeService.getRegionConfigs(sendRequest.getParkId());
        if (ObjectResponse.isSuccess(configs)) {
            List<RegionChargeconfig> list = configs.getData();
            for (int i = 0; i < list.size(); i++) {
                RegionChargeconfig parkChargeconfig = list.get(i);
                if (parkChargeconfig.getRegionId() == region.getId().intValue()) {
                    // 车牌类型:0是区域的默认计费规则，1是新能源车牌，2 vip车3 蓝牌车4 黄牌车 5 收费月卡车 6 储值卡车 7 新能源车纯电计费规则
                    if (parkChargeconfig.getLicensePlateType() == 0) {
                        parkRegionRequest.setDefaultBill(parkChargeconfig.getBilltypecode());
                    } else if (parkChargeconfig.getLicensePlateType() == 3) {
                        parkRegionRequest.setBlueCarBill(parkChargeconfig.getBilltypecode());
                    } else if (parkChargeconfig.getLicensePlateType() == 1) {
                        parkRegionRequest.setNewEnergyCarBill(parkChargeconfig.getBilltypecode());
                    } else if (parkChargeconfig.getLicensePlateType() == 5) {
                        parkRegionRequest.setFixedCarBill(parkChargeconfig.getBilltypecode());
                    } else if (parkChargeconfig.getLicensePlateType() == 4) {
                        parkRegionRequest.setYellowCarBill(parkChargeconfig.getBilltypecode());
                    } else if (parkChargeconfig.getLicensePlateType() == 6) {
                        parkRegionRequest.setStoredCardBill(parkChargeconfig.getBilltypecode());
                    } else if (parkChargeconfig.getLicensePlateType() == 7) {
                        parkRegionRequest.setNewEnergyPureEleCarBill(parkChargeconfig.getBilltypecode());
                    }
                }
            }
        }
        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.区域信息和计费规则关联关系.getServiceName(),
                parkRegionRequest, serviceId);
        if (StringUtils.isEmpty(messageId)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }
}
