package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.ParkConfigRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.RedisUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

@Service
@RefreshScope
public class ParkConfigServiceImpl extends AbstractService implements DownSendService {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private PassageWayConfServiceImpl passageWayConfServiceImpl;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDiscountUserchargeService parkDiscountUserchargeService;
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Value("${notpay.tag.days:7}")
    private Integer notPayTagDaysConfig = 7;


    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_407, TextConstant.getDefaultMessage(TWO, "找不到车场版本"));
        }
        if ((PncVersionEnum.getIndex(version) < PncVersionEnum.getIndex(PncVersionEnum.版本4.getVersion()))) {
            return ObjectResponse.failed(CodeConstants.ERROR_407, TextConstant.getVersionMessage(version, PncVersionEnum.版本4.getVersion()));
        }
        ObjectResponse<Park> parkResp = parkService.findByParkId(sendRequest.getParkId());
        if (!ObjectResponse.isSuccess(parkResp))
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TWO, "未找到车场"));
        Park park = parkResp.getData();
        ParkConfigRequest parkConfigRequest = buildRequest(park);
        if (parkConfigRequest != null) {
            String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.车场配置.getServiceName(),
                    parkConfigRequest, serviceId);
            if (Objects.isNull(messageId)) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
            }
            // 高级配置修改车场所有通道也下发
            List<ParkInoutdevice> parkInoutDevices = parkInoutdeviceDao.selectByParkId(park.getId());
            if (CollectionUtils.isNotEmpty(parkInoutDevices)) {
                parkInoutDevices.forEach(parkInoutDevice -> {
                    SendRequest inoutDeviceRequest = new SendRequest();
                    inoutDeviceRequest.setServiceId(parkInoutDevice.getId());
                    inoutDeviceRequest.setParkId(park.getId());
                    inoutDeviceRequest.setServiceType(DownServiceEnum.通道信息.getServiceType());
                    passageWayConfServiceImpl.send(inoutDeviceRequest);
                });
            }
        }
        return ObjectResponse.success();
    }

    protected ParkConfigRequest buildRequest(Park park) {
        // 取最后下发的车场通道配置信息确定LED控制卡型号等字段
        ObjectResponse<ParkConfig> parkConfigResp = parkService.getParkConfig(park.getParkCode());
        if (!ObjectResponse.isSuccess(parkConfigResp)) return null;
        ParkConfig parkConfig = parkConfigResp.getData();
        SendInfo sendInfo = sendinfoDao.selectLastSend(parkConfig.getParkId(), DownServiceEnum.通道信息.getServiceType());
        ParkInoutdevice channel = null;
        if (sendInfo != null) {
            ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(sendInfo.getServiceId());
            channel = channelResp.getData();
        }
        if (channel == null || channel.getStatus() != 0) {  // 未找到通道下发信息或通道不存在时取最后添加通道
            channel = parkInoutdeviceDao.selectLimitOne(Wrappers.lambdaQuery(ParkInoutdevice.class)
                    .eq(ParkInoutdevice::getParkId, parkConfig.getParkId())
                    .eq(ParkInoutdevice::getStatus, 0)
                    .orderByDesc(ParkInoutdevice::getId));
        }
        return buildRequest(park, parkConfig, channel);
    }

    protected ParkConfigRequest buildRequest(Park park, ParkConfig parkConfig, ParkInoutdevice channel) {
        ParkConfigRequest parkConfigRequest = new ParkConfigRequest();
        parkConfigRequest.setIsMidfield(park.getIsInterior());
        parkConfigRequest.setSwitchFeeTime(park.getSwitchFeeTime());
        parkConfigRequest.setProvinceName(park.getProvinceAbbr());
        parkConfigRequest.setParkName(park.getParkName());
        ObjectResponse<ParkFreespace> parkSpaceResponse = parkService.getParkSpace(parkConfig.getParkId());
        if (ObjectResponse.isSuccess(parkSpaceResponse)) {
            ParkFreespace parkFreespace = parkSpaceResponse.getData();
            parkConfigRequest.setTotalPark(parkFreespace.getTotalNum());
            parkConfigRequest.setFreePark(Math.toIntExact(parkFreespace.getFreeSpace()));
        }
        List<ParkRegion> parkRegions = parkRegionDao.selectByParkid(park.getId());
        if (CollectionUtils.isNotEmpty(parkRegions)) {
            Optional<ParkRegion> first = parkRegions.stream().filter(parkRegion ->
                    Long.valueOf(0).equals(parkRegion.getFatherRelationId())).findFirst();
            if (first.isPresent()) {
                ParkRegion parkRegion = first.get();
                parkConfigRequest.setIsFullForbidEnter(parkRegion.getIsFullForbidenter());
                parkConfigRequest.setIsFullForbidMonthEnter(parkRegion.getIsFullForbidMonthEnter());
                parkConfigRequest.setIsFullForbidVIPEnter(parkRegion.getIsFullForbidVIPEnter());
                parkConfigRequest.setIsFullForbidReservEnter(parkRegion.getIsFullForbidReservEnter());
                parkConfigRequest.setIsFullForbidStoreEnter(parkRegion.getIsFullForbidStoreEnter());
                parkConfigRequest.setFullEmptyNum(parkRegion.getFullEmptynum());
                String collect = parkRegions.stream().map(ParkRegion::getVipCarTypeId).collect(Collectors.joining(","));
                collect = Arrays.stream(collect.split(",")).distinct().collect(Collectors.joining(","));
                parkConfigRequest.setVipCarType(collect);
                parkConfigRequest.setIsFullForbidBlackEnter(parkRegion.getIsFullForbidblackenter());
            }
        }
        parkConfigRequest.setFreeTimeStatus(parkConfig.getFreetimeStatus());
        parkConfigRequest.setBilPrecision(parkConfig.getBillPrecision());
        parkConfigRequest.setIsFillTime(parkConfig.getIsFilltime());
        parkConfigRequest.setIsRounding(parkConfig.getIsnotgetsmallchange());
        parkConfigRequest.setIsFreeAfterPay(parkConfig.getIsfreeAfterpay(15));
        parkConfigRequest.setOverTimeBillType(parkConfig.getOvertimeBillType());
        parkConfigRequest.setIsAllowFreeTmonce(parkConfig.getIsallowfreetmonce());
        parkConfigRequest.setIsFixedFee(parkConfig.getIsfixedfees());
        parkConfigRequest.setIsVisit(parkConfig.getIsVisit());
        parkConfigRequest.setVisitIscharge(parkConfig.getVisitIscharge());
        parkConfigRequest.setIsMultipleVehicles(parkConfig.getIssupAbmanage());
        parkConfigRequest.setMultipleBillType(parkConfig.getSwitchType());
        if (channel == null) {
            if (parkConfig.getDisplayTerminal() == 2) {
                parkConfigRequest.setIsSupportTTS(1);
            } else {
                if (parkConfig.getTtsType() == 1) {
                    parkConfigRequest.setIsSupportTTS(1);
                } else {
                    parkConfigRequest.setIsSupportTTS(2);
                }
            }
            parkConfigRequest.setCtrlCardModel(parkConfig.getLedcardType());
            parkConfigRequest.setScreenType(parkConfig.getDisplayTerminal());
        } else {
            if (channel.getDisplayTerminal() == 2) {
                parkConfigRequest.setIsSupportTTS(1);
            } else {
                if (channel.getTtsType() == 1) {
                    parkConfigRequest.setIsSupportTTS(1);
                } else {
                    parkConfigRequest.setIsSupportTTS(2);
                }
            }
            parkConfigRequest.setCtrlCardModel(channel.getLedcardType());
            parkConfigRequest.setScreenType(channel.getDisplayTerminal());
        }
        parkConfigRequest.setMultipleTime(parkConfig.getSwitchTm());
        if (!Objects.isNull(parkConfig.getIsfixedfees()) && parkConfig.getIsfixedfees() == 1) {
            parkConfigRequest.setFixedFeeValue(parkConfig.getFixedfeevalue());
        }
        if (parkConfig.getIsEpayment() == 1) {
            parkConfigRequest.setIsEpayMent(1);
            if (parkConfig.getEPayment().contains("WX")) {
                parkConfigRequest.setEpayMentType(1);
            } else if (parkConfig.getEPayment().contains("CMBC")) {
                parkConfigRequest.setEpayMentType(2);
            } else if (parkConfig.getEPayment().contains("CCB_PAY")) {
                parkConfigRequest.setEpayMentType(3);
            } else if (parkConfig.getEPayment().contains("ABC")) {
                parkConfigRequest.setEpayMentType(4);
            } else if (parkConfig.getEPayment().contains("YZ")) {

            } else if (parkConfig.getEPayment().contains("PARKING")) {
                parkConfigRequest.setEpayMentType(6);
            }
        } else {
            parkConfigRequest.setIsEpayMent(0);
        }
        if (parkConfig.getIsNosenpayment() == 1) {
            parkConfigRequest.setIsNosenPayMent(1);
            String noSenPayment = parkConfig.getNoSenPayment();
            if (noSenPayment.contains("UNION")) {
                parkConfigRequest.setNosenPayMentType(0);
            } else if (noSenPayment.contains("CCB")) {
                parkConfigRequest.setNosenPayMentType(1);
            } else if (noSenPayment.contains("ABC")) {
                parkConfigRequest.setNosenPayMentType(2);
            }
        } else {
            parkConfigRequest.setIsNosenPayMent(0);
        }
        parkConfigRequest.setMonetaryUnit(parkConfig.getMoneyunitType());
        parkConfigRequest.setIsReleaseFreetm(parkConfig.getIsreleaseFreetm());
        parkConfigRequest.setIsFreeSpecialCar(parkConfig.getIsfreeSpecialcar());
        parkConfigRequest.setIsCarDcount(parkConfig.getIsCardcount());
        parkConfigRequest.setVisitIscharge(parkConfig.getVisitIscharge());
        parkConfigRequest.setIsNoplateRepeatenter(parkConfig.getIsNoplateRepeatenter());
        parkConfigRequest.setIsUpImage(parkConfig.getIsupimage());
        parkConfigRequest.setIsSynDataToOut(parkConfig.getIsSync());
        parkConfigRequest.setDualCameraTime(parkConfig.getDualcameraTime());

        if (NumberUtils.toPrimitive(parkConfig.getFilterTime()) > 0) {
            parkConfigRequest.setFilterTime(parkConfig.getFilterTime());
            parkConfigRequest.setPlateFilterType(parkConfig.getPlateFilterType());
            if (NumberUtils.toPrimitive(parkConfig.getPlateFilterType(), 1) == 1) {
                parkConfigRequest.setIsInOutPass(1);
                parkConfigRequest.setEnexMinTime(parkConfig.getFilterTime());
                parkConfigRequest.setExenMinTime(parkConfig.getFilterTime());
            } else {
                parkConfigRequest.setIsInOutPass(2);
            }
        } else {
            parkConfigRequest.setIsInOutPass(2);
        }
        parkConfigRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig());
        //为了兼容文档，做加1处理
        parkConfigRequest.setBillVersion(parkConfig.getChargeVersionNum() == null ? 1 : parkConfig.getChargeVersionNum() + 1);
        parkConfigRequest.setIsNocardCheck(parkConfig.getIsNocardCheck());
        parkConfigRequest.setFreeCarReenter(parkConfig.getFreeCarReenter());
        parkConfigRequest.setCalcSpaceMethod(parkConfig.getCalcSpaceMethod(1));
        parkConfigRequest.setDelOrderCalcSpaceFlag(parkConfig.getDelOrderCalcSpaceFlag(0));
        parkConfigRequest.setCarenexTimelong(parkConfig.getCarenexTimelong());
        parkConfigRequest.setRetentionAlarmMethod(parkConfig.getRetentionAlarmMethod());
        parkConfigRequest.setRetentionIntervalTime(parkConfig.getRetentionIntervalTime());
        parkConfigRequest.setRetentionCancelTime(parkConfig.getRetentionCancelTime());

        //设置叠加优惠配置
        ParkDiscountUsercharge parkDiscountUsercharge = parkDiscountUserchargeService.getParkDiscountUserchargeByParkId(parkConfig.getParkId());
        parkConfigRequest.setPlateGetCoupons(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getPlateGetCoupons() : 1);
        parkConfigRequest.setSupportStackeUsage(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getSupportStackeUsage() : 2);
        parkConfigRequest.setThirdpartyStackeUsage(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getThirdpartyStackeUsage() : 1);
        parkConfigRequest.setUserMultipleTimes(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getUserMultipleTimes() : 2);
        parkConfigRequest.setSametypeTogetherUser(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getSametypeTogetherUser() : null);
        parkConfigRequest.setInparkRenewType(NumberUtils.toPrimitive(parkConfig.getInparkRenewType(), 1));
        parkConfigRequest.setTimeoutRenewType(NumberUtils.toPrimitive(parkConfig.getTimeoutRenewType(), 1));

        // 欠费追缴相关
        parkConfigRequest.setDeniedAddOrder(NumberUtils.toPrimitive(parkConfig.getDeniedAddOrder(), 0));
        if (NumberUtils.toPrimitive(parkConfig.getEnableReenterBlack()) == 1) {
            parkConfigRequest.setReenterBlackTime(parkConfig.getReenterBlackTime());
        }
        parkConfigRequest.setEnterpayType(NumberUtils.toPrimitive(parkConfig.getEnterpayType(), 0));
        parkConfigRequest.setEnterpayRangeDay(parkConfig.getEnterpayRangeDay());
        parkConfigRequest.setNoenterHandleType(parkConfig.getNoenterHandleType());
        // 固定收费金额单独处理
        if (Objects.nonNull(parkConfig.getNoenterHandleType())) {
            if (parkConfig.getNoenterHandleType() == 2) {
                if (parkConfig.getIsfixedfees() != null && parkConfig.getIsfixedfees() == 1) {
                    parkConfigRequest.setIsFixedFee(1);
                    parkConfigRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig());
                    parkConfigRequest.setFixedFeeValue(parkConfig.getFixedfeevalue());
                }
            }
            if (parkConfig.getNoenterHandleType() == 3) {
                parkConfigRequest.setIsFixedFee(1);
                parkConfigRequest.setFixedFeeValue(parkConfig.getFixedfeevalue());
                parkConfigRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig());
            }
        }
        parkConfigRequest.setRelLastenterRange(parkConfig.getRelLastenterRange());
        parkConfigRequest.setExitpayType(NumberUtils.toPrimitive(parkConfig.getExitpayType(), 0));
        parkConfigRequest.setExitpayRangeDay(parkConfig.getExitpayRangeDay());
        parkConfigRequest.setNotpayTagDays(NumberUtils.toPrimitive(parkConfig.getNotpayTagDays(), notPayTagDaysConfig));
        //新能源首次停车优惠时长(不计入计费时长)
        boolean isOpenFlag = Integer.valueOf(1).equals(parkConfig.getIsNewenergyCharge());
        if (isOpenFlag) {
            parkConfigRequest.setNewEnergyDiscountMinutes(NumberUtils.toPrimitive(parkConfig.getNewEnergyDiscountMinutes(), 0));
        }


        return parkConfigRequest;
    }
}
