package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.pnc.impl.PncNoplateExitServiceImpl;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExitPayCautionRequest;
import com.icetech.cloudcenter.domain.request.pnc.NotifyPrepayRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.ToolsUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

/**
 * 缴费通知下发接口
 *
 * @author fangct
 */
@Slf4j
@Service
public class NotifyPrepayServiceImpl implements DownSendService, NotifyService<NotifyPrepayRequest> {
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private PncNoplateExitServiceImpl pncNoplateExitService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private ParkService parkService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    @Autowired
    private OrderNotpayService orderNotpayService;

    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();

        OrderPay orderPay = new OrderPay();
        orderPay.setId(serviceId);
        ObjectResponse<OrderPay> objectResponse = orderPayService.findOne(orderPay);
        if (!ObjectResponse.isSuccess(objectResponse)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TWO, "订单交易信息不存在"));
        }
        ObjectResponse.notError(objectResponse);
        OrderPay orderPayRes = objectResponse.getData();
        ObjectResponse<Park> parkResponse = parkService.findByParkId(orderPayRes.getParkId());

        // 验证是否下发
//        ObjectResponse response = cacheHandle.checkPrepaySendDown(sendRequest.getParkId(), sendRequest.getServiceId(), sendRequest.getRecordId() == null ? 0 : 1);
//        if (!ObjectResponse.isSuccess(response)) {
//            return response;
//        }

        //转换为本地订单号下发
        String orderId = publicHandle.convert2OrderId(sendRequest.getParkId(), orderPayRes.getOrderNum());
        NotifyPrepayRequest notifyPrepayRequest = buildRequest(orderPayRes, orderId);

        String channelId = orderPayRes.getChannelId();
        //车主在出口用场内码缴费（查费时没有通道号）标识，true：需要下发开闸
        boolean isWait = false;
        String key = RedisConstants.PNC_EXIT_PAY_ORDER_PROFILE + sendRequest.getParkId() + "_" + orderId;
        //如果是按场内预缴费流程支付，且有出口缴费信号时，则下发抬杆指令
        if (StringUtils.isBlank(channelId) && redisUtils.exists(key)) {
            ExitPayCautionRequest exitPayCautionRequest = redisUtils.get(key, ExitPayCautionRequest.class);
            log.info("<端网云-预缴费通知> 存在出口预缴费，准备下发出场抬杆，参数：{}", exitPayCautionRequest);
            if (exitPayCautionRequest != null) {
                isWait = true;
                channelId = exitPayCautionRequest.getChannelId();
            }
        }
        if (isWait) {
            NotifyPrepayRequest.ExtraInfo extraInfo = NotifyPrepayRequest.ExtraInfo.builder()
                    .plateNum(notifyPrepayRequest.getPlateNum())
                    .orderId(orderId)
                    .channelId(channelId).build();
            String messageId = downHandle.signAndSendAsyncResult(orderPayRes.getParkId(), DownServiceEnum.预缴费.getServiceName(),
                    notifyPrepayRequest, serviceId, channelId, sendRequest.getRecordId(),
                    sendRequest.getTopic(), JsonUtils.toString(extraInfo));
            if (StringUtils.isEmpty(messageId)){
                if (StringUtils.isNotEmpty(channelId)){
                    alarmService.switchFailHandler(parkResponse.getData().getParkCode(), sendRequest.getParkId(), channelId);
                }
                return ObjectResponse.failed(ERROR_410,"缴费通知下发失败");
            }
            return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
        } else {
            String messageId = downHandle.signAndSend(orderPayRes.getParkId(), DownServiceEnum.预缴费.getServiceName(),
                    notifyPrepayRequest, serviceId, channelId, sendRequest.getRecordId());
            if (StringUtils.isEmpty(messageId)){
                if (StringUtils.isNotEmpty(channelId)){
                    alarmService.switchFailHandler(parkResponse.getData().getParkCode(), sendRequest.getParkId(), channelId);
                }
                return ObjectResponse.failed(ERROR_410,"缴费通知下发失败");
            }
            return ObjectResponse.success();
        }
    }

    /**
     * 构建请求参数
     *
     * @param orderPay 支付记录
     * @return 下发参数
     */
    private NotifyPrepayRequest buildRequest(OrderPay orderPay, String orderId) {
        NotifyPrepayRequest notifyPrepayRequest = new NotifyPrepayRequest();
        notifyPrepayRequest.setOrderId(orderId);
        ObjectResponse<OrderInfo> objectResponse = orderService.findByOrderNum(orderPay.getOrderNum());
        if (CodeConstants.SUCCESS.equals(objectResponse.getCode())) {
            OrderInfo orderInfo = objectResponse.getData();
            notifyPrepayRequest.setPlateNum(orderInfo.getPlateNum());
            notifyPrepayRequest.setType(orderInfo.getType());
            notifyPrepayRequest.setCarType(orderInfo.getCarType());
            Long payTime = orderPay.getPayTime();
            Long enterTime = orderInfo.getEnterTime();
            notifyPrepayRequest.setParkTime(payTime - enterTime);
            if (StringUtils.isNotBlank(orderPay.getChannelId())) {
                notifyPrepayRequest.setChannelId(orderPay.getChannelId());
            }
            notifyPrepayRequest.setTradeNo(orderPay.getTradeNo());
            notifyPrepayRequest.setTotalPrice(orderPay.getTotalPrice());
            notifyPrepayRequest.setPrepay(orderPay.getPaidPrice());
            notifyPrepayRequest.setDiscountPrice(orderPay.getDiscountPrice());
            ObjectResponse<Map<String, String>> objectResponse2 = orderDiscountService.findDiscountNos(orderPay.getTradeNo(), orderPay.getParkId());
            if (CodeConstants.SUCCESS.equals(objectResponse2.getCode())) {
                notifyPrepayRequest.setDiscountNos(objectResponse2.getData().get("discountNos"));
            }else if (ToolsUtil.parseFloat(orderPay.getDiscountPrice()) > 0){
                //查询按天优免
                ObjectResponse<DiscountDay> validDiscountDay = merchantDiscountService.findValidDiscountDay(orderInfo.getPlateNum(), orderInfo.getParkId(),
                        DateTools.getFormat(orderPay.getPayDate()));
                if (ObjectResponse.isSuccess(validDiscountDay)){
                    DiscountDay data = validDiscountDay.getData();
                    log.info("<端网云-预缴费通知> 使用的按天优免优惠编号：{}", data.getDiscountNo());
                    notifyPrepayRequest.setDiscountNos(data.getDiscountNo());
                }
            }
            notifyPrepayRequest.setPayWay(orderPay.getPayWay());
            notifyPrepayRequest.setPayChannel(orderPay.getPayChannel());
            notifyPrepayRequest.setPayTerminal(orderPay.getPayTerminal());
            notifyPrepayRequest.setPayTime(orderPay.getPayTime());
            notifyPrepayRequest.setMerchantTradeNo(orderPay.getThirdTradeNo());
            // 增加入口、出口补缴标识
            if (Integer.valueOf(1).equals(orderPay.getPayType())) {
                OrderNotpay notPayOrder = orderNotpayService.getOrderNotpayByOrderNum(orderInfo.getOrderNum());
                if (notPayOrder != null && notPayOrder.getMendPayType() != null) {
                    notifyPrepayRequest.setMendPayType(notPayOrder.getMendPayType());
                }
            }
            return notifyPrepayRequest;
        } else {
            log.info("Dubbo根据订单号查询未找到记录，订单号：{}，返回结果：{}", orderPay.getOrderNum(), objectResponse);
            throw new ResponseBodyException(objectResponse.getCode(), "订单号不存在");
        }
    }
    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<NotifyPrepayRequest> sendInfoRecord) {
        NotifyPrepayRequest.ExtraInfo extraInfo = JsonUtils.parseObject(sendInfoRecord.getExtraInfo(),
                NotifyPrepayRequest.ExtraInfo.class);
        if (extraInfo == null) {
            log.info("无需异步处理，直接返回，参数[{}]", sendInfoRecord);
            return;
        }
        if (!ObjectResponse.isSuccess(response)) {
            if (extraInfo.getChannelId() != null) {
                alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), extraInfo.getChannelId());
            }
        }
        NoplateExitRequest noplateExitRequest = new NoplateExitRequest();
        noplateExitRequest.setParkCode(sendInfoRecord.getParkCode());
        noplateExitRequest.setChannelId(extraInfo.getChannelId());
        noplateExitRequest.setExitTime(DateTools.unixTimestamp());
        noplateExitRequest.setPlateNum(extraInfo.getPlateNum());
        try {
            pncNoplateExitService.noplateExit(noplateExitRequest);
        } catch (ResponseBodyException e) {
            log.info("[端网云-预缴费通知] 出场抬杆失败，msg：{}", e.getMessage());
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(ERROR_410, "出场抬杆失败"));
            return;
        }
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());

    }
}
