package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.ModifyFeeRequest;
import com.icetech.cloudcenter.domain.vo.UpdateFeeVo;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import static com.icetech.basics.constants.TextConstant.ERROR_410;

/**
 * 修改停车费用接口
 *
 * @author fangct
 */
@Service
public class ModifyFeeServiceImpl implements NotifyService<ModifyFeeRequest> {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private PublicHandle publicHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> execute(UpdateFeeVo updateFeeVo) {
        ModifyFeeRequest modifyFeeRequest = new ModifyFeeRequest();
        modifyFeeRequest.setPlateNum(updateFeeVo.getPlateNum());
        modifyFeeRequest.setNewUnpayPrice(updateFeeVo.getNewUnpayPrice());
        modifyFeeRequest.setChannelId(updateFeeVo.getChannelId());
        String orderNum = updateFeeVo.getOrderNum();
        String orderId = publicHandle.convert2OrderId(updateFeeVo.getParkId(), orderNum);
        modifyFeeRequest.setOrderId(orderId);


        String messageId = downHandle.signAndSendAsyncResult(updateFeeVo.getParkId(),
                        DownServiceEnum.修改停车费用.getServiceName(),modifyFeeRequest, updateFeeVo.getTopic());
        if (messageId == null){
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<ModifyFeeRequest> sendInfoRecord) {
        if (ObjectResponse.isSuccess(response)){
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
        }else{
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection()));
        }
    }
}
