package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.order.dao.OrderModifyRecordDao;
import com.icetech.basics.constants.TextConstant;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.ModifyCarRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

@Slf4j
@Service
public class ModifyCarServiceImpl extends AbstractService implements DownSendService {

    @Autowired
    private OrderService orderService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderModifyRecordDao orderModifyRecordDao;

    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        ObjectResponse<OrderModifyRecord> orderModifyRecordObjectResponse = orderService.selectModifyRecordById(serviceId);
        if (!ObjectResponse.isSuccess(orderModifyRecordObjectResponse)) {
            return ObjectResponse.failed(ERROR_410,TextConstant.getDefaultMessage(TWO,"修正记录不存在"));
        }

        ObjectResponse.notError(orderModifyRecordObjectResponse);

        OrderModifyRecord orderModifyRecord = orderModifyRecordObjectResponse.getData();
        log.info("订单修改下发请求参数:{}", orderModifyRecord);
        String orderId = publicHandle.convert2OrderId(sendRequest.getParkId(), orderModifyRecord.getOrderNum());

        ModifyCarRequest modifyCarUpRequest = new ModifyCarRequest();
        modifyCarUpRequest.setModifyType(orderModifyRecord.getCorrectType());
        modifyCarUpRequest.setAction(orderModifyRecord.getAction());
        modifyCarUpRequest.setOrderId(orderId);
        modifyCarUpRequest.setOldVal(orderModifyRecord.getBeforeModify());
        modifyCarUpRequest.setNewVal(orderModifyRecord.getAfterModify());
        modifyCarUpRequest.setCarDesc(orderModifyRecord.getAfterCardesc());
        //参数校验
        verifyParams(modifyCarUpRequest);
        log.info("订单修改下发请求参数:{}", modifyCarUpRequest);
        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.订单修改.getServiceName(),
                modifyCarUpRequest, serviceId);
        if (StringUtils.isEmpty(messageId)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();

    }

    @Override
    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode){
        List<Long> ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List<OrderModifyRecord> list = orderModifyRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return ObjectResponse.failed(CodeConstants.ERROR_402);
        }
        List<String> orderNumList = list.stream().map(OrderModifyRecord::getOrderNum).collect(Collectors.toList());
        List<OrderInfo> orderInfos = orderService.selectListByOrderNums(orderNumList);
        Map<String, String> orderNumMap = orderInfos.stream().collect(
                Collectors.toMap(OrderInfo::getOrderNum, OrderInfo::getLocalOrderNum, (a, b) -> a));
        List<String> localOrderNumList = orderNumList.stream().map(orderNumMap::get).collect(Collectors.toList());
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(1);
        batchDelBizRequest.setIdList(localOrderNumList);
        batchDelBizRequest.setServiceIds(ids);
        String messageId = downHandle.signAndSend(parkId, DownServiceEnum.批量删除业务数据.getServiceName(), batchDelBizRequest);
        AssertTools.notNull(messageId, CodeConstants.ERROR, "下发失败");
        return ObjectResponse.success();
    }
}
