package com.icetech.park.service.down.pnc.impl;

import cn.hutool.json.JSONUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.EtcPayStatusRequest;
import com.icetech.cloudcenter.domain.response.pnc.EtcPayStatusResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 缴费查询接口
 *
 * @author fangct
 */
@Service
@Slf4j
public class EtcPayStatusServiceImpl implements NotifyService<EtcPayStatusRequest> {
    @Autowired
    private PncDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<EtcPayStatusResponse> etcPayStatus(EtcPayStatusRequest request, Long parkId, String topic) {

        String messageId = downHandle.signAndSendAsyncResult(parkId,
                DownServiceEnum.ETC.getServiceName(),request,topic );
        if (messageId == null){
            return ObjectResponse.failed(TextConstant.ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<EtcPayStatusRequest> sendInfoRecord) {
        log.info("[notify] messageId {},response {} sendInfoRecord {}",messageId,JSONUtil.toJsonStr(response),JSONUtil.toJsonStr(sendInfoRecord));
        if (ObjectResponse.isSuccess(response)) {
            EtcPayStatusResponse computeDiscount = JSONUtil.toBean(response.getData(), EtcPayStatusResponse.class);
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success(computeDiscount));
            return;
        }
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(response.getCode(),response.getMsg()));
        return;
    }
}
