package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DiscountInfoDownRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

/**
 * 优惠信息下发接口
 *
 * @author fangct
 */
@Service
public class DiscountInfoServiceImpl implements DownSendService {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Override
    public ObjectResponse<Object> send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();

        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setId(serviceId);
        ObjectResponse<OrderDiscount> one = orderDiscountService.findOne(orderDiscount);
        if (!ObjectResponse.isSuccess(one)) {
            return ObjectResponse.failed(ERROR_410,TextConstant.getDefaultMessage(TWO, "优惠记录未找到"));
        }
        OrderDiscount data = one.getData();

        DiscountInfoDownRequest discountInfoDownRequest = new DiscountInfoDownRequest();
        discountInfoDownRequest.setDiscountNo(data.getDiscountNo());
        discountInfoDownRequest.setDiscountNumber(data.getAmount());
        discountInfoDownRequest.setDiscountType(data.getType());
        discountInfoDownRequest.setFrom(data.getFrom());

        //转换为本地订单号下发
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(data.getParkId());
        orderInfo.setOrderNum(data.getOrderNum());
        ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
        if (!ObjectResponse.isSuccess(byOrderInfo)) {
            return ObjectResponse.failed(ERROR_410,TextConstant.getDefaultMessage(TWO, "订单信息未找到"));
        }
        ObjectResponse.notError(byOrderInfo);
        OrderInfo orderInfoData = byOrderInfo.getData();
        discountInfoDownRequest.setOrderId(orderInfoData.getLocalOrderNum() != null
                ? orderInfoData.getLocalOrderNum() : orderInfoData.getOrderNum());
        discountInfoDownRequest.setPlateNum(byOrderInfo.getData().getPlateNum());
        discountInfoDownRequest.setDiscountTime(data.getSendTime().getTime() / 1000);
        discountInfoDownRequest.setStatus(data.getStatus());
        discountInfoDownRequest.setTradeNo(data.getTradeNo());
        discountInfoDownRequest.setExpireTime(data.getExpireTime() == null ? null : data.getExpireTime().getTime() / 1000);
        if (data.getType().equals(DiscountTypeEnum.按天优免.getType())){
            ObjectResponse<DiscountDay> discountDayObjectResponse = merchantDiscountService.findDiscountDay(data.getDiscountNo(), data.getParkId());
            if (!ObjectResponse.isSuccess(discountDayObjectResponse)) {
                return ObjectResponse.failed(ERROR_410,TextConstant.getDefaultMessage(TWO, "优惠信息未找到"));
            }
            ObjectResponse.notError(discountDayObjectResponse);
            DiscountDay discountDay = discountDayObjectResponse.getData();
            discountInfoDownRequest.setStartTime(discountDay.getStartTime().getTime()/1000);
            discountInfoDownRequest.setEndTime(discountDay.getEndTime().getTime()/1000);
        }
        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.优惠下发.getServiceName(),
                discountInfoDownRequest, serviceId);
        if (StringUtils.isEmpty(messageId)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

}
