package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DelNotPayRecordRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

/**
 * @author wanggang
 * @create 2023-04-26 10:33
 * @desc 欠费记录删除接口
 */
@Service
public class DelNotPayRecordServiceImpl implements DownSendService {

    @Autowired
    private PncDownHandle downHandle;

    @Override
    public ObjectResponse send(SendRequest request) {
        String orderIds = request.getInclude();
        if (StringUtils.isEmpty(orderIds)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TWO, "未找到删除记录"));
        }
        DelNotPayRecordRequest recordRequest = DelNotPayRecordRequest.builder()
                .orderIds(orderIds)
                .build();
        String messageId = downHandle.signAndSend(request.getParkId(), DownServiceEnum.欠费记录删除.getServiceName(),
                recordRequest);
        if (messageId == null) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    /**
     * 主动下发
     * @param orderIds 订单号
     * @param parkId 车场id
     * @return
     */
    public ObjectResponse<Void> sendDelMessage(String orderIds, Long parkId) {
        DelNotPayRecordRequest recordRequest = DelNotPayRecordRequest.builder()
                .orderIds(orderIds)
                .build();
        String messageId = downHandle.signAndSend(parkId, DownServiceEnum.欠费记录删除.getServiceName(),
                recordRequest);
        if (messageId == null) {
            return ObjectResponse.failed(ERROR_410, "欠费记录删除接口下发失败");
        }
        return ObjectResponse.success();
    }
}
