package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.api.ConfigLssueService;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.request.LssueRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkRegionRequest;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.park.service.handle.PncDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.icetech.basics.constants.TextConstant.ERROR_410;

@Service
@Slf4j
public class ConfigLssueServiceImpl extends AbstractService implements ConfigLssueService {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ChargeService chargeService;
    @Override
    public ObjectResponse Lssue(LssueRequest lssueRequest) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(lssueRequest.getParkcode());
        if(ObjectResponse.isSuccess(byParkCode)){
            Park park = byParkCode.getData();
            Integer type = lssueRequest.getType();
            log.info("本地拉取平台配置:{}",lssueRequest);
            if(type == 1){
                lssueRegion(park.getId());
            }else if(type == 2){
                lssueCharge(park.getId());
            }else if(type == 3){
                lssuePassWay(park.getId());
            }else if(type == 4){
                lssueParkConfig(park.getId());
            }
        }else{
            ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage("TWO","车场编号不存在"));
        }
        return  ObjectResponse.success();
    }

    /**
     * 下发区域
     * @param parkId
     */
    private void lssueRegion(Long parkId){
        ObjectResponse<List<ParkRegion>> listObjectResponse = parkService.selectRegionById(parkId);
        List<ParkRegion> regionList = listObjectResponse.getData();
        for (int i = 0; i < regionList.size(); i++) {
            ParkRegion data = regionList.get(i);
            ParkRegionRequest parkRegionRequest = new ParkRegionRequest();
            parkRegionRequest.setRegionCode(data.getRegionCode());
            parkRegionRequest.setRegionName(data.getRegionName());
            parkRegionRequest.setOperType(1);
            if(data.getStatus() == 1){
                parkRegionRequest.setOperType(3);
            }
            parkRegionRequest.setRegionTotalPark(data.getRegionPark());
            parkRegionRequest.setFreeSpace(data.getFreePark());
            parkRegionRequest.setIsSonRegion(data.getRegionType() == null ? 2 : data.getRegionType());
            if(data.getFatherRelationId() == 0){
                parkRegionRequest.setRegionType(0);
            }else{
                parkRegionRequest.setRegionType(1);
                ObjectResponse<ParkRegion> parkRegionById1 = parkService.getParkRegionById(data.getFatherRelationId());
                if(ObjectResponse.isSuccess(parkRegionById1)){
                    ParkRegion data1 = parkRegionById1.getData();
                    parkRegionRequest.setParentCode(data1.getRegionCode());
                }
            }
            ObjectResponse<List<RegionChargeconfig>> configs = chargeService.getRegionConfigs(parkId);
            if(ObjectResponse.isSuccess(configs)){
                List<RegionChargeconfig> list = configs.getData();
                for (int j = 0; j < list.size(); j++) {
                    RegionChargeconfig parkChargeconfig = list.get(j);
                    if(parkChargeconfig.getLicensePlateType() == 3){
                        parkRegionRequest.setBlueCarBill(parkChargeconfig.getBilltypecode());
                    }else if(parkChargeconfig.getLicensePlateType() == 1){
                        parkRegionRequest.setNewEnergyCarBill(parkChargeconfig.getBilltypecode());
                    }else if(parkChargeconfig.getLicensePlateType() == 5){
                        parkRegionRequest.setFixedCarBill(parkChargeconfig.getBilltypecode());
                    }
                }
            }
            log.info("<端网云> 下载车场区域信息：{}",parkRegionRequest);
            String messageId = downHandle.signAndSend(parkId, DownServiceEnum.区域信息和计费规则关联关系.getServiceName(),
                    parkRegionRequest, parkId);
        }
    }

    /**
     * 下发计费规则
     * @param parkId
     */
    private void lssueCharge(Long parkId){
        DownSendService sendService = SendServiceFactory.createSendService(DownServiceEnum.计费规则.getServiceType());
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkId);
        sendRequest.setServiceType(DownServiceEnum.计费规则.getServiceType());
        sendRequest.setServiceId(parkId);
        sendService.send(sendRequest);
    }
    /**
     * 下发通道信息
     * @param parkId
     */
    private void lssuePassWay(Long parkId){
        DownSendService sendService = SendServiceFactory.createSendService(DownServiceEnum.通道信息.getServiceType());
        List<ParkInoutdevice> list = new ArrayList<>();
        try {
            ObjectResponse<List<ParkInoutdevice>> listResponse1 = parkService.getChannelByType(parkId, 1);
            ObjectResponse<List<ParkInoutdevice>> listResponse2 = parkService.getChannelByType(parkId, 2);
            if(ObjectResponse.isSuccess(listResponse1)){
                list.addAll(listResponse1.getData());
            }
            if(ObjectResponse.isSuccess(listResponse2)){
                list.addAll(listResponse2.getData());
            }
            for (int i = 0; i < list.size(); i++) {
                ParkInoutdevice parkInoutdevice = list.get(i);
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(parkId);
                sendRequest.setServiceType(DownServiceEnum.通道信息.getServiceType());
                sendRequest.setServiceId(parkInoutdevice.getId());
                sendService.send(sendRequest);
                Thread.sleep(1000);
            }
        }catch (Exception e){
            log.warn(String.valueOf(e.getMessage()), e);
        }
    }

    /**
     * 下发车场配置
     * @param parkId
     */
    private void lssueParkConfig(Long parkId){
        DownSendService sendService = SendServiceFactory.createSendService(DownServiceEnum.车场配置.getServiceType());
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkId);
        sendRequest.setServiceType(DownServiceEnum.车场配置.getServiceType());
        sendRequest.setServiceId(parkId);
        sendService.send(sendRequest);
    }
}
