package com.icetech.park.service.down.pnc.impl;

import com.github.pagehelper.util.StringUtil;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeTypeDetail;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.PncChargeRuleRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.*;

@Service
@Slf4j
public class ChargeRuleServiceImpl extends AbstractService implements DownSendService {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ChargeService chargeService;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        //计费规则编号
        String billCode = sendRequest.getInclude();
        String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                String.valueOf(sendRequest.getParkId()), String.class);
        if((PncVersionEnum.getIndex(version) < PncVersionEnum.getIndex(PncVersionEnum.版本4.getVersion()))) {
            return ObjectResponse.failed(CodeConstants.ERROR_407, TextConstant.getVersionMessage(version,PncVersionEnum.版本4.getVersion()));
        }
        try {
            if (StringUtil.isNotEmpty(billCode)) {
                ObjectResponse<ParkChargeconfig> configsBycode = chargeService.getConfigsBycodeWithoutDelFlag(sendRequest.getParkId(), billCode);
                if (ObjectResponse.isSuccess(configsBycode)) {
                    ParkChargeconfig parkChargeconfig = configsBycode.getData();
                    PncChargeRuleRequest pncChargeRuleRequest = new PncChargeRuleRequest();
                    if (parkChargeconfig.getStatus() == 1) {
                        pncChargeRuleRequest.setOperType(3);
                        pncChargeRuleRequest.setBilltypecode(billCode);
                        pncChargeRuleRequest.setBilltype(parkChargeconfig.getBilltype());
                    } else {
                        pncChargeRuleRequest = buildRequest(parkChargeconfig);
                    }
                    String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.计费规则.getServiceName(),
                            pncChargeRuleRequest, serviceId);
                    if (StringUtils.isEmpty(messageId)) {
                        return ObjectResponse.failed(ERROR_410,  TextConstant.getUnEstablishConnection());
                    }
                }
            } else {
                ObjectResponse<List<ParkChargeconfig>> configs = chargeService.getConfigs(sendRequest.getParkId());
                if (ObjectResponse.isSuccess(configs)) {
                    List<ParkChargeconfig> parkChargeconfigList = configs.getData();
                    for (int i = 0; i < parkChargeconfigList.size(); i++) {
                        ParkChargeconfig parkChargeconfig = parkChargeconfigList.get(i);
                        PncChargeRuleRequest pncChargeRuleRequest = buildRequest(parkChargeconfig);
                        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.计费规则.getServiceName(),
                                pncChargeRuleRequest, serviceId);
                        if (StringUtils.isEmpty(messageId)) {
                            return ObjectResponse.failed(ERROR_410,  TextConstant.getUnEstablishConnection());
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), e);
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TWO, "计费规则下发失败"));
        }
        return ObjectResponse.success();
    }

    private PncChargeRuleRequest buildRequest(ParkChargeconfig parkChargeconfig) {
        String billCode = parkChargeconfig.getBilltypecode();
        PncChargeRuleRequest pncChargeRuleRequest = new PncChargeRuleRequest();
        pncChargeRuleRequest.setBilltype(parkChargeconfig.getBilltype());
        pncChargeRuleRequest.setBilltypecode(parkChargeconfig.getBilltypecode());
        pncChargeRuleRequest.setIsDefault(parkChargeconfig.getDefaultCharge());
        String name = "";
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.通用自然天.type) {
            ObjectResponse<ChargeNaturalDayDetail> naturaldayObjectResponse = chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(naturaldayObjectResponse)) {
                ChargeNaturalDayDetail chargeNaturalday = naturaldayObjectResponse.getData();
                name = chargeNaturalday.getBilltypename();
                PncChargeRuleRequest.NaturalDayRule naturalDayRule = new PncChargeRuleRequest.NaturalDayRule();
                BeanUtils.copyProperties(chargeNaturalday, naturalDayRule);
                naturalDayRule.setOneBillmethod(chargeNaturalday.getBillmethod());
                naturalDayRule.setIsSmallbigcarSet(chargeNaturalday.getIsSmallbigcarSet());
                naturalDayRule.setDaynightmaxfeetype(chargeNaturalday.getMaxFeeType());
                naturalDayRule.setDaynightmaxfeecounttype(chargeNaturalday.getCountType());
                // 工作日计费方式
                naturalDayRule.setFirstConfig(onceDyrationDetail(chargeNaturalday.getWorkdayDetail()));
                //是否区分工作日非工作日
                if (chargeNaturalday.getIsspecialdaycharge() == 1) {//区分工作日非工作日
                    naturalDayRule.setTwoBillmethod(chargeNaturalday.getNoworkBillmethod());
                    naturalDayRule.setTwoConfig(onceDyrationDetail(chargeNaturalday.getHolidayDetail()));
                }
                pncChargeRuleRequest.setChargeRule(naturalDayRule);
            } else {
                log.info("<端网云-计费规则下发> 数据不完整，通用自然天计费配置查询失败，billCode：{}", billCode);
                return null;
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.白天夜间收费.type) {
            ObjectResponse<ChargeDayNightDetail> chargeDaynightObjectResponse = chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(chargeDaynightObjectResponse)) {
                ChargeDayNightDetail chargeDaynight = chargeDaynightObjectResponse.getData();
                name = chargeDaynight.getBilltypename();
                PncChargeRuleRequest.DayNightRule dayNightRule = new PncChargeRuleRequest.DayNightRule();
                BeanUtils.copyProperties(chargeDaynight, dayNightRule);
                dayNightRule.setDayBillmethod(chargeDaynight.getBillmethodday());
                dayNightRule.setNightBillmethod(chargeDaynight.getBillmethodnight());
                dayNightRule.setIsSmallbigcarSet(chargeDaynight.getIsSmallbigcarSet());
                dayNightRule.setDaynightmaxfeetype(chargeDaynight.getMaxFeeType());
                dayNightRule.setDaynightmaxfeecounttype(chargeDaynight.getCountType());
                // 白天计费方式
                dayNightRule.setDayConfig(onceDyrationDetail(chargeDaynight.getDailyDetail()));
                // 夜间计费方式
                dayNightRule.setNightConfig(onceDyrationDetail(chargeDaynight.getNightlyDetail()));
                pncChargeRuleRequest.setChargeRule(dayNightRule);
            } else {
                log.info("<端网云-计费规则下发> 数据不完整，白天夜间计费配置查询失败，billCode：{}", billCode);
                return null;
            }
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.二十四小时计费.type) {
            ObjectResponse<Charge24HourDetail> charge24chargeObjectResponse = chargeService.get24Hours(parkChargeconfig.getBilltypecode());
            if (ObjectResponse.isSuccess(charge24chargeObjectResponse)) {
                Charge24HourDetail charge24charge = charge24chargeObjectResponse.getData();
                name = charge24charge.getBilltypename();
                PncChargeRuleRequest.Charge24Rule charge24Rule = new PncChargeRuleRequest.Charge24Rule();
                BeanUtils.copyProperties(charge24charge, charge24Rule);
                charge24Rule.setIsSmallbigcarSet(charge24charge.getIsSmallbigcarSet());
                charge24Rule.setDaynightmaxfeetype(charge24charge.getMaxFeeType());
                charge24Rule.setDaynightmaxfeecounttype(charge24charge.getCountType());
                if (CollectionUtils.isNotEmpty(charge24charge.getChargeDetails())) {
                    List<PncChargeRuleRequest.Charge24RuleDetail> charge24RuleDetails = charge24charge.getChargeDetails().stream().map(charge24chargeSet -> {
                        PncChargeRuleRequest.Charge24RuleDetail charge24RuleDetail = new PncChargeRuleRequest.Charge24RuleDetail();
                        charge24RuleDetail.setFeespantime(charge24chargeSet.getFeespantime());
                        charge24RuleDetail.setFeespanrate(charge24chargeSet.getFeespanrate());
                        charge24RuleDetail.setFeespanrateBig(charge24chargeSet.getFeespanrateBig());
                        int recordStatus = charge24chargeSet.getFeespantime() % charge24charge.getDivisionTime() == 0 ? 1 : 0;
                        charge24RuleDetail.setRecordStatus(recordStatus);
                        return charge24RuleDetail;
                    }).collect(Collectors.toList());
                    charge24Rule.setDetails(charge24RuleDetails);
                    pncChargeRuleRequest.setChargeRule(charge24Rule);
                } else {
                    log.info("<端网云-计费规则下发> 数据不完整，24小时计费配置查询失败，billCode：{}", billCode);
                    return null;
                }
            } else {
                log.info("<端网云-计费规则下发> 数据不完整，24小时计费配置查询失败，billCode：{}", billCode);
                return null;
            }
        }
        pncChargeRuleRequest.setBilltypename(name);
        return pncChargeRuleRequest;
    }

    /**
     * 按次和按时长计费查询
     * @param typeDetail
     * @return
     */
    private Object onceDyrationDetail(ChargeTypeDetail typeDetail) {
        if (typeDetail.getChargeType() == 1) { //按次计费
            PncChargeRuleRequest.ChargeOnce chargeOnceVo = new PncChargeRuleRequest.ChargeOnce();
            if (typeDetail.getOnce() != null) {
                BeanUtils.copyProperties(typeDetail.getOnce(), chargeOnceVo);
                return chargeOnceVo;
            } else {
                log.info("<端网云-计费规则下发> 数据不完整，通用自然天按次计费查询失败");
                throw new ResponseBodyException(CodeConstants.ERROR_404, "通用自然天按次计费查询失败");
            }
        } else {    //按时计费
            // 非阶梯计费查询
            PncChargeRuleRequest.ChargeDyration chargeDyrationVo = new PncChargeRuleRequest.ChargeDyration();
            if (typeDetail.getDuration() != null) {
                // 非阶梯计费只会有一条记录
                BeanUtils.copyProperties(typeDetail.getDuration(), chargeDyrationVo);
            }
            // 阶梯计费查询
            if (CollectionUtils.isNotEmpty(typeDetail.getPeriodDurations())) {
                List<PncChargeRuleRequest.StepChargeDetail> stepChargeDetailList = typeDetail.getPeriodDurations().stream().map(duration -> {
                    PncChargeRuleRequest.StepChargeDetail stepChargeDetail = new PncChargeRuleRequest.StepChargeDetail();
                    BeanUtils.copyProperties(duration, stepChargeDetail);
                    return stepChargeDetail;
                }).collect(Collectors.toList());
                chargeDyrationVo.setStepChargeDetails(stepChargeDetailList);
            } else {
                log.info("<端网云-计费规则下发> 数据不完整，按时长计费配置查询失败");
                throw new ResponseBodyException(CodeConstants.ERROR_404, "按时长计费配置查询失败");
            }
            return chargeDyrationVo;
        }
    }
}
