package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.handle.CacheHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.pnc.ChannelDataResponse;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.oss.OssService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 实时通道数据下发接口
 *
 * @author fangct
 */
@Slf4j
@Service
public class ChannelDataServiceImpl implements NotifyService<Map<String, Object>> {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OssService ossService;
    @Autowired
    private OrderService orderService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<Void> execute(String channelId, String parkCode, String key, Long parkId, int dataType, String topic, Integer type) {

        Map<String, Object> paraMap = new HashMap<>();
        paraMap.put("channelId", channelId);
        paraMap.put("dataType", dataType);
        String messageId = downHandle.signAndSendAsyncResult(parkId, parkCode,
                        key, DownServiceEnum.实时通道数据.getServiceName(), paraMap, topic, String.valueOf(type));
        if (messageId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3005);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<Map<String, Object>> sendInfoRecord) {
        Integer type = Integer.valueOf(sendInfoRecord.getExtraInfo());
        if (ObjectResponse.isSuccess(response)){
            ChannelDataResponse channelDataResponse = JsonUtils.parseObject(response.getData(), ChannelDataResponse.class);
            if ("无牌车".equals(channelDataResponse.getPlateNum())){
                channelDataResponse.setPlateNum(null);
            }
            if (channelDataResponse.getImage() == null){
                String imgFileName = redisUtils.get(RedisConstants.PNC_FILEID_PROFILE + sendInfoRecord.getParkCode() + messageId, String.class);
                channelDataResponse.setImage(imgFileName);
            }
            ChannelDataResponse data = JsonUtils.parseObject(response.getData(), ChannelDataResponse.class);
            EnexCarInfoBaseResponse enexCarInfoBaseResponse;
            if (type.equals(EnexTypeEnum.入场.getType())) {
                //入口通道
                CarEnterRequest entrace = new CarEnterRequest();
                BeanUtils.copyProperties(data, entrace);
                entrace.setOrderNum(CodeTools.GenerateOrderNum());
                entrace.setMaxImage(data.getImage());
                //返回正常的时间时，以返回的为准，主要解决本地计费系统旧版本的问题
                if(data.getTime() != 4294967295L){
                    entrace.setEnterTime(data.getTime());
                }
                enexCarInfoBaseResponse = getEntraceCarInfoResponse(entrace);
            } else {
                //出口通道
                CarExitRequest exit = new CarExitRequest();
                BeanUtils.copyProperties(data, exit);
                if (data.getOrderId() != null){
                    try {
                        String orderNum = publicHandle.convert2OrderNum(sendInfoRecord.getParkId(), data.getOrderId());
                        exit.setOrderNum(orderNum);
                    }catch (ResponseBodyException e){
                        log.warn("[端网云实时通道] 本地订单号转平台订单号失败, 疑似无入场记录, orderId[{}]", data.getOrderId());
                    }
                }
                exit.setMaxImage(data.getImage());
                //返回正常的时间时，以返回的为准，主要解决本地计费系统旧版本的问题
                if(data.getTime() != 4294967295L) {
                    exit.setExitTime(data.getTime());
                }
                enexCarInfoBaseResponse = getExitCarInfoResponse(sendInfoRecord.getParkId(), sendInfoRecord.getParkCode(), exit, data.getOrderId());
            }
            //端网云
            enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.端网云.getType());
            cacheHandle.setSoftImage(messageId,data.getImage());
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success(enexCarInfoBaseResponse));
        } else {
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(CodeConstants.ERROR_3005, "收费系统响应错误"));
        }
    }

    /**
     * 获取当前入口的通道车辆信息
     * @param entrace
     * @return
     */
    private EnterCarInfoResponse getEntraceCarInfoResponse(CarEnterRequest entrace){
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum(entrace.getPlateNum());
        enterCarInfoResponse.setCarType(entrace.getCarType());
        enterCarInfoResponse.setType(entrace.getType());
        enterCarInfoResponse.setOrderNum(entrace.getOrderNum());
        String maxImage = entrace.getMaxImage();
        if (maxImage != null) {
            enterCarInfoResponse.setImgUrl(ossService.getImageUrl(maxImage));
            enterCarInfoResponse.setImgPath(maxImage);
        }
        return enterCarInfoResponse;
    }
    protected ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest, String localOrderNum) {
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        String orderNum = carExitRequest.getOrderNum();
        exitCarInfoResponse.setExitNum(carExitRequest.getPlateNum());
        exitCarInfoResponse.setCarType(carExitRequest.getCarType());
        exitCarInfoResponse.setType(carExitRequest.getType());
        if (StringUtils.isNotBlank(orderNum)){
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
            if (byOrderInfo.getCode().equals(CodeConstants.SUCCESS)){
                OrderInfo data = byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
            exitCarInfoResponse.setOrderNum(carExitRequest.getOrderNum());
        }else{
            String plateNum = carExitRequest.getPlateNum();
            ObjectResponse<OrderInfo> byOrderInfo = orderService.findInPark(plateNum, parkCode);
            if (byOrderInfo.getCode().equals(CodeConstants.SUCCESS)){
                OrderInfo data = byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setOrderNum(data.getOrderNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
        }
        Long exitTime = carExitRequest.getExitTime();
        if (exitTime != null){
            exitCarInfoResponse.setExitTime(new Date(exitTime * 1000L));
        }else{
            //离场时间默认为当前时间
            exitCarInfoResponse.setExitTime(new Date());
        }
        String maxImage = carExitRequest.getMaxImage();
        if (maxImage != null){
            exitCarInfoResponse.setImgUrl(ossService.getImageUrl(maxImage));
            exitCarInfoResponse.setImgPath(maxImage);
        }

        if (exitCarInfoResponse.getOrderNum() == null && localOrderNum != null){
            exitCarInfoResponse.setLocalOrderNum(localOrderNum);
            exitCarInfoResponse.setNoneEnterFlag(1);
        }
        return exitCarInfoResponse;
    }
}
