package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

/**
 * 优惠信息下发接口
 *
 * @author fangct
 */
@Service
public class CancelDiscountServiceImpl implements DownSendService {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderDiscountService orderDiscountService;

    @Override
    public ObjectResponse<Object> send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();

        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setId(serviceId);
        ObjectResponse<OrderDiscount> one = orderDiscountService.findOne(orderDiscount);
        if (!ObjectResponse.isSuccess(one)) {
            return ObjectResponse.failed(ERROR_410,TextConstant.getDefaultMessage(TWO, "优惠记录未找到"));
        }
        OrderDiscount data = one.getData();
        Map<String, Object> param = new HashMap<>();
        param.put("discountNo", data.getDiscountNo());
        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.撤销优惠下发.getServiceName(),
                param, serviceId);
        if (StringUtils.isEmpty(messageId)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

}
