package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.BlwhlistRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

@Service
public class BlwhlistServiceImpl extends AbstractService implements DownSendService {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private BlacklistService blacklistService;

    private static final long DEFAULT_END_TIME = 4102329600L;
    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        ObjectResponse<Blacklist> blacklistResponse = blacklistService.getById(serviceId);
        if (!ObjectResponse.isSuccess(blacklistResponse)) {
            return ObjectResponse.failed(ERROR_410,TextConstant.getDefaultMessage(TWO,"黑名单数据不存在"));
        }
        Blacklist blacklist = blacklistResponse.getData();

        BlwhlistRequest blwhlistRequest = new BlwhlistRequest();
        blwhlistRequest.setId(blacklist.getId());
        blwhlistRequest.setType(0);
        Integer status = blacklist.getStatus();
        Integer type = blacklist.getType();
        if (status.equals(1)){
            blwhlistRequest.setStatus(9);
        }else{
            if (type.equals(3)){
                blwhlistRequest.setStatus(0);
            } else {
                blwhlistRequest.setStatus(1);
            }
        }
        blwhlistRequest.setPlateNum(blacklist.getPlate());
        blwhlistRequest.setStartTime(DateTools.getParse(DateTools.DF, blacklist.getCreateTime()).getTime()/1000);
        blwhlistRequest.setEndTime(DEFAULT_END_TIME);

        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.黑白名单下发.getServiceName(),
                blwhlistRequest, serviceId);
        if (StringUtils.isEmpty(messageId)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List<Long> ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return ObjectResponse.failed(CodeConstants.ERROR_402);
        }
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(6);
        batchDelBizRequest.setIdList(ids.stream().map(Object::toString).collect(Collectors.toList()));
        batchDelBizRequest.setServiceIds(ids);
        String messageId = downHandle.signAndSend(parkId, DownServiceEnum.批量删除业务数据.getServiceName(), batchDelBizRequest);
        if (org.apache.commons.lang3.StringUtils.isEmpty(messageId)) {
            throw new ResponseBodyException(CodeConstants.ERROR, "下发失败");
        }
        return ObjectResponse.success();
    }
}
