package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncBlacklistRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.TWO;

@Slf4j
@Service
public class BlacklistServiceImpl extends AbstractService implements DownSendService {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private BlacklistService blacklistService;
    @Autowired
    private BlwhlistServiceImpl blwhlistService;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();

        String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                String.valueOf(sendRequest.getParkId()), String.class);
        log.info("版本[{}]", version);
        if (PncVersionEnum.版本FS.getVersion().equals(version)) {
            log.info("黑白名单下发[{}]", sendRequest);
            return blwhlistService.send(sendRequest);
        }
        ObjectResponse<Blacklist> blacklistResponse = blacklistService.getById(serviceId);
        if (!ObjectResponse.isSuccess(blacklistResponse)) {
            return ObjectResponse.failed(ERROR_410,TextConstant.getDefaultMessage(TWO,"黑名单数据不存在"));
        }
        Blacklist blacklist = blacklistResponse.getData();

        PncBlacklistRequest blacklistRequest = new PncBlacklistRequest();
        blacklistRequest.setBlackId(blacklist.getId());
        Integer status = blacklist.getStatus();
        if (status.equals(1)){
            blacklistRequest.setType(3);
        }else{
            blacklistRequest.setType(blacklist.getType());
        }
        blacklistRequest.setPlateNum(blacklist.getPlate());

        String messageId = downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.黑名单下发.getServiceName(),
                blacklistRequest, serviceId);
        if (StringUtils.isEmpty(messageId)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                String.valueOf(parkId), String.class);
        if (PncVersionEnum.版本FS.getVersion().equals(version)) {
            return blwhlistService.batchSend(sendRequestList, parkId, parkCode);
        }
        List<Long> ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return ObjectResponse.failed(CodeConstants.ERROR_402);
        }
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(6);
        batchDelBizRequest.setIdList(ids.stream().map(Object::toString).collect(Collectors.toList()));
        batchDelBizRequest.setServiceIds(ids);
        String messageId = downHandle.signAndSend(parkId, DownServiceEnum.批量删除业务数据.getServiceName(), batchDelBizRequest);
        if (org.apache.commons.lang3.StringUtils.isEmpty(messageId)) {
            throw new ResponseBodyException(CodeConstants.ERROR, "下发失败");
        }
        return ObjectResponse.success();
    }
}
