package com.icetech.park.service.down.pnc.impl;

import java.util.List;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchSetExitRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.AssertTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 批量置为离场数据
 */
@Service
public class BatchSetExitServiceImpl {
    @Autowired
    private PncDownHandle downHandle;

    public ObjectResponse<Void> batchSend(Long parkId, List<String> idList, Integer syncFlag) {
        BatchSetExitRequest request = new BatchSetExitRequest(BatchSetExitRequest.SERVICE_TYPE_EXIT, idList, syncFlag);
        String messageId = downHandle.signAndSend(parkId, DownServiceEnum.批量置为离场业务数据.getServiceName(), request);
        AssertTools.notNull(messageId, CodeConstants.ERROR, "批量置为离场业务下发失败");
        return ObjectResponse.success();
    }
}
