package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.basics.constants.TextConstant;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.icetech.basics.constants.TextConstant.TWO;

/**
 * 批量删除业务数据
 *
 * @author fangct
 */
@Service
public class BatchDelBizServiceImpl {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private MonthRecordDao monthRecordDao;

    public ObjectResponse batchSend(BatchDelBizRequest batchDelBizRequest, Long parkId) {
        String messageId = downHandle.signAndSend(parkId, DownServiceEnum.批量删除业务数据.getServiceName(), batchDelBizRequest);
        AssertTools.notNull(messageId, CodeConstants.ERROR, "下发失败");
        return ObjectResponse.success();
    }

    public ObjectResponse delResponse(SendInfoRecord sendinfoRecord, ObjectResponse retResponse) {
        BatchDelBizRequest batchDelBizRequest = JsonUtils.parseObject(JsonUtils.toString(sendinfoRecord.getParams()), BatchDelBizRequest.class);
        if (batchDelBizRequest == null) {
            return ObjectResponse.failed("批量删除业务数据响应处理失败");
        }
        int serviceType = NumberUtils.toPrimitive(batchDelBizRequest.getServiceType());
        if (serviceType == 1) {
            serviceType = DownServiceEnum.订单修改.getServiceType();
        } else if (serviceType == 2) {
            serviceType = DownServiceEnum.月卡.getServiceType();
            // 批量修改月卡下发状态
            LambdaUpdateWrapper<MonthRecord> updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.in(MonthRecord::getId, batchDelBizRequest.getServiceIds());
            MonthRecord monthRecord = new MonthRecord();
            monthRecord.setSendStatus(ObjectResponse.isSuccess(retResponse) ? SendInfo.StatusEnum._SUCCESS.getCode() :
                    SendInfo.StatusEnum._FAIL.getCode());
            monthRecordDao.update(monthRecord, updateWrapper);
        } else if (serviceType == 3) {
            serviceType = DownServiceEnum.VIP车辆信息.getServiceType();
        }else if (serviceType == 5) {
            serviceType = DownServiceEnum.车辆预约.getServiceType();
        }
        if (ObjectResponse.isSuccess(retResponse)) {
            sendInfoService.updateSuccessByServiceIds(
                    batchDelBizRequest.getServiceIds(), serviceType,
                    TextConstant.getSuccessDefaultMessage(TWO));
        }else{
            sendInfoService.updateFailByServiceIds(
                    batchDelBizRequest.getServiceIds(), serviceType,
                    TextConstant.getDefaultMessage(TWO,
                            StringUtils.isBlank(retResponse.getMsg()) ? "未知错误" : retResponse.getMsg()));
        }
        return ObjectResponse.success();
    }
}
