package com.icetech.park.service.down.p2r.impl;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.enumeration.P2rCmdEnum;
import com.icetech.park.service.handle.P2rMsgHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2rShowPayInfoServiceImpl")
@Slf4j
public class ShowPayInfoServiceImpl {

    @Autowired
    private P2rMsgHandle p2rMsgHandle;

    public ObjectResponse executeDown(Long parkId, String serialNumber, ShowPayInfoRequest showPayInfoRequest) {
        String messageId = p2rMsgHandle.send(parkId, serialNumber, P2rCmdEnum.支付信息展示.getCmdType(), showPayInfoRequest);
        if (StringUtils.isNotBlank(messageId)) {
            log.info("<机器人支付展示信息下发> 消息ID：{}，响应成功", messageId);
            return ObjectResponse.success();
        } else {
            log.warn("[监控埋点] alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.机器人业务处理失败.name() + "-" + "支付信息下发",
                    messageId + ", " + parkId + ", " + showPayInfoRequest, null);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }

    }

}
