package com.icetech.park.service.down.p2r.impl;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.ResponseUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.cloudcenter.domain.request.p2r.PrintInfoRequest;
import com.icetech.cloudcenter.domain.enumeration.P2rCmdEnum;
import com.icetech.park.service.handle.P2rMsgHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service("p2rPrintInfoServiceImpl")
@Slf4j
public class PrintInfoServiceImpl {

    @Autowired
    private P2rMsgHandle p2rMsgHandle;
    @Value("${web.url}")
    private String webUrl;

    public ObjectResponse downRedpack(String parkCode, String preId, Long parkId, String serialNumber, String orderNum) {
        PrintInfoRequest printInfoRequest = new PrintInfoRequest();
        printInfoRequest.setOrderNum(orderNum);
        printInfoRequest.setHeadMsg("微信扫码电子红包找零");
        printInfoRequest.setBottomMsg("提示：找零红包请在24小时内领取");
        printInfoRequest.setQrCodeUrl(webUrl + "/redpack/s?parkCode=" + parkCode + "&preId="+preId);
        String messageId = p2rMsgHandle.send(parkId, serialNumber, P2rCmdEnum.打印机信息下发.getCmdType(), printInfoRequest);
        if (StringUtils.isNotBlank(messageId)) {
            log.info("[机器人语音屏显下发] 消息ID：{}，响应成功", messageId);
            return ObjectResponse.success();
        } else {
            log.warn("[监控埋点] alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.机器人业务处理失败.name() + "-" + "打印信息下发",
                    messageId + ", " +parkCode + ", " + printInfoRequest, null);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
    }

}
