package com.icetech.park.service.down.p2r.impl;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.enumeration.P2rCmdEnum;
import com.icetech.park.service.handle.P2rMsgHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2rHintServiceImpl")
@Slf4j
public class HintServiceImpl {

    @Autowired
    private P2rMsgHandle p2rMsgHandle;

    public ObjectResponse executeDown(Long parkId, String serialNumber, RobotHintRequest robotHintRequest) {
        String messageId = p2rMsgHandle.send(parkId, serialNumber, P2rCmdEnum.屏显语音信息下发.getCmdType(), robotHintRequest);
        if (StringUtils.isNotBlank(messageId)) {
            log.info("[机器人语音屏显下发] 消息ID：{}，响应成功", messageId);
            return ObjectResponse.success();
        } else {
            log.warn("[监控埋点] alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.机器人业务处理失败.name() + "-" + "屏显语音下发",
                    messageId + ", " + robotHintRequest, null);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
    }


}
