package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.park.dao.vehicle.VehicleOperDao;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.entity.vehicle.VehicleOper;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.icetech.basics.constants.TextConstant.ERROR_410;

@Service("p2cVehicleEnableServiceImpl")
public class VehicleEnableServiceImpl extends AbstractService implements DownService<MonthCardRequest, Void> {

    @Autowired
    private VehicleOperDao vehicleOperDao;
    @Autowired
    private VehiclePlateDao vehiclePlateDao;
    @Autowired
    private SendMsgServiceImpl sendMsgService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long serviceId = sendRequest.getServiceId();

        VehicleOper vehicleOper = vehicleOperDao.selectById(serviceId);
        if (vehicleOper == null){
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(TextConstant.ONE, "内部车辆车牌号操作记录不存在"));
        }

        MonthCardRequest monthCardRequest = buildRequest(vehicleOper);
        sendRequest.setReqServiceType(P2cDownCmdEnum.月卡.getCmdType());
        return sendMsgService.send2Park(sendRequest, parkCode, monthCardRequest);
    }

    /**
     * 构建请求参数
     *
     * @param vehicleOper 操作记录
     * @return 响应
     */
    private MonthCardRequest buildRequest(VehicleOper vehicleOper) {
        Integer relId = vehicleOper.getRelId();
        String plateNums = vehicleOper.getPlateNums();
        MonthCardRequest monthCardRequest = new MonthCardRequest();
        monthCardRequest.setCardOperType(MonthRecord.CardOpertype.新增.getType());

        List<MonthCardRequest.Details> list = new ArrayList<MonthCardRequest.Details>();
        String[] plates = plateNums.split(",");
        for (String plateNum : plates){
            VehiclePlate vehiclePlate = vehiclePlateDao.select(relId, plateNum);
            if (vehiclePlate != null){
                Long id = vehiclePlate.getId();
                MonthCardRequest.Details details = new MonthCardRequest.Details();
                details.setPlateNum(plateNum);
                details.setCardId(id.intValue());
                details.setCardOwner("park");
                details.setStartDate(DateTools.Date());
                details.setEndDate("2100-12-31 23:59:59");
                details.setPlotCount(1);
                details.setCardType(1);
                list.add(details);
            }
        }

        monthCardRequest.setDetails(list);
        return monthCardRequest;
    }
}
