package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.P2cDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
@Slf4j
@Service("vehicleCheckServiceImpl")
public class VehicleCheckServiceImpl {

    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private VehiclePlateDao vehiclePlateDao;
    @Autowired
    private ClearListServiceImpl clearListService;
    @Autowired
    private ParkService parkService;

    public ObjectResponse<Void> check(String parkCode) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
        Park park = parkObjectResponse.getData();
        ObjectResponse<Void> objectResponse = clearListService.execute(park.getId(), parkCode,1, null);
        if (ObjectResponse.isSuccess(objectResponse)){
            log.info("<端云-特殊车辆-重新下发> 清除相机数据成功，车场编号：{}", parkCode);
            List<VehiclePlate> vehiclePlates = vehiclePlateDao.selectAllValidVip(park.getId());
            if (vehiclePlates != null){
                return buildRequest(vehiclePlates, park.getId(), parkCode);
            }
        }
        return ObjectResponse.failed(CodeConstants.ERROR);
    }

    /**
     * 构建请求参数
     *
     * @param vehiclePlates 列表
     * @return 响应
     */
    private ObjectResponse<Void> buildRequest(List<VehiclePlate> vehiclePlates, Long parkId, String parkCode) {
        MonthCardRequest monthCardRequest = new MonthCardRequest();
        monthCardRequest.setCardOperType(MonthRecord.CardOpertype.新增.getType());

        int size = vehiclePlates.size();
        int sendCs = size % 10 == 0 ? size/10 : size/10 + 1;
        for (int k = 0; k < sendCs; k++){
            int iMax = 10 * (k + 1);
            if (iMax > size){
                iMax = size;
            }
            List<MonthCardRequest.Details> list = new ArrayList<>();
            for (int i = 10 * k; i < iMax; i++){
                VehiclePlate vehiclePlate = vehiclePlates.get(i);
                Long id = vehiclePlate.getId();
                MonthCardRequest.Details details = new MonthCardRequest.Details();
                details.setPlateNum(vehiclePlate.getPlateNum());
                details.setCardId(id.intValue());
                details.setCardOwner("park");
                details.setStartDate(DateTools.Date());
                details.setEndDate("2100-12-31 23:59:59");
                details.setPlotCount(1);
                details.setCardType(1);
                list.add(details);
            }
            monthCardRequest.setDetails(list);
            Message<MonthCardRequest> message = new Message<>(parkId, P2cDownCmdEnum.月卡.getCmdType(), monthCardRequest);
            String[] messageIdArr = p2cDownHandle.send2Park(parkCode, message);
            if (ArrayUtils.isEmpty(messageIdArr)){
                log.info("<端云-特殊车辆-重新下发> 下发失败，参数:{}", monthCardRequest);
                return ObjectResponse.failed(CodeConstants.ERROR_3003);
            }
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), e);
            }
        }
        return ObjectResponse.success();
    }

}
