package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.oss.OssService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service("p2cTakePicturesServiceImpl")
@Slf4j
public class TakePicturesServiceImpl  extends AbstractService implements ResponseService<String>, NotifyService<Map<String, Object>> {

    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Resource
    private OssService ossService;
    @Resource
    private SoftTriggerServiceImpl softTriggerService;
    @Resource
    private RedisUtils redisUtils;

    public ObjectResponse<String> execute(Long parkId, String parkCode, String sn){

        Message<Void> message = new Message<>(parkId, P2cDownCmdEnum.图片抓拍.getCmdType(), null);
        String messageId = p2cDownHandle.send(parkCode, sn, message);
        if (messageId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003,"相机未连接");
        }
        //默认图片路径
        cacheHandle.setSoftImage(messageId, "tmp/"+parkCode+"/"+messageId+".jpg");
        return ObjectResponse.success(messageId);
    }
    public ObjectResponse<Void> executeAsync(Long parkId, String parkCode, String sn, String channelCode, Integer type, String topic) {
        Map<String, Object> paraMap = new HashMap<>();
        paraMap.put("type", type);
        paraMap.put("parkCode", parkCode);
        paraMap.put("channelCode", channelCode);
        Message<Map<String, Object>> message = new Message<>(parkId, P2cDownCmdEnum.图片抓拍.getCmdType(), null);
        String messageId = p2cDownHandle.send(parkCode, sn, message, topic, JsonUtils.toString(paraMap));
        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        //默认图片路径
        cacheHandle.setSoftImage(messageId, "tmp/" + parkCode + "/" + messageId + ".jpg");
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }
    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.图片抓拍.getCmdType());
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<Map<String, Object>> sendInfoRecord) {
        EnexCarInfoBaseResponse enexCarInfoBaseResponse;
        Map<String, String> extraInfo = JsonUtils.parseStringMap(sendInfoRecord.getExtraInfo());
        if (extraInfo == null || extraInfo.get("type") == null) {
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
            return;
        }
        String parkCode = extraInfo.get("parkCode");
        String imagePath = "tmp/" + parkCode + "/" + messageId + ".jpg";
        if (!ObjectResponse.isSuccess(response)) {
            redisUtils.hPut(RedisConstants.NO_TAKE_PICTURE_FUNC_KEY, sendInfoRecord.getTarget(), DateTools.unixTimestamp());
            log.info("抓拍接口不支持 转软触发接口处理 参数{}", extraInfo);
            //抓拍不支持时，调用软触发
            ObjectResponse<Void> objectResponse = softTriggerService.execute(sendInfoRecord.getParkId(), sendInfoRecord.getParkCode(),
                    extraInfo.get("channelCode"), sendInfoRecord.getTopic(),
                    SoftTriggerRequest.GetCarInfo.builder().biz(SoftTriggerRequest.ExtraInfoEnum.GET_CAR_INFO.val)
                            .type(Integer.valueOf(extraInfo.get("type"))).channelCode(extraInfo.get("channelCode")).build());
            if (!CodeConstants.ERROR_12002.equals(objectResponse.getCode())) {
                imagePath = cacheHandle.getDataFromRedis(RedisConstants.SOFT_IMAGE_PROFILE + objectResponse.getData(), 3000L, String.class);
                if (imagePath == null) {
                    return;
                }
            }
        } else {
            //抓拍成功，删除无功能标识
            redisUtils.hDelete(RedisConstants.NO_TAKE_PICTURE_FUNC_KEY, sendInfoRecord.getTarget());
        }

        Integer type = Integer.parseInt(extraInfo.get("type"));
        if (EnexTypeEnum.入场.getType().equals(type)) {
            //入口通道
            try {
                enexCarInfoBaseResponse = getEntranceCarInfoResponse(imagePath);
            } catch (Exception e) {
                log.error("抓拍图异常, e=", e);
                return;
            }
        } else {
            //出口通道
            try {
                enexCarInfoBaseResponse = getExitCarInfoResponse(imagePath);
            } catch (Exception e) {
                log.error("抓拍图异常, e=", e);
                return;
            }
        }
        enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.端云.getType());
        log.info("enexCarInfoBaseResponse:{}", enexCarInfoBaseResponse);
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success(enexCarInfoBaseResponse));
    }

    protected EnterCarInfoResponse getEntranceCarInfoResponse(String imagePath) {
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum(DataCommonConstants.WEI_SHI_BIE);
        enterCarInfoResponse.setCarType(1);
        enterCarInfoResponse.setType(1);
        enterCarInfoResponse.setOrderNum(CodeTools.GenerateOrderNum());
        if (imagePath != null) {
            enterCarInfoResponse.setImgUrl(ossService.getImageUrl(imagePath));
            enterCarInfoResponse.setImgPath(imagePath);
        }
        return enterCarInfoResponse;
    }

    /**
     * 获取离场通道信息
     *
     * @param imagePath 图片路径
     * @return 响应
     */
    private ExitCarInfoResponse getExitCarInfoResponse(String imagePath) {
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        exitCarInfoResponse.setExitNum(DataCommonConstants.WEI_SHI_BIE);
        exitCarInfoResponse.setCarType(1);
        exitCarInfoResponse.setType(1);
        exitCarInfoResponse.setExitTime(new Date());
        if (imagePath != null) {
            exitCarInfoResponse.setImgUrl(ossService.getImageUrl(imagePath));
            exitCarInfoResponse.setImgPath(imagePath);
        }
        return exitCarInfoResponse;
    }
}
