package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.response.p2c.QueryListResponse;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("p2cQueryListServiceImpl")
public class QueryListServiceImpl extends AbstractService implements ResponseService<String>, NotifyService<String> {

    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<List<QueryListResponse>> execute(Long parkId, String parkCode, Integer dataType, String plateNum){

        QueryListRequest queryListRequest = new QueryListRequest();
        queryListRequest.setDataType(dataType);
        queryListRequest.setPlateNum(plateNum);

        Message<QueryListRequest> message = new Message<>(parkId, P2cDownCmdEnum.名单数据查询.getCmdType(), queryListRequest);
        String[] messageIdArr = p2cDownHandle.send2Park(parkCode, message);
        if (ArrayUtils.isEmpty(messageIdArr)){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            if (messageIdArr == null){
                return ObjectResponse.failed(CodeConstants.ERROR_3003);
            }
            List<QueryListResponse> list = new ArrayList<>();
            for (String messageId : messageIdArr){
                ObjectResponse<String> response = cacheHandle.getResponseFromRedis(messageId, 4000L);
                if (ObjectResponse.isSuccess(response)) {
                    QueryListResponse queryListResponse = getQueryListResponse(dataType, response);
                    list.add(queryListResponse);
                }
            }
            if (list.size() > 0){
                return ObjectResponse.success(list);
            }else{
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            }
        }
    }
    public ObjectResponse queryByDeviceNo(Long parkId, String parkCode, Integer dataType, String plateNum, String deviceNo){

        QueryListRequest queryListRequest = new QueryListRequest();
        queryListRequest.setDataType(dataType);
        queryListRequest.setPlateNum(plateNum);
        Message<QueryListRequest> message = new Message<>(parkId, P2cDownCmdEnum.名单数据查询.getCmdType(), queryListRequest);
        String messageId = p2cDownHandle.send(parkCode, deviceNo, message);

        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        } else {
            long timeOut = 4000L;
            if (dataType == QueryListRequest.DataType.月卡.getVal()){
                timeOut = 6000L;
            }
            ObjectResponse<String> response = cacheHandle.getResponseFromRedis(messageId, timeOut);
            if (ObjectResponse.isSuccess(response)) {
                QueryListResponse queryListResponse = getQueryListResponse(dataType, response);
                return ObjectResponse.success(queryListResponse);
            }else if (CodeConstants.ERROR_404.equals(response.getCode())){
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            }
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }

    }

    private QueryListResponse getQueryListResponse(Integer dataType, ObjectResponse<String> response) {
        boolean isArr = response.getData().startsWith("[");
        QueryListResponse queryListResponse = new QueryListResponse();
        if (isArr) {
            queryListResponse.setDataType(dataType);
            queryListResponse.setDetails(response.getData());
        } else {
            queryListResponse = JsonUtils.parseObject(response.getData(), QueryListResponse.class);
        }
        return queryListResponse;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2CBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2CBaseResponse, parkId, P2cDownCmdEnum.名单数据查询.getCmdType());
    }
}
