package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.request.p2c.QueryInparkRequest;
import com.icetech.cloudcenter.domain.response.p2c.QueryInparkResponse;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("p2cQueryInparkServiceImpl")
public class QueryInparkServiceImpl extends AbstractService implements ResponseService<String>, NotifyService<String> {

    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<List<QueryInparkResponse>> execute(Long parkId, String parkCode, String plateNum){

        QueryInparkRequest queryInparkRequest = new QueryInparkRequest();
        queryInparkRequest.setPlateNum(plateNum);

        Message<QueryInparkRequest> message = new Message<>(parkId, P2cDownCmdEnum.在场车辆查询.getCmdType(), queryInparkRequest);
        String[] messageIdArr = p2cDownHandle.send2Park(parkCode, message);
        if (ArrayUtils.isEmpty(messageIdArr)){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            if (messageIdArr == null){
                return ObjectResponse.failed(CodeConstants.ERROR_3003);
            }
            List<QueryInparkResponse> list = new ArrayList<>();
            for (String messageId : messageIdArr){
                ObjectResponse<String> response = cacheHandle.getResponseFromRedis(messageId, 5000L);
                if (ObjectResponse.isSuccess(response)){
                    list.addAll(JsonUtils.parseArray(response.getData(), QueryInparkResponse.class));
                }
            }
            if (list.size() > 0){
                return ObjectResponse.success(list);
            }else{
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            }
        }
    }
    public ObjectResponse<List<QueryInparkResponse>> queryByDeviceNo(Long parkId, String parkCode, String plateNum, String serialNumber){

        QueryInparkRequest queryInparkRequest = new QueryInparkRequest();
        queryInparkRequest.setPlateNum(plateNum);

        Message<QueryInparkRequest> message = new Message<>(parkId, P2cDownCmdEnum.在场车辆查询.getCmdType(), queryInparkRequest);
        String messageId = p2cDownHandle.send(parkCode, serialNumber, message);

        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        } else {
            ObjectResponse<String> response = cacheHandle.getResponseFromRedis(messageId, 4000L);
            if (ObjectResponse.isSuccess(response)) {
                return ObjectResponse.success(JsonUtils.parseArray(response.getData(), QueryInparkResponse.class));
            }
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }

    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.在场车辆查询.getCmdType());
    }
}
