package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.domain.request.p2c.PropertySetRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2cPropertySetServiceImpl")
@Slf4j
public class PropertySetServiceImpl extends AbstractService implements ResponseService<String>, DownService<PropertySetRequest, Void> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse<Void> send(PropertySetRequest propertySetRequest, String sn){
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        Message<PropertySetRequest> message = new Message<>(deviceInfo.getParkId(), P2cDownCmdEnum.属性配置下发.getCmdType(), propertySetRequest);
        //组装参数
        String messageId = p2cDownHandle.send(deviceInfo.getParkCode(), sn, message);
        if (messageId == null) {
            log.info("[端云-属性配置下发] 下发失败，参数:{}", propertySetRequest);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        } else {
            return ObjectResponse.success();
        }

    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.属性配置下发.getCmdType());
    }
}
