package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.LockPoolUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("p2cPropertyGetServiceImpl")
@Slf4j
public class PropertyGetServiceImpl extends AbstractService implements ResponseService<String>, DownService<Void, Void> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse<PropertyInfoRequest> send(String sn, String topic){
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        Message<Void> message = new Message<>(deviceInfo.getParkId(), P2cDownCmdEnum.属性获取.getCmdType(), null);
        //组装参数
        String messageId = p2cDownHandle.send(deviceInfo.getParkCode(), sn, message);
        if (messageId == null) {
            log.info("[端云-属性获取] 下发失败, sn[{}}]", sn);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        //打开获取的开关
        redisUtils.set(RedisConstants.PROPERTY_GET_FLAG_PROFILE + sn,
                messageId + "/" + AsyncNotifyInterface.getTopic(), 8L);
        LockPoolUtils.add(messageId);
        synchronized (messageId) {
            try {
                messageId.wait(4000);
            } catch (InterruptedException e) {
                log.error("messageId {} wait error:", messageId, e);
            }
        }
        LockPoolUtils.remove(messageId);
        PropertyInfoRequest data = redisUtils.get(RedisConstants.PROPERTY_GET_INFO_PROFILE + sn, PropertyInfoRequest.class);
        if (data == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3005);
        }
        return ObjectResponse.success(data);

    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.属性获取.getCmdType());
    }
}
