package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.RemoteOperaCommon;
import com.icetech.park.service.down.RemoteOperaService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.makeup.WsRepeatPush;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.concurrent.ScheduledThreadPoolExecutor;

@Service("p2cRemoteSwitchServiceImpl")
@Slf4j
public class P2cRemoteSwitchServiceImpl extends RemoteOperaCommon implements RemoteOperaService, ResponseService<String>, NotifyService<RemoteSwitchRequest> {

    @Autowired
    private P2cDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Autowired
    private ScheduledThreadPoolExecutor asyncMethodScheduler;
    @Autowired
    private AlarmService alarmService;

    @Override
    public ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, String parkCode, String channelId, String plateNum){
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
        if (ObjectResponse.isSuccess(parkObjectResponse)){
            Long parkId = parkObjectResponse.getData().getId();
            String deviceNo;
            try {
                deviceNo = cacheHandle.getSerialNumber(parkCode, channelId);
            } catch (ResponseBodyException e) {
                return ObjectResponse.failed(CodeConstants.ERROR_3003);
            }
            return execute(switchType, parkId, parkCode, deviceNo, plateNum);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_400);
    }
    @Override
    public ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum) {

        int sequenceId = RandomUtils.nextInt(100000, 1000000);
        String messageId = open(switchType, parkId, parkCode, serialNumber, plateNum, sequenceId, null);
        if (messageId == null){
            TokenDeviceVo tokenInfo2 = cacheHandle.getDeviceInfo(serialNumber);
            if (tokenInfo2 != null){
                alarmService.switchFailHandler(parkCode, parkId, tokenInfo2.getInandoutCode());
            }
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            RemoteSwitchResponse remoteSwitchResponse = cacheHandle.getRemoteSwitch(messageId);
            if (remoteSwitchResponse != null){
                Long executeTime = remoteSwitchResponse.getExecuteTime();
                TokenDeviceVo tokenInfo2 = cacheHandle.getDeviceInfo(serialNumber);
                if (tokenInfo2 != null && tokenInfo2.getVersion().equals(P2cVersionEnum.版本1.getVersion())){
                    //临时统一与相机的时间
                    remoteSwitchResponse.setExecuteTime(DateTools.getUnixTime(executeTime));
                }
                if (Integer.valueOf(3).equals(remoteSwitchResponse.getResult())){
                    log.warn("alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.开闸失败.name() + "-相机超时未处理",
                            "parkCode: " + parkCode +", serialNumber: " + serialNumber + ", plateNum: " + plateNum, remoteSwitchResponse);
                    if (tokenInfo2 != null) {
                        alarmService.switchFailHandler(parkCode, parkId, tokenInfo2.getInandoutCode());
                    }
                }
                return ObjectResponse.success(remoteSwitchResponse);
            }else {
                log.warn("[监控埋点] alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.开闸失败.name() + "-" + "端云",
                        "parkCode: " + parkCode + ", serialNumber: " + serialNumber + ", plateNum: " + plateNum, remoteSwitchResponse);
                TokenDeviceVo tokenInfo2 = cacheHandle.getDeviceInfo(serialNumber);
                if (tokenInfo2 != null) {
                    String channelCode = tokenInfo2.getInandoutCode();
                    new WsRepeatPush(downHandle, parkCode, serialNumber).push(asyncMethodScheduler, () -> {
                        String msgId = open(switchType, parkId, parkCode, serialNumber, plateNum, sequenceId, null);
                        if (msgId != null) {
                            RemoteSwitchResponse response = cacheHandle.getRemoteSwitch(msgId);
                            log.info("msgId：{} 响应：{}", msgId, response);
                            boolean success = response != null && response.getResult() == 1;
                            if (!success) {
                                alarmService.switchFailHandler(parkCode, parkId, channelCode);
                            }
                            return success;
                        } else {
                            alarmService.switchFailHandler(parkCode, parkId, channelCode);
                            return false;
                        }
                    });
                }
                return ObjectResponse.failed(CodeConstants.ERROR_3002);
            }
        }
    }

    /**
     * 开闸指令下发
     * @param switchType 开关类型
     * @param parkCode 车场编号
     * @param serialNumber 相机SN
     * @return 响应
     */
    @Override
    public ObjectResponse<Void> execute(Integer switchType, String parkCode, String serialNumber, String plateNum,
                                        String topic, RemoteSwitchRequest.ExtraInfo extraInfo) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess(parkObjectResponse)) {
            throw new ResponseBodyException(CodeConstants.ERROR_402, "车场不存在");
        }
        Long parkId = parkObjectResponse.getData().getId();
        RemoteSwitchRequest remoteSwitchRequest = new RemoteSwitchRequest();
        remoteSwitchRequest.setSequenceId(RandomUtils.nextInt(100000, 1000000));
        remoteSwitchRequest.setSwitchType(switchType);
        remoteSwitchRequest.setPlateNum(plateNum);
        Long sendTime = DateTools.unixTimestamp();
        remoteSwitchRequest.setTime(sendTime);
        Message<RemoteSwitchRequest> message = new Message<>(parkId, P2cDownCmdEnum.远程开关闸.getCmdType(), remoteSwitchRequest);
        String messageId = downHandle.send(parkCode, serialNumber, message, topic, JsonUtils.toString(extraInfo));
        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3002);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }
    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum) {
        return open(switchType, parkId, parkCode, serialNumber, plateNum, RandomUtils.nextInt(100000, 1000000), null);
    }
    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, String topic) {
        return open(switchType, parkId, parkCode, serialNumber, plateNum, RandomUtils.nextInt(100000, 1000000), topic);
    }
    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, Integer sequenceId, String topic) {
        RemoteSwitchRequest remoteSwitchRequest = new RemoteSwitchRequest();
        remoteSwitchRequest.setSequenceId(sequenceId);
        remoteSwitchRequest.setSwitchType(switchType);
        remoteSwitchRequest.setPlateNum(plateNum);
        Long sendTime = DateTools.unixTimestamp();
        remoteSwitchRequest.setTime(sendTime);
        Message<RemoteSwitchRequest> message = new Message<>(parkId, P2cDownCmdEnum.远程开关闸.getCmdType(), remoteSwitchRequest);
        return downHandle.send(parkCode, serialNumber, message);
    }
    @Override
    public ObjectResponse<RemoteSwitchResponse> secondOpen(RemoteSwitchRequest remoteSwitchRequest, Long parkId, String parkCode, String serialNumber) {
        Message<RemoteSwitchRequest> message = new Message<>(parkId, P2cDownCmdEnum.远程开关闸.getCmdType(), remoteSwitchRequest);
        String messageId = downHandle.send(parkCode, serialNumber, message);
        RemoteSwitchResponse remoteSwitchResponse = cacheHandle.getRemoteSwitch(messageId);
        if (remoteSwitchResponse != null){
            Long executeTime = remoteSwitchResponse.getExecuteTime();
            TokenDeviceVo tokenInfo2 = cacheHandle.getDeviceInfo(serialNumber);
            if (tokenInfo2 != null && tokenInfo2.getVersion().equals(P2cVersionEnum.版本1.getVersion())){
                //临时统一与相机的时间
                remoteSwitchResponse.setExecuteTime(DateTools.getUnixTime(executeTime));
            }
            return ObjectResponse.success(remoteSwitchResponse);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_3002);
    }


    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        downHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.远程开关闸.getCmdType());
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<RemoteSwitchRequest> sendInfoRecord) {
        RemoteSwitchResponse remoteSwitchResponse = null;
        if (CodeConstants.ERROR_405.equals(response.getCode())){
            remoteSwitchResponse = new RemoteSwitchResponse();
            remoteSwitchResponse.setResult(1);
            remoteSwitchResponse.setExecuteTime(DateTools.unixTimestamp());
            remoteSwitchResponse.setImage(null);
        }else if (StringUtils.isNotBlank(response.getData())){
            remoteSwitchResponse = JsonUtils.parseObject(response.getData(), RemoteSwitchResponse.class);
        }
        String serialNumber = sendInfoRecord.getTarget();
        TokenDeviceVo tokenInfo2 = cacheHandle.getDeviceInfo(serialNumber);
        RemoteSwitchRequest request = sendInfoRecord.getParams();
        if (remoteSwitchResponse == null){
            log.warn("[监控埋点] alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.开闸失败.name() + "-" + "端云",
                    "parkCode: " + sendInfoRecord.getParkCode() +
                            ", serialNumber: " + serialNumber +
                            ", plateNum: " + request.getPlateNum(), remoteSwitchResponse);
            if (tokenInfo2 != null && tokenInfo2.getInandoutType() != null) {
                alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), tokenInfo2.getInandoutCode());
            }
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(CodeConstants.ERROR_3002));
            return;
        }
        Long executeTime = remoteSwitchResponse.getExecuteTime();
        if (tokenInfo2 != null && tokenInfo2.getVersion().equals(P2cVersionEnum.版本1.getVersion())){
            //临时统一与相机的时间
            remoteSwitchResponse.setExecuteTime(DateTools.getUnixTime(executeTime));
        }
        if (Integer.valueOf(3).equals(remoteSwitchResponse.getResult())){
            log.warn("alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.开闸失败.name() + "-相机超时未处理",
                    "parkCode: " + sendInfoRecord.getParkCode() +
                            ", serialNumber: " + serialNumber +
                            ", plateNum: " + request.getPlateNum(), remoteSwitchResponse);
            if (tokenInfo2 != null && tokenInfo2.getInandoutType() != null) {
                alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), tokenInfo2.getInandoutCode());
            }
            if (sendInfoRecord.getTopic() != null) {
                asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(CodeConstants.ERROR_3002, "相机时钟有偏差"));
            }
            return;
        }
        if (sendInfoRecord.getExtraInfo() == null) {
            return;
        }
        RemoteSwitchRequest.ExtraInfo extraInfo = JsonUtils.parseObject(sendInfoRecord.getExtraInfo(),
                RemoteSwitchRequest.ExtraInfo.class);
        if (RemoteSwitchRequest.ExtraInfoEnum.OPEN.val.equals(extraInfo.getBiz())) {
            OpenBrakeRequest openBrakeRequest = JsonUtils.parseObject(
                    JsonUtils.toString(extraInfo.getRequestVO()), OpenBrakeRequest.class);
            //记录类型，1：入，2：出
            if (openBrakeRequest.getRecordType() == 1){
                CarEnterRequest enterRequest = new CarEnterRequest();
                enterRequest.setEnterTime(System.currentTimeMillis()/1000);
                enterRequest.setType(3);
                enterRequest.setCarType(1);
                enterRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                enterRequest.setParkCode(openBrakeRequest.getParkCode());
                enterRequest.setPlateNum(openBrakeRequest.getPlateNum());
                enterRequest.setProperty(2);
                enterRequest.setOpenFlag(1);
                enterRequest.setOrderNum(openBrakeRequest.getOrderNum());
                carOrderEnterService.sendWebsocketMessage(enterRequest,1);
            }else {
                CarExitRequest exitRequest = new CarExitRequest();
                exitRequest.setType(3);
                exitRequest.setCarType(1);
                exitRequest.setExitTime(System.currentTimeMillis());
                exitRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                exitRequest.setParkCode(openBrakeRequest.getParkCode());
                exitRequest.setPlateNum(openBrakeRequest.getPlateNum());
                exitRequest.setOrderNum(openBrakeRequest.getOrderNum());
                exitRequest.setOpenFlag(1);
                carOrderExitService.sendWebsocketMessage(exitRequest, "5", FlowCondition.YES, FlowCondition.NO);
            }
            // 更新通道的报警记录为已处理
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(sendInfoRecord.getParkId());
            channelAlarm.setChannelCode(openBrakeRequest.getAisleCode());
            channelAlarm.setStatus(ChannelAlarm.Status.已处理.getStatus());
            channelAlarmDao.update(channelAlarm);
            if (delRemoteSwitchResponse(openBrakeRequest, sendInfoRecord.getParkCode(), remoteSwitchResponse, sendInfoRecord.getParkId())){
                asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
            } else {
                asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(CodeConstants.ERROR_3002));
            }
        } else if (RemoteSwitchRequest.ExtraInfoEnum.CLOSE.val.equals(extraInfo.getBiz())) {
            CloseBrakeRequest closeBrakeRequest = JsonUtils.parseObject(JsonUtils.toString(extraInfo.getRequestVO()),
                    CloseBrakeRequest.class);
            //添加开关闸记录
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            BeanUtils.copyProperties(closeBrakeRequest, openingDtoRequest);
            openingDtoRequest.setImgUrl(closeBrakeRequest.getImagePath() == null ? remoteSwitchResponse.getImage() : closeBrakeRequest.getImagePath() + "," + remoteSwitchResponse.getImage());
            openingDtoRequest.setExecuteTime(executeTime);
            openingDtoRequest.setSourcegate(4);
            parkService.saveOpeningRecord(openingDtoRequest);
            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
        }

    }

    @Override
    protected void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime, String imagePath, Long parkId) {
        //添加开闸记录
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        BeanUtils.copyProperties(openBrakeRequest, openingDtoRequest);
        openingDtoRequest.setImgUrl(imagePath == null ? image : imagePath + "," + image);
        openingDtoRequest.setExecuteTime(executeTime);
        parkService.saveOpeningRecord(openingDtoRequest);
    }
}
