package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2cParkRegionRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;


@Service("p2cParkRegionServiceImpl")
@Slf4j
public class P2cParkRegionServiceImpl extends AbstractService
        implements ResponseService<String>, DownService<List<P2cParkRegionRequest>, Void> {

    @Resource
    private SendMsgServiceImpl sendMsgService;
    @Resource
    private ParkService parkService;
    @Resource
    private P2cDownHandle p2cDownHandle;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long parkId = sendRequest.getParkId();
        List<P2cParkRegionRequest> requestList = buildRequest(parkId);
        return sendMsgService.send2Park(sendRequest, parkCode, requestList);
    }

    public ObjectResponse<Void> send(Long parkId, String parkCode, String sn) {
        List<P2cParkRegionRequest> requestList = buildRequest(parkId);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkId);
        sendRequest.setServiceType(P2cDownCmdEnum.区域信息.getCmdType());
        return sendMsgService.send2Devices(sn, sendRequest, parkCode, requestList);
    }

    private List<P2cParkRegionRequest> buildRequest(Long parkId) {
        ObjectResponse<List<ParkRegion>> listObjectResponse = parkService.selectRegionById(parkId);
        ObjectResponse.notError(listObjectResponse, "查询车场ID[" + parkId + "]的区域列表失败");
        List<ParkRegion> parkRegions = listObjectResponse.getData();
        return parkRegions.stream().map(parkRegion -> P2cParkRegionRequest.builder()
                .regionId(parkRegion.getId())
                .regionName(parkRegion.getRegionName())
                .regionType(Long.valueOf(0).equals(parkRegion.getFatherRelationId()) ? 1 : 2)
                .parentRegionId(NumberUtils.toPrimitive(parkRegion.getFatherRelationId()))
                .build()).collect(Collectors.toList());
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.区域信息.getCmdType());
    }
}
