package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NoplateExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteSwitchRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.impl.ManageServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 兼容端云纯云无牌车开闸
 * @author fangct
 */
@Service
@Slf4j
public class P2cNoplateExitServiceImpl implements NoplateExitService {

    @Autowired
    private ManageServiceImpl manageService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private DeviceDownServiceFactory deviceDownServiceFactory;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse<Void> noplateExit(NoplateExitRequest noplateExitRequest) {
        String plateNum = noplateExitRequest.getPlateNum();
        String parkCode = noplateExitRequest.getParkCode();

        DataExitRequest exitRequest = new DataExitRequest();
        exitRequest.setOffLine(noplateExitRequest.isOffLine());
        exitRequest.setAisleCode(noplateExitRequest.getChannelId());
        String orderNum = noplateExitRequest.getOrderNum();
        ObjectResponse<OrderInfo> inPark;
        if (orderNum != null) {
            inPark = orderService.findByOrderNum(noplateExitRequest.getOrderNum());
        } else {
            inPark = orderService.findInPark(plateNum, parkCode);
        }
        if (ObjectResponse.isSuccess(inPark)) {
            OrderInfo orderInfo = inPark.getData();
            exitRequest.setCarType(orderInfo.getCarType());
            exitRequest.setType(orderInfo.getType());
            exitRequest.setOrderNum(orderInfo.getOrderNum());
            exitRequest.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
        } else {
            log.info("[车辆离场] 未找到在场记录，单独执行开闸，车牌号[{}]", plateNum);
            if (noplateExitRequest.isOffLine()) {
                return ObjectResponse.success();
            }
            String serialNumber = cacheHandle.getSerialNumber(parkCode, noplateExitRequest.getChannelId());
            return deviceDownServiceFactory.buildRemoteOperaService(parkCode).execute(SwitchTypeEnum.开闸.getType(),
                    parkCode, serialNumber, noplateExitRequest.getPlateNum(), noplateExitRequest.getTopic(),
                    RemoteSwitchRequest.ExtraInfo.builder()
                            .biz(RemoteSwitchRequest.ExtraInfoEnum.STANDARD.val).build());
        }
        exitRequest.setParkCode(parkCode);
        exitRequest.setPlateNum(plateNum);
        exitRequest.setExitTime(new Date(noplateExitRequest.getExitTime() * 1000));
        exitRequest.setTopic(noplateExitRequest.getTopic());
        exitRequest.setExitWay(noplateExitRequest.getExitWay());
        exitRequest.setOperAccount(noplateExitRequest.getOperAccount());
        exitRequest.setExitTerminal(noplateExitRequest.getExitTerminal());
        return manageService.allowExit(exitRequest);
    }
}
