package com.icetech.park.service.down.p2c.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.icetech.cloudcenter.api.NoplateEnterService;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.NoplateEnterRequest;
import com.icetech.park.service.impl.ManageServiceImpl;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;

@Service
public class P2cNoplateEnterServiceImpl implements NoplateEnterService {

    @Autowired
    private ManageServiceImpl manageService;

    @Override
    public ObjectResponse<Void> noplateEnter(NoplateEnterRequest noplateEnterRequest) {
        String orderNum = noplateEnterRequest.getOrderNum() == null
                ? CodeTools.GenerateOrderNum() : noplateEnterRequest.getOrderNum();
        DataEnterRequest enterRequest = new DataEnterRequest();
        enterRequest.setAisleCode(noplateEnterRequest.getChannelId());
        enterRequest.setParkCode(noplateEnterRequest.getParkCode());
        enterRequest.setOrderNum(orderNum);
        enterRequest.setPlateNum(noplateEnterRequest.getPlateNum());
        //临时车
        enterRequest.setType(PlateTypeEnum.临时车.getType());
        enterRequest.setEnterTime(noplateEnterRequest.getEnterTime());
        enterRequest.setOffLine(noplateEnterRequest.isOffLine());
        enterRequest.setTopic(noplateEnterRequest.getTopic());
        enterRequest.setEnterWay(noplateEnterRequest.getInoutEvent());
        return manageService.allowEnter(enterRequest);
    }
}
