package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.config.OssProxyProperties;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.domain.request.p2c.OssConfigRequest;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.oss.OSSProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("p2cOssConfigServiceImpl")
@Slf4j
public class OssConfigServiceImpl extends AbstractService implements ResponseService<String>, DownService<OssConfigRequest, Void> {

    @Autowired
    private OSSProperties ossProperties;
    @Autowired
    private OssProxyProperties ossProxyProperties;
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo) {
        String parkCode = vo.getParkCode();
        List<BatchSendVO.SubTaskInfo> subTaskInfos = vo.getSubTaskInfos();
        subTaskInfos.forEach(subTaskInfo -> send(parkCode, subTaskInfo.getSn()));
        return ObjectResponse.success();
    }

    public boolean send(String parkCode, String deviceNo) {

        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park data = byParkCode.getData();
        Long parkId = data.getId();
        OssConfigRequest ossConfigRequest = new OssConfigRequest();
        if (OSSProperties.OSS_TYPE_CTYUN.equals(ossProperties.getType())) {
            ossConfigRequest.setOssType(8);
        } else {
            ossConfigRequest.setOssType(1);
        }
        if (ossProxyProperties != null && ossProxyProperties.isEnable()) {
            ossConfigRequest.setAccessKeyId(ossProxyProperties.getAccessKeyId());
            ossConfigRequest.setAccessKeySecret(ossProxyProperties.getAccessKeySecret());
            ossConfigRequest.setBucketName(ossProxyProperties.getBucketName());
            ossConfigRequest.setEndpoint(ossProxyProperties.getEndpoint());
        } else {
            ossConfigRequest.setAccessKeyId(ossProperties.getAccessKeyId());
            ossConfigRequest.setAccessKeySecret(ossProperties.getAccessKeySecret());
            ossConfigRequest.setBucketName(ossProperties.getBucketName());
            ossConfigRequest.setEndpoint(ossProperties.getEndpoint());
        }
        Message<OssConfigRequest> message = new Message<>(parkId, P2cDownCmdEnum.OSS配置下发.getCmdType(), ossConfigRequest);
        //组装参数
        String messageId = p2cDownHandle.send(parkCode, deviceNo, message);
        if (messageId == null) {
            log.info("[端云-OSS配置下发] 下发失败，参数[{}]", ossConfigRequest);
            return false;
        } else {
            return true;
        }
    }

}
