package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.OfflineRecordRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


@Service("p2cOfflineRecordServiceImpl")
@Slf4j
public class OfflineRecordServiceImpl extends AbstractService
        implements ResponseService<String>, DownService<OfflineRecordRequest, Void> {

    @Resource
    private SendMsgServiceImpl sendMsgService;

    public ObjectResponse<Void> send(Long parkId, String parkCode, String plateNum) {
        OfflineRecordRequest request = new OfflineRecordRequest();
        request.setPlateNum(plateNum);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkId);
        sendRequest.setServiceType(P2cDownCmdEnum.触发脱机记录上报.getCmdType());
        return sendMsgService.send2Park(sendRequest, parkCode, request);
    }

}
