package com.icetech.park.service.down.p2c.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.icetech.basics.config.GrayProperties;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.LedsoundConfigRequest;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.dto.LedConfigDTO;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.utils.JsonUtils;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.ONE;

@Service("p2cLedsoundConfigServiceImpl")
@Slf4j
@RefreshScope
public class LedsoundConfigServiceImpl extends AbstractConfigDownService implements ResponseService<String>, DownService<LedsoundConfigRequest, Void> {

    @Autowired
    private LedService ledService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Value("${web.url}")
    private String webUrl;
    @Autowired
    private BatchDownConfigHandle<Object> batchDownConfigHandle;
    //忽略下发的内容
    private List<String> IGNORE = Arrays.asList("\\{12\\}");

    @Value("${model.config}")
    private String modelConfig;
    @Resource
    private RedisHandle redisHandle;

    @Autowired
    private GrayProperties grayProperties;

    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;

    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess(byParkCode)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "车场信息不存在"));
        }
        Park park = byParkCode.getData();
        Long channelId = sendRequest.getServiceId();
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess(channelResp)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "通道信息不存在"));
        }
        ParkInoutdevice channel = channelResp.getData();
        LedsoundConfigRequest ledsoundConfigRequest = generateRequest(park, channel);
        return sendMsgService.send2Channel(sendRequest, parkCode, channel.getInandoutCode(), ledsoundConfigRequest);
    }

    /**
     * 初始化下发
     * @param parkCode 车场编号
     * @param serialNumber 相机SN
     * @return 响应
     */
    public boolean send(String parkCode, ParkInoutdevice channel, String serialNumber, String version){
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        Long parkId = park.getId();

        LedsoundConfigRequest ledsoundConfigRequest = generateRequest(park, channel);
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(serialNumber);
        if (version == null) {
            version = deviceInfo.getVersion();
        }
//        if (deviceInfo != null && P2cVersionEnum.版本3.getIndex() <= P2cVersionEnum.getIndex(version)
//            && NumberUtils.toPrimitive(deviceInfo.getInandoutType()) == 2) {
//            if (ledsoundConfigRequest.getFreePerLineColorExit() != null) {
//                ledsoundConfigRequest.setFreePerLineColor(ledsoundConfigRequest.getFreePerLineColorExit());
//            }
//            if (ledsoundConfigRequest.getBusyPerLineColorExit() != null) {
//                ledsoundConfigRequest.setBusyPerLineColor(ledsoundConfigRequest.getBusyPerLineColorExit());
//            }
//        }
//        // 协议中没有定义的多余参数置空
//        ledsoundConfigRequest.setFreePerLineColorEnter(null);
//        ledsoundConfigRequest.setFreePerLineColorExit(null);
//        ledsoundConfigRequest.setBusyPerLineColorEnter(null);
//        ledsoundConfigRequest.setBusyPerLineColorExit(null);
        ledsoundConfigRequest.buildByVersion(version);
        Message<LedsoundConfigRequest> message = new Message<>(parkId, P2cDownCmdEnum.自定义语音屏显配置.getCmdType(), ledsoundConfigRequest);
        String messageId = p2cDownHandle.send(parkCode, serialNumber, message);
        return messageId != null;
    }

    /**
     * 生成下发参数
     * @param park 车场实体
     * @param channel 车场通道
     * @return 响应
     */
    private LedsoundConfigRequest generateRequest(Park park, ParkInoutdevice channel) {
        Long parkId = park.getId();
        int channelType = NumberUtils.toPrimitive(channel.getInandoutType());
        int reverseChannelType = channelType == 1 ? 2 : 1;
        ObjectResponse<List<ParkInoutdevice>> otherChannels = parkService.getChannelByType(parkId, reverseChannelType);
        Long reverseChannelId = Optional.ofNullable(otherChannels)
                .map(ObjectResponse::getData).filter(CollectionUtils::isNotEmpty)
                .map(list -> list.get(0)).map(ParkInoutdevice::getId).orElse(null);
        return generateRequest(park, channel, reverseChannelId);
    }

    private LedsoundConfigRequest generateRequest(Park park, ParkInoutdevice channel, Long reverseChannelId) {
        Long parkId = park.getId(), channelId = channel.getId();
        Map<Integer, LedShowDto> ledDtoMap = ledService.getLedShowDtoMapByChannel(channelId);
        Map<Integer, LedShowDto> reverseLedDtoMap = ledService.getLedShowDtoMapByChannel(reverseChannelId);
        Map<Integer, LedShowDto> enterLedDtoMap = null, exitLedDtoMap = null;
        if (channel.getInandoutType() == 1) {
            enterLedDtoMap = ledDtoMap;
            exitLedDtoMap = reverseLedDtoMap;
        } else {
            enterLedDtoMap = reverseLedDtoMap;
            exitLedDtoMap = ledDtoMap;
        }
        LedShowDto entranceFree = enterLedDtoMap.get(LedShow.DisplayTypeEnum.入口空闲显示.type);
        LedShowDto enterShow = enterLedDtoMap.get(LedShow.DisplayTypeEnum.入场显示.type);
        LedShowDto exitFree = exitLedDtoMap.get(LedShow.DisplayTypeEnum.出口空闲显示.type);
        LedShowDto exitShow = exitLedDtoMap.get(LedShow.DisplayTypeEnum.出场显示.type);

        ObjectResponse<LedConfig> ledsoundConfigObjectResponse = ledService.getLedConfigByChannel(channelId);
        LedConfig ledsoundConfig = ledsoundConfigObjectResponse.getData();

        LedsoundConfigRequest ledsoundConfigRequest = new LedsoundConfigRequest();

        if (channel.getLedcardType() == null || channel.getTtsType() == null) {
            log.info("<自定义语音屏显> 未配置控制卡类型和是否支持TTS, 车场编号：{}, 通道编号: {}", park.getParkCode(), channel.getInandoutCode());
            throw new ResponseBodyException(CodeConstants.ERROR_400, "请先配置控制卡类型和是否支持TTS");
        }else{
            ledsoundConfigRequest.setLedcardType(channel.getLedcardType());
            ledsoundConfigRequest.setSupportTTS(channel.getTtsType());
            if (StringUtils.isNotBlank(modelConfig)) {
                List<LedConfigDTO> ledConfigDTOS = JsonUtils.fromJson(modelConfig, new TypeReference<List<LedConfigDTO>>() {
                });
                ObjectResponse<List<ParkDevice>> devices = parkDeviceService.getDeviceListByChannelId(channelId, 1);
                if (ObjectResponse.isSuccess(devices)) {
                    List<ParkDevice> data = devices.getData();
                    if (CollectionUtils.isNotEmpty(data)) {
                        Set<String> productModels = data.stream()
                                .map(ParkDevice::getProductModel)
                                .filter(Objects::nonNull)
                                .collect(Collectors.toSet());
                        for (LedConfigDTO dto : ledConfigDTOS) {
                            if (productModels.contains(dto.getModel())) {
                                ledsoundConfigRequest.setLedcardType(dto.getValue());
                                ledsoundConfigRequest.setSupportTTS(dto.getTtsType());
                                if (channelId != null && (!channel.getLedcardType().equals(dto.getValue()) ||
                                        !channel.getTtsType().equals(dto.getTtsType()))) {
                                    log.info("[设备属性上报接口]控制卡类型和tts有其中一不一致, id[{}]", channel);
                                    ParkInoutdevice update = new ParkInoutdevice();
                                    update.setId(channelId);
                                    update.setLedcardType(dto.getValue());
                                    update.setTtsType(dto.getTtsType());
                                    parkInoutdeviceDao.updateById(update);
                                    // 删除缓冲
                                    String deleteKey = RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL + channelId;
                                    String deleteCode = RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL_CODE  + channel.getInandoutCode();
                                    if (grayProperties.isCacheEnable()) {
                                        deleteKey = RedisKeyConstants.KEY_PREFIX_GRAY + deleteKey;
                                        deleteCode = RedisKeyConstants.KEY_PREFIX_GRAY + deleteCode;
                                    }
                                    redisHandle.delete(deleteKey);
                                    redisHandle.delete(deleteCode);
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        ledsoundConfigRequest.setStyle(ledsoundConfig.getStyle());
        if (channel.getInandoutType() == 1) {
            ledsoundConfigRequest.setFreePerLineColor(entranceFree.getLedColor());
            ledsoundConfigRequest.setBusyPerLineColor(enterShow.getLedColor());
        } else {
            ledsoundConfigRequest.setFreePerLineColor(exitFree.getLedColor());
            ledsoundConfigRequest.setBusyPerLineColor(exitShow.getLedColor());
        }
//        ledsoundConfigRequest.setFreePerLineColorEnter(entranceFree.getLedColor());
//        ledsoundConfigRequest.setBusyPerLineColorEnter(enterShow.getLedColor());
//        ledsoundConfigRequest.setFreePerLineColorExit(exitFree.getLedColor());
//        ledsoundConfigRequest.setBusyPerLineColorExit(exitShow.getLedColor());
        ledsoundConfigRequest.setLedQrcodeRule(ledsoundConfig.getLedQrcodeRule());
        if (ledsoundConfig.getLedQrcodeRule() != null && ledsoundConfig.getLedQrcodeRule()== 1){
            ledsoundConfigRequest.setDynamicQR(webUrl + "/h5/pay/exitDynamicQR");
        }

        /*
         * 屏显配置开始
         */
        List<LedsoundConfigRequest.LedConfig> ledConfig = new ArrayList<>();
        List<LedsoundConfigRequest.SoundConfig> soundConfig = new ArrayList<>();


        LedsoundConfigRequest.LedConfig ledConfig_entranceFree = new LedsoundConfigRequest.LedConfig();
        String entranceFreeContent = entranceFree.getContent();
        ledConfig_entranceFree.setShowScene(LedsoundConfigRequest.SceneEnum.入口空闲显示.scene);
        ledConfig_entranceFree.setContent(entranceFreeContent);
        ledConfig.add(ledConfig_entranceFree);

        LedsoundConfigRequest.LedConfig ledConfig_exitFree = new LedsoundConfigRequest.LedConfig();
        String exitFreeContent = exitFree.getContent();
        ledConfig_exitFree.setShowScene(LedsoundConfigRequest.SceneEnum.出口空闲显示.scene);
        ledConfig_exitFree.setContent(exitFreeContent);
        ledConfig.add(ledConfig_exitFree);

        /*
         * sceneEnterArr与resultCodeEnterArr必须一一对应
         */
        int[] showSceneEnterArr = {
                /*
                 * 1.2版本
                */
                LedsoundConfigRequest.SceneEnum.月卡车入场.scene,
                LedsoundConfigRequest.SceneEnum.其他允许的入场.scene,
                /*
                 * 1.3脱机计费增加
                */
                LedsoundConfigRequest.SceneEnum.临时车入场不允许临时车进.scene,
                LedsoundConfigRequest.SceneEnum.黑名单车辆入场.scene,
                LedsoundConfigRequest.SceneEnum.其他不允许入场的车辆.scene,
                LedsoundConfigRequest.SceneEnum.多位多车入场车位占用.scene,
                LedsoundConfigRequest.SceneEnum.入场月卡过期.scene,
                LedsoundConfigRequest.SceneEnum.入场虚假车牌.scene,
        };
        FlowCondition.ResultCode[] resultCodeEnterArr = {
                FlowCondition.ResultCode.月卡车,
                FlowCondition.ResultCode.有牌车允许临时车进入,
                FlowCondition.ResultCode.有牌车不允许临时车进入,
                FlowCondition.ResultCode.黑名单车,
                FlowCondition.ResultCode.黄牌车禁止入场,
                FlowCondition.ResultCode.车位已占,
                FlowCondition.ResultCode.过期卡,
                FlowCondition.ResultCode.虚假车牌,
        };
        /*
         * sceneExitArr与resultCodeExitArr必须一一对应
         */
        int[] showSceneExitArr = {
                /*
                 * 1.2版本
                */
                LedsoundConfigRequest.SceneEnum.月卡车离场.scene,
                LedsoundConfigRequest.SceneEnum.其他无需缴费的离场.scene,
                /*
                 * 1.3脱机计费增加
                */
                LedsoundConfigRequest.SceneEnum.黑名单车出场.scene,
                LedsoundConfigRequest.SceneEnum.无牌车出场.scene,
                LedsoundConfigRequest.SceneEnum.出场需缴费.scene,
                LedsoundConfigRequest.SceneEnum.出场无入场记录.scene,
                LedsoundConfigRequest.SceneEnum.出场虚假车牌.scene,
        };
        FlowCondition.ResultCode[] resultCodeExitArr = {
                FlowCondition.ResultCode.月卡车,
                FlowCondition.ResultCode.无需缴费,
                FlowCondition.ResultCode.黑名单车,
                FlowCondition.ResultCode.无牌车允许进出,
                FlowCondition.ResultCode.需缴费,
                FlowCondition.ResultCode.无入场记录,
                FlowCondition.ResultCode.虚假车牌,
        };
        String enterContent = enterShow.getContent();
        for (String node : IGNORE) {
            enterContent = enterContent.replaceAll(node, "");
        }
        ObjectResponse<LedTips> specialLedResp = ledService.getLedTipsByChannel(channelId);
        LedTips ledTips = specialLedResp.getData();
        for(int i = 0; i < showSceneEnterArr.length; i++){
            LedsoundConfigRequest.LedConfig ledConfigItem = new LedsoundConfigRequest.LedConfig();
            ledConfigItem.setShowScene(showSceneEnterArr[i]);
            ledConfigItem.setContent(showReplaceOther(enterContent, ledTips, resultCodeEnterArr[i]));
            ledConfig.add(ledConfigItem);
        }
        String exitContent = exitShow.getContent();
        for (String node : IGNORE) {
            exitContent = exitContent.replaceAll(node, "");
        }
        for(int i = 0; i < showSceneExitArr.length; i++) {
            LedsoundConfigRequest.LedConfig ledConfigItem = new LedsoundConfigRequest.LedConfig();
            ledConfigItem.setShowScene(showSceneExitArr[i]);
            ledConfigItem.setContent(showReplaceOther(exitContent, ledTips, resultCodeExitArr[i]));
            ledConfig.add(ledConfigItem);
        }


        /*
         * 语音配置开始
         */
        int[] saySceneArr = {
                LedsoundConfigRequest.SceneEnum.月卡车入场.scene,
                LedsoundConfigRequest.SceneEnum.其他允许的入场.scene,
                LedsoundConfigRequest.SceneEnum.月卡车离场.scene,
                LedsoundConfigRequest.SceneEnum.其他无需缴费的离场.scene,
                /*
                 * 1.3脱机计费增加
                */
                LedsoundConfigRequest.SceneEnum.临时车入场不允许临时车进.scene,
                LedsoundConfigRequest.SceneEnum.黑名单车辆入场.scene,
                LedsoundConfigRequest.SceneEnum.其他不允许入场的车辆.scene,
                LedsoundConfigRequest.SceneEnum.多位多车入场车位占用.scene,
                LedsoundConfigRequest.SceneEnum.入场月卡过期.scene,
                LedsoundConfigRequest.SceneEnum.入场虚假车牌.scene,

                LedsoundConfigRequest.SceneEnum.黑名单车出场.scene,
                LedsoundConfigRequest.SceneEnum.无牌车出场.scene,
                LedsoundConfigRequest.SceneEnum.出场需缴费.scene,
                LedsoundConfigRequest.SceneEnum.出场无入场记录.scene,
                LedsoundConfigRequest.SceneEnum.出场虚假车牌.scene,
        };
        int[] soundTypeArr = {
                LedSound.SoundTypeEnum.入场月卡车_内部车辆.type,
                LedSound.SoundTypeEnum.入场临时车.type,
                LedSound.SoundTypeEnum.出场月卡车.type,
                LedSound.SoundTypeEnum.出场免费车辆_临时特殊.type,
                /*
                 * 1.3脱机计费增加
                */
                LedSound.SoundTypeEnum.临时车禁止通行.type,
                LedSound.SoundTypeEnum.黑名单车辆进出场.type,
                LedSound.SoundTypeEnum.临时车禁止通行.type,
                LedSound.SoundTypeEnum.多位多车车位占用.type,
                LedSound.SoundTypeEnum.入场临时车.type,
                LedSound.SoundTypeEnum.入口虚假车牌.type,

                LedSound.SoundTypeEnum.黑名单车辆进出场.type,
                LedSound.SoundTypeEnum.出场无牌车.type,
                LedSound.SoundTypeEnum.出场收费车辆.type,
                LedSound.SoundTypeEnum.出场无入场记录.type,
                LedSound.SoundTypeEnum.出口虚假车牌.type,
        };

        boolean containsLimit = false;
        Map<Integer, LedSoundDto> soundDtoMap = ledService.getLedSoundDtoMapByChannel(channelId);
        for (int i = 0; i < soundTypeArr.length; i++) {
            LedSoundDto soundVo = soundDtoMap.get(soundTypeArr[i]);
            LedsoundConfigRequest.SoundConfig soundConfig_monthEnter = new LedsoundConfigRequest.SoundConfig();
            soundConfig_monthEnter.setSayScene(saySceneArr[i]);
            soundConfig_monthEnter.setContent(soundVo.getContent());
            soundConfig.add(soundConfig_monthEnter);
            if (soundVo.getContent().contains("{2}")) {
                containsLimit = true;
            }
        }

        ledsoundConfigRequest.setLedConfig(ledConfig);
        ledsoundConfigRequest.setSoundConfig(soundConfig);
        ledsoundConfigRequest.setLedRestoreDefaultTime(ledsoundConfig.getLedRestoreDefaultTime());
        ledsoundConfigRequest.setVolumeValue(ledsoundConfig.getVolumeValue());
        ledsoundConfigRequest.setQuietHoursSwitch(ledsoundConfig.getQuietHoursSwitch());
        /*
         * 设置一些非必填项
         */
        if (entranceFreeContent.contains("{2}") || exitFreeContent.contains("{2}")
                || containsLimit){//今日限行
            ledsoundConfigRequest.setLimitType(ledsoundConfig.getLimitType() == null ? 1 : ledsoundConfig.getLimitType());
            if(ledsoundConfig.getLimitType() != null && ledsoundConfig.getLimitType() == 0){
                ledsoundConfigRequest.setLimitDriveNum1(ledsoundConfig.getLimitDriveNum1());
                ledsoundConfigRequest.setLimitDriveNum2(ledsoundConfig.getLimitDriveNum2());
                ledsoundConfigRequest.setLimitDriveNum3(ledsoundConfig.getLimitDriveNum3());
                ledsoundConfigRequest.setLimitDriveNum4(ledsoundConfig.getLimitDriveNum4());
                ledsoundConfigRequest.setLimitDriveNum5(ledsoundConfig.getLimitDriveNum5());
            }
        }
        if (ledsoundConfig.getRegionFreeSpace() == null || ledsoundConfig.getRegionFreeSpace() == 0) {
            ParkFreespace parkFreespace = parkFreeSpaceService.getSpaceByPark(parkId).getData();
            ledsoundConfigRequest.setFreeSpace(parkFreespace == null ? 0 : parkFreespace.getFreeSpace());
            ledsoundConfigRequest.setRealFreeSpace(parkFreespace == null ? 0 : parkFreespace.getRealFreeSpace());
            ledsoundConfigRequest.setTotalSpace(parkFreespace == null ? 0 : parkFreespace.getTotalNum());
        } else {
            ParkRegion parkRegion = parkRegionDao.selectById(ledsoundConfig.getRegionFreeSpace());
            if (parkRegion == null) {
                ParkFreespace parkFreespace = parkFreeSpaceService.getSpaceByPark(parkId).getData();
                ledsoundConfigRequest.setFreeSpace(parkFreespace == null ? 0 : parkFreespace.getFreeSpace());
                ledsoundConfigRequest.setRealFreeSpace(parkFreespace == null ? 0 : parkFreespace.getRealFreeSpace());
                ledsoundConfigRequest.setTotalSpace(parkFreespace == null ? 0 : parkFreespace.getTotalNum());
            } else {
                ledsoundConfigRequest.setFreeSpace(parkRegion.getFreePark() == null ? 0 : parkRegion.getFreePark());
                ledsoundConfigRequest.setRealFreeSpace(parkRegion.getRealFreePark() == null ? 0 : parkRegion.getRealFreePark());
                ledsoundConfigRequest.setTotalSpace(parkRegion.getRegionPark() == null ? 0 : parkRegion.getRegionPark());
            }
        }
        if(ledsoundConfig.getLedExpireDaysMc() == null){
            ledsoundConfigRequest.setLedExpireDaysMc(0);
        }else{
            ledsoundConfigRequest.setLedExpireDaysMc(ledsoundConfig.getLedExpireDaysMc());
        }
        if (ledsoundConfig.getLedExpireDaysMc() != null && ledsoundConfig.getLedExpireDaysMc() > 0) {
            ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
            ledsoundConfigRequest.setIsExpireMc(configObjectResponse.getData().getIsExpireMc());
        }
        if (ledsoundConfig.getQuietHoursSwitch() == 1){
            ledsoundConfigRequest.setQuietStartTime(ledsoundConfig.formatQuietStartTime());
            ledsoundConfigRequest.setQuietEndTime(ledsoundConfig.formatQuietEndTime());
            ledsoundConfigRequest.setQuietVolumeValue(ledsoundConfig.getQuietVolumeValue());
        }
        if (enterContent.contains("{6}") || exitContent.contains("{6}") || entranceFreeContent.contains("{6}") || exitFreeContent.contains("{6}")){//剩余车位
            ledsoundConfigRequest.setParkName(park.getParkName());
        }
        if (ledsoundConfig.getLedRemainDaysMc() > 0){//剩余车位
            ledsoundConfigRequest.setLedRemainDaysMc(ledsoundConfig.getLedRemainDaysMc());
        }
        ledsoundConfigRequest.setShowLanguage(1);
        ledsoundConfigRequest.setVoiceLanguage(1);
        return ledsoundConfigRequest;
    }

    private String showReplaceOther(String content, LedTips ledTips, FlowCondition.ResultCode resultCode) {
        if (content.contains("{8}")) {
            content = content.replace("{8}", ledShowHandle.enterTips(ledTips, resultCode));
        } else if (content.contains("{9}")) {
            content = content.replace("{9}", ledShowHandle.exitTips(ledTips, resultCode, null));
        }
        return content;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        Integer subTaskId = redisUtils.get(RedisConstants.BATCH_DOWN_MSGID + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null){
            batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.自定义语音屏显配置.getCmdType());
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo, BatchSendVO.SubTaskInfo subTaskInfo) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(vo.getParkCode());
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        ObjectResponse<List<ParkInoutdevice>> channelsResp = parkService.getInoutByParkId(vo.getParkId());
        List<ParkInoutdevice> channels = channelsResp.getData();
        Long enterChannelId = null, exitChannelId = null;
        for (ParkInoutdevice channel : channels) {
            if (channel.getInandoutType() == 1 && enterChannelId == null) enterChannelId = channel.getId();
            else if (channel.getInandoutType() == 2 && exitChannelId == null) exitChannelId = channel.getId();
        }
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(subTaskInfo.getChannelId());
        ParkInoutdevice channel = channelResp.getData();
        Long reverseChannelId = channel.getInandoutType() == 1 ? exitChannelId : enterChannelId;
        LedsoundConfigRequest ledsoundConfigRequest = generateRequest(park, channel, reverseChannelId);
        batchDownConfigHandle.batchDown(vo, ledsoundConfigRequest, P2cDownCmdEnum.自定义语音屏显配置.getCmdType());
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(vo.getParkCode());
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(vo.getChannelId());
        ParkInoutdevice channel = channelResp.getData();
        LedsoundConfigRequest ledsoundConfigRequest = generateRequest(park, channel);
        batchDownConfigHandle.repeatBatch(vo, ledsoundConfigRequest, P2cDownCmdEnum.自定义语音屏显配置.getCmdType());
        return ObjectResponse.success();
    }
}
