package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.LcdConfigRequest;
import com.icetech.cloudcenter.domain.response.LcdDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.lcd.LcdBrightness;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.handle.showsay.LcdShowHandle;
import com.icetech.third.utils.RedisUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.ONE;

@Service("p2cLcdConfigServiceImpl")
public class LcdConfigServiceImpl extends AbstractConfigDownService implements ResponseService<String>, DownService<LcdConfigRequest, Void> {

    @Autowired
    private LcdService lcdService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private LcdShowHandle lcdShowHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Value("${web.url}")
    private String webUrl;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private BatchDownConfigHandle<Object> batchDownConfigHandle;
    @Autowired
    private ParkRegionDao parkRegionDao;
    //忽略下发的内容
    private List<String> IGNORE = Arrays.asList("\\{12\\}");

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long channelId = sendRequest.getServiceId();
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess(channelResp)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "通道信息不存在"));
        }
        ParkInoutdevice channel = channelResp.getData();
        LcdConfigRequest lcdConfigRequest = generateRequest(sendRequest.getParkId(), channel);
        return sendMsgService.send2Channel(sendRequest, parkCode, channel.getInandoutCode(), lcdConfigRequest);
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo, BatchSendVO.SubTaskInfo subTaskInfo) {
        Long parkId = vo.getParkId();
        ObjectResponse<List<ParkInoutdevice>> channelsResp = parkService.getInoutByParkId(parkId);
        List<ParkInoutdevice> channels = channelsResp.getData();
        Long enterChannelId = null, exitChannelId = null;
        for (ParkInoutdevice channel : channels) {
            if (channel.getInandoutType() == 1 && enterChannelId == null) enterChannelId = channel.getId();
            else if (channel.getInandoutType() == 2 && exitChannelId == null) exitChannelId = channel.getId();
        }
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(subTaskInfo.getChannelId());
        ParkInoutdevice channel = channelResp.getData();
        Long reverseChannelId = channel.getInandoutType() == 1 ? exitChannelId : enterChannelId;
        LcdConfigRequest lcdConfigRequest = generateRequest(parkId, channel, reverseChannelId);
        batchDownConfigHandle.batchDown(vo, lcdConfigRequest, P2cDownCmdEnum.LCD自定义语音屏显配置.getCmdType());
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        Long parkId = vo.getParkId();
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(vo.getChannelId());
        ParkInoutdevice channel = channelResp.getData();
        LcdConfigRequest lcdConfigRequest = generateRequest(parkId, channel);
        batchDownConfigHandle.repeatBatch(vo, lcdConfigRequest, P2cDownCmdEnum.LCD自定义语音屏显配置.getCmdType());
        return ObjectResponse.success();
    }

    /**
     * 初始化下发
     * @param parkCode 车场编号
     * @param serialNumber 相机编号
     * @return 响应
     */
    public boolean send(String parkCode, ParkInoutdevice channel, String serialNumber){
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(parkObjectResponse);
        Park park = parkObjectResponse.getData();
        Long parkId = park.getId();

        LcdConfigRequest lcdConfigRequest = generateRequest(park.getId(), channel);
        Message<LcdConfigRequest> message = new Message<>(parkId, P2cDownCmdEnum.LCD自定义语音屏显配置.getCmdType(), lcdConfigRequest);
        String messageId = p2cDownHandle.send(parkCode, serialNumber, message);
        return messageId != null;

    }

    /**
     * 生成下发参数
     * @param parkId 车场id
     * @param channel 通道信息
     * @return 响应
     */
    private LcdConfigRequest generateRequest(Long parkId, ParkInoutdevice channel) {
        int channelType = NumberUtils.toPrimitive(channel.getInandoutType());
        int reverseChannelType = channelType == 1 ? 2 : 1;
        ObjectResponse<List<ParkInoutdevice>> otherChannels = parkService.getChannelByType(parkId, reverseChannelType);
        Long reverseChannelId = Optional.ofNullable(otherChannels)
                .map(ObjectResponse::getData).filter(CollectionUtils::isNotEmpty)
                .map(list -> list.get(0)).map(ParkInoutdevice::getId).orElse(null);
        return generateRequest(parkId, channel, reverseChannelId);
    }

    private LcdConfigRequest generateRequest(Long parkId, ParkInoutdevice channel, Long reverseChannelId) {
        Long channelId = channel.getId();
        int channelType = NumberUtils.toPrimitive(channel.getInandoutType());
        Map<Integer, LcdDto> lcdDtoMap = lcdService.getLcdShowDtoMapByChannel(channelId);
        Map<Integer, LcdDto> otherLcdDtoMap = lcdService.getLcdShowDtoMapByChannel(reverseChannelId);
        Map<Integer, LcdDto> enterLcdDtoMap = null, exitLcdDtoMap = null;
        if (channelType == 1) {
            enterLcdDtoMap = lcdDtoMap;
            exitLcdDtoMap = otherLcdDtoMap;
        } else {
            enterLcdDtoMap = otherLcdDtoMap;
            exitLcdDtoMap = lcdDtoMap;
        }
        LcdDto entranceFree = enterLcdDtoMap.get(LedShow.DisplayTypeEnum.入口空闲显示.type);
        LcdDto enterShow = enterLcdDtoMap.get(LedShow.DisplayTypeEnum.入场显示.type);
        LcdDto exitFree = exitLcdDtoMap.get(LedShow.DisplayTypeEnum.出口空闲显示.type);
        LcdDto exitShow = exitLcdDtoMap.get(LedShow.DisplayTypeEnum.出场显示.type);
        ObjectResponse<LcdConfig> lcdConfigObjectResponse = lcdService.getLcdConfigByChannel(channelId);
        LcdConfig lcdConfig = lcdConfigObjectResponse.getData();

        LcdConfigRequest lcdConfigRequest = new LcdConfigRequest();

        lcdConfigRequest.setLineNum(lcdConfig.getLineNum());
        lcdConfigRequest.setBlackCar(lcdConfig.getBlackCar());
        lcdConfigRequest.setEntraceFreePerLineColor(entranceFree.getLedColor());
        lcdConfigRequest.setEnterPerLineColor(enterShow.getLedColor());
        lcdConfigRequest.setExitFreePerLineColor(exitFree.getLedColor());
        lcdConfigRequest.setExitPerLineColor(exitShow.getLedColor());
        lcdConfigRequest.setEntraceFreeShowType(lcdConfig.getEntranceFreeLayout());
        lcdConfigRequest.setEnterShowType(lcdConfig.getEnterLayout());
        lcdConfigRequest.setExitFreeShowType(lcdConfig.getExitFreeLayout());
        lcdConfigRequest.setExitShowType(lcdConfig.getExitLayout());
        lcdConfigRequest.setDynamicQR(webUrl + "/h5/pay/exitDynamicQR");

        /*
         * 屏显配置开始
         */
        List<LcdConfigRequest.ShowConfig> showConfig = new ArrayList<LcdConfigRequest.ShowConfig>();
        List<LcdConfigRequest.SoundConfig> soundConfig = new ArrayList<LcdConfigRequest.SoundConfig>();


        LcdConfigRequest.ShowConfig ledConfigEntranceFree = new LcdConfigRequest.ShowConfig();
        String entranceFreeContent = entranceFree.getContent();
        ledConfigEntranceFree.setShowScene(LcdConfigRequest.SceneEnum.入口空闲显示.scene);
        ledConfigEntranceFree.setContent(entranceFreeContent);
        showConfig.add(ledConfigEntranceFree);

        LcdConfigRequest.ShowConfig ledConfigExitFree = new LcdConfigRequest.ShowConfig();
        String exitFreeContent = exitFree.getContent();
        ledConfigExitFree.setShowScene(LcdConfigRequest.SceneEnum.出口空闲显示.scene);
        ledConfigExitFree.setContent(exitFreeContent);
        showConfig.add(ledConfigExitFree);

        /*
         * sceneEnterArr与resultCodeEnterArr必须一一对应
         */
        int[] showSceneEnterArr = {
                /*
                 * 1.2版本
                */
                LcdConfigRequest.SceneEnum.月卡车入场.scene,
                LcdConfigRequest.SceneEnum.其他允许的入场.scene,
                /*
                 * 1.3脱机计费增加
                */
                LcdConfigRequest.SceneEnum.临时车入场不允许临时车进.scene,
                LcdConfigRequest.SceneEnum.黑名单车辆入场.scene,
                LcdConfigRequest.SceneEnum.其他不允许入场的车辆.scene,
                LcdConfigRequest.SceneEnum.多位多车入场车位占用.scene,
                LcdConfigRequest.SceneEnum.入场月卡过期.scene,
                LcdConfigRequest.SceneEnum.入场虚假车牌.scene,
        };
        FlowCondition.ResultCode[] resultCodeEnterArr = {
                FlowCondition.ResultCode.月卡车,
                FlowCondition.ResultCode.有牌车允许临时车进入,
                FlowCondition.ResultCode.有牌车不允许临时车进入,
                FlowCondition.ResultCode.黑名单车,
                FlowCondition.ResultCode.黄牌车禁止入场,
                FlowCondition.ResultCode.车位已占,
                FlowCondition.ResultCode.过期卡,
                FlowCondition.ResultCode.虚假车牌,
        };
        /*
         * sceneExitArr与resultCodeExitArr必须一一对应
         */
        int[] showSceneExitArr = {
                /*
                 * 1.2版本
                */
                LcdConfigRequest.SceneEnum.月卡车离场.scene,
                LcdConfigRequest.SceneEnum.其他无需缴费的离场.scene,
                /*
                 * 1.3脱机计费增加
                */
                LcdConfigRequest.SceneEnum.黑名单车出场.scene,
                LcdConfigRequest.SceneEnum.无牌车出场.scene,
                LcdConfigRequest.SceneEnum.出场需缴费.scene,
                LcdConfigRequest.SceneEnum.出场无入场记录.scene,
                LcdConfigRequest.SceneEnum.出场虚假车牌.scene,
        };
        FlowCondition.ResultCode[] resultCodeExitArr = {
                FlowCondition.ResultCode.月卡车,
                FlowCondition.ResultCode.无需缴费,
                FlowCondition.ResultCode.黑名单车,
                FlowCondition.ResultCode.无牌车允许进出,
                FlowCondition.ResultCode.需缴费,
                FlowCondition.ResultCode.无入场记录,
                FlowCondition.ResultCode.虚假车牌,
        };
        String enterContent = enterShow.getContent();
        for (String node : IGNORE) {
            enterContent = enterContent.replaceAll(node, "");
        }
        for(int i = 0; i < showSceneEnterArr.length; i++){
            LcdConfigRequest.ShowConfig ledConfigItem = new LcdConfigRequest.ShowConfig();
            ledConfigItem.setShowScene(showSceneEnterArr[i]);
            ledConfigItem.setContent(showReplaceOther(enterContent, parkId, channelId, resultCodeEnterArr[i]));
            showConfig.add(ledConfigItem);
        }
        String exitContent = exitShow.getContent();
        for (String node : IGNORE) {
            exitContent = exitContent.replaceAll(node, "");
        }
        for(int i = 0; i < showSceneExitArr.length; i++){
            LcdConfigRequest.ShowConfig ledConfigItem = new LcdConfigRequest.ShowConfig();
            ledConfigItem.setShowScene(showSceneExitArr[i]);
            ledConfigItem.setContent(showReplaceOther(exitContent, parkId, channelId, resultCodeExitArr[i]));
            showConfig.add(ledConfigItem);
        }


        /*
         * 语音配置开始
         */
        int[] saySceneArr = {
                LcdConfigRequest.SceneEnum.月卡车入场.scene,
                LcdConfigRequest.SceneEnum.其他允许的入场.scene,
                LcdConfigRequest.SceneEnum.月卡车离场.scene,
                LcdConfigRequest.SceneEnum.其他无需缴费的离场.scene,
                /*
                 * 1.3脱机计费增加
                */
                LcdConfigRequest.SceneEnum.临时车入场不允许临时车进.scene,
                LcdConfigRequest.SceneEnum.黑名单车辆入场.scene,
                LcdConfigRequest.SceneEnum.其他不允许入场的车辆.scene,
                LcdConfigRequest.SceneEnum.多位多车入场车位占用.scene,
                LcdConfigRequest.SceneEnum.入场月卡过期.scene,

                LcdConfigRequest.SceneEnum.黑名单车出场.scene,
                LcdConfigRequest.SceneEnum.无牌车出场.scene,
                LcdConfigRequest.SceneEnum.出场需缴费.scene,
                LcdConfigRequest.SceneEnum.出场无入场记录.scene,
        };
        int[] soundTypeArr = {
                LedSound.SoundTypeEnum.入场月卡车_内部车辆.type,
                LedSound.SoundTypeEnum.入场临时车.type,
                LedSound.SoundTypeEnum.出场月卡车.type,
                LedSound.SoundTypeEnum.出场免费车辆_临时特殊.type,
                /*
                 * 1.3脱机计费增加
                */
                LedSound.SoundTypeEnum.临时车禁止通行.type,
                LedSound.SoundTypeEnum.黑名单车辆进出场.type,
                LedSound.SoundTypeEnum.临时车禁止通行.type,
                LedSound.SoundTypeEnum.多位多车车位占用.type,
                LedSound.SoundTypeEnum.入场临时车.type,

                LedSound.SoundTypeEnum.黑名单车辆进出场.type,
                LedSound.SoundTypeEnum.出场无牌车.type,
                LedSound.SoundTypeEnum.出场收费车辆.type,
                LedSound.SoundTypeEnum.出场无入场记录.type,
        };

        boolean containsLimit = false;
        Map<Integer, LedSoundDto> soundDtoMap = lcdService.getSoundDtoMapByChannel(channelId);
        for (int i = 0; i < soundTypeArr.length; i++) {
            LedSoundDto soundVo = soundDtoMap.get(soundTypeArr[i]);
            LcdConfigRequest.SoundConfig soundConfigMonthEnter = new LcdConfigRequest.SoundConfig();
            soundConfigMonthEnter.setSayScene(saySceneArr[i]);
            soundConfigMonthEnter.setContent(replaceSoundContent(soundVo.getContent()));
            soundConfig.add(soundConfigMonthEnter);
            if (soundVo.getContent().contains("{2}")) {
                containsLimit = true;
            }
        }

        lcdConfigRequest.setShowConfig(showConfig);
        lcdConfigRequest.setSoundConfig(soundConfig);
        lcdConfigRequest.setRestoreDefaultTime(lcdConfig.getRestoreDefaultTime());
        lcdConfigRequest.setVolumeValue(lcdConfig.getVolumeValue());
        lcdConfigRequest.setQuietHoursSwitch(lcdConfig.getQuietHoursSwitch());
        /*
         * 设置一些非必填项
         */
        if (entranceFreeContent.contains("{2}") || exitFreeContent.contains("{2}")
                || containsLimit){//今日限行
            lcdConfigRequest.setLimitType(lcdConfig.getLimitType() == null ? 1 : lcdConfig.getLimitType());
            if(lcdConfig.getLimitType() != null && lcdConfig.getLimitType() == 0){
                lcdConfigRequest.setLimitDriveNum1(lcdConfig.getLimitDriveNum1());
                lcdConfigRequest.setLimitDriveNum2(lcdConfig.getLimitDriveNum2());
                lcdConfigRequest.setLimitDriveNum3(lcdConfig.getLimitDriveNum3());
                lcdConfigRequest.setLimitDriveNum4(lcdConfig.getLimitDriveNum4());
                lcdConfigRequest.setLimitDriveNum5(lcdConfig.getLimitDriveNum5());
            }
        }

        if (lcdConfig.getRegionFreeSpace() == null || lcdConfig.getRegionFreeSpace() == 0) {
            ParkFreespace parkFreespace = parkFreeSpaceService.getSpaceByPark(parkId).getData();
            lcdConfigRequest.setFreeSpace(parkFreespace.getFreeSpace());
            lcdConfigRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
            lcdConfigRequest.setTotalSpace(parkFreespace.getTotalNum());
        } else {
            ParkRegion parkRegion = parkRegionDao.selectById(lcdConfig.getRegionFreeSpace());
            if (parkRegion == null) {
                ParkFreespace parkFreespace = parkFreeSpaceService.getSpaceByPark(parkId).getData();
                lcdConfigRequest.setFreeSpace(parkFreespace.getFreeSpace());
                lcdConfigRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
                lcdConfigRequest.setTotalSpace(parkFreespace.getTotalNum());
            } else {
                lcdConfigRequest.setFreeSpace(parkRegion.getFreePark() == null ? 0 : parkRegion.getFreePark());
                lcdConfigRequest.setRealFreeSpace(parkRegion.getRealFreePark() == null ? 0 : parkRegion.getRealFreePark());
                lcdConfigRequest.setTotalSpace(parkRegion.getRegionPark() == null ? 0 : parkRegion.getRegionPark());
            }
        }

        lcdConfigRequest.setExpireDaysMc(lcdConfig.getExpireDaysMc());
        if (lcdConfig.getExpireDaysMc() != null && lcdConfig.getExpireDaysMc() > 0){
            ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
            lcdConfigRequest.setIsExpireMc(configObjectResponse.getData().getIsExpireMc());
        }
        if (NumberUtils.toPrimitive(lcdConfig.getQuietHoursSwitch()) == 1){
            lcdConfigRequest.setQuietStartTime(lcdConfig.formatQuietStartTime());
            lcdConfigRequest.setQuietEndTime(lcdConfig.formatQuietEndTime());
            lcdConfigRequest.setQuietVolumeValue(lcdConfig.getQuietVolumeValue());
        }
        if (enterContent.contains("{6}") || exitContent.contains("{6}") || entranceFreeContent.contains("{6}") || exitFreeContent.contains("{6}")){//剩余车位
            ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
            lcdConfigRequest.setParkName(parkObjectResponse.getData().getParkName());
        }
        if (lcdConfig.getRemainDaysMc() > 0){
            lcdConfigRequest.setRemainDaysMc(lcdConfig.getRemainDaysMc());
        }
        List<LcdBrightness> lcdBrightnessList = lcdConfig.getLcdBrightnessList();
        List<LcdConfigRequest.BrightnessControl> brightnessControls = new ArrayList<>();

        if (lcdBrightnessList != null && lcdBrightnessList.size() > 0){
            for (LcdBrightness lcdBrightness : lcdBrightnessList){
                LcdConfigRequest.BrightnessControl brightnessControl = new LcdConfigRequest.BrightnessControl();
                BeanUtils.copyProperties(lcdBrightness, brightnessControl);
                brightnessControls.add(brightnessControl);
            }
        }
        lcdConfigRequest.setBrightnessControl(brightnessControls);
        return lcdConfigRequest;
    }

    private String showReplaceOther(String content, Long parkId, Long channelId, FlowCondition.ResultCode resultCode){
        if (content.contains("{8}")){
            content = content.replace("{8}", lcdShowHandle.enterTips(parkId, channelId, resultCode));
        }else if (content.contains("{9}")){
            content = content.replace("{9}", lcdShowHandle.exitTips(parkId, channelId, resultCode, null));
        }
        return content;
    }

    private String replaceSoundContent(String content){
        StringBuilder lineModules = new StringBuilder();
        if (StringUtils.isNotBlank(content)) {
            String[] split1Arr = content.split(" ");
            /*
             * 处理单行的每一个模块
             */
            for (String part : split1Arr) {
                //第X次出现
                lineModules.append("{").append(part).append("}").append(" ");
            }
        }
        return lineModules.toString().trim();
    }
    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        Integer subTaskId = redisUtils.get(RedisConstants.BATCH_DOWN_MSGID + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null){
            batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.LCD自定义语音屏显配置.getCmdType());
    }
}
