package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.EnexRecordTypeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.park.domain.entity.park.ParkRemoteConfig;
import com.icetech.cloudcenter.domain.request.p2c.KeyValueRequest;
import com.icetech.cloudcenter.domain.enumeration.KeyCodeEnum;
import com.icetech.cloudcenter.domain.enumeration.KeyValueEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.park.service.AbstractService;
import com.icetech.cloudcenter.api.ParkRemoteConfigService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.List;

import javax.annotation.Resource;

@Service("p2cKeyValueServiceImpl")
@Slf4j
public class KeyValueServiceImpl extends AbstractService implements ResponseService<String>, DownService<KeyValueRequest, Void> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkService parkService;
    @Resource
    private ParkRemoteConfigService parkRemoteConfigService;

    public boolean send(String parkCode, String deviceNo){

        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park data = byParkCode.getData();
        Long parkId = data.getId();

        ObjectResponse<ParkInoutdevice> channelInfoResponse = parkService.getChannelInfo(parkId, deviceNo);
        String code = channelInfoResponse.getCode();
        if (code.equals(CodeConstants.SUCCESS)){
            ParkInoutdevice parkInoutdevice = channelInfoResponse.getData();
            List<ParkRemoteConfig> parkRemoteConfigs = parkRemoteConfigService.selectByParkId(parkId, parkInoutdevice.getInandoutType());
            if (parkRemoteConfigs == null || parkRemoteConfigs.size() == 0){
                log.info("遥控器键值关系未配置，无需下发，车场：{}", parkCode);
                return false;
            }
            KeyValueRequest keyValueRequest = new KeyValueRequest();
            keyValueRequest.setRemoteType(parkInoutdevice.getInandoutType());
            for (ParkRemoteConfig parkRemoteconfig : parkRemoteConfigs) {
                String keyName = parkRemoteconfig.getKeyName();
                Integer remoteVal = parkRemoteconfig.getRemoteVal();
                String key = KeyValueEnum.getKey(remoteVal);
                setFieldValueByFieldName(KeyCodeEnum.getKey(keyName), keyValueRequest, key);
            }
            Message<KeyValueRequest> message = new Message<>(parkId, P2cDownCmdEnum.遥控器对应关系.getCmdType(), keyValueRequest);
            //组装参数
            String messageId = p2cDownHandle.send(parkCode, deviceNo,message);
            if (messageId == null){
                log.info("<端云-遥控器对应关系> 下发失败，参数:{}", keyValueRequest);
                return false;
            }else{
                return true;
            }
        }else{
            return false;
        }

    }
    public KeyValueRequest getRequest(Long parkId, Integer enexType){
        List<ParkRemoteConfig> parkRemoteConfigs = parkRemoteConfigService.selectByParkId(parkId, enexType);
        KeyValueRequest keyValueRequest = new KeyValueRequest();
        keyValueRequest.setRemoteType(enexType);
        for (int i = 0; parkRemoteConfigs != null && i < parkRemoteConfigs.size(); i++){
            ParkRemoteConfig parkRemoteconfig = parkRemoteConfigs.get(i);
            String keyName = parkRemoteconfig.getKeyName();
            Integer remoteVal = parkRemoteconfig.getRemoteVal();
            String key = KeyValueEnum.getKey(remoteVal);

            setFieldValueByFieldName(KeyCodeEnum.getKey(keyName), keyValueRequest, key);
        }
        return keyValueRequest;
    }
    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode){
        KeyValueRequest enterRequest = getRequest(sendRequest.getParkId(), EnexRecordTypeConstants.ENTER);

        Message<KeyValueRequest> message = new Message<>(sendRequest.getTaskId(), sendRequest.getParkId(), sendRequest.getServiceType(), sendRequest.getServiceId(), enterRequest);
        String[] messageId1 = p2cDownHandle.send2Enter(parkCode, message);

        KeyValueRequest exitRequest = getRequest(sendRequest.getParkId(), EnexRecordTypeConstants.EXIT);
        message.setPayload(exitRequest);
        String[] messageId2 = p2cDownHandle.send2Exit(parkCode, message);
        if ((messageId1 != null && messageId1.length == 0)
                || (messageId2 != null && messageId2.length == 0)){
            log.info("<端云-遥控器对应关系> 下发失败，parkCode：{}", parkCode);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            return ObjectResponse.success();
        }
    }

    /**
     * 根据属性名设置属性值
     *
     * @param fieldName 属性名
     * @param object 对象
     * @return 响应
     */
    private void setFieldValueByFieldName(String fieldName, Object object,String value) {
        try {
            // 获取obj类的字节文件对象
            Class c = object.getClass();
            // 获取该类的成员变量
            Field f = c.getDeclaredField(fieldName);
            // 取消语言访问检查
            f.setAccessible(true);
            // 给变量赋值
            f.set(object, value);
        } catch (Exception e) {
            log.error(String.valueOf(e.getMessage()),e);
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.遥控器对应关系.getCmdType());
    }

}
