package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.ExHintService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.makeup.WsRepeatPush;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.ScheduledThreadPoolExecutor;

@Service("p2cHintServiceImpl")
@Slf4j
public class HintServiceImpl extends AbstractService implements ExHintService, ResponseService<String>, NotifyService<String> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ScheduledThreadPoolExecutor asyncMethodScheduler;

    @Override
    public ObjectResponse<Void> execute(Long parkId, String parkCode, String serialNumber, HintRequest hintRequest) {

        String messageId = showAndSay(parkId, parkCode, serialNumber, hintRequest);
        if (messageId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            ObjectResponse<String> response = cacheHandle.getResponseFromRedis(messageId, 4000L);
            if (ObjectResponse.isSuccess(response)) {
                log.info("消息ID：{}，响应成功", messageId);
            } else {
                log.warn("[监控埋点] alarmType:[{}],keyword1:[{}],keyword2:[{}]", LogWarnTypeEnum.屏显语音失败.name() + "-" + "端云LED",
                        messageId + ", " + parkCode + ", " + hintRequest, response);
                new WsRepeatPush(p2cDownHandle, parkCode, serialNumber).push(asyncMethodScheduler, () -> {
                    String msgId = showAndSay(parkId, parkCode, serialNumber, hintRequest);
                    if (msgId != null) {
                        ObjectResponse<String> response1 = cacheHandle.getResponseFromRedis(msgId, 11000L);
                        log.info("msgId：{} 响应：{}", msgId, response1);
                        return ObjectResponse.isSuccess(response1);
                    } else {
                        return false;
                    }
                });
                log.info("消息ID：{}，响应超时", messageId);
            }
            return ObjectResponse.success();
        }
    }

    /**
     * 更新屏显到入口
     * @param parkId 车场ID
     * @param parkCode 车场编号
     * @param hintRequest hint参数
     * @return 响应
     */
    public ObjectResponse<Void> executeSendEnter(Long parkId, String parkCode, HintRequest hintRequest){
        Message<HintRequest> message = new Message<>(parkId, P2cDownCmdEnum.屏显信息.getCmdType(), hintRequest);
        String[] messageIds = p2cDownHandle.send2Enter(parkCode, message);
        if (messageIds == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            return ObjectResponse.success();
        }
    }

    @Override
    public String showAndSay(Long parkId, String parkCode, String serialNumber, HintRequest hintRequest) {
        Message<HintRequest> message = new Message<>(parkId, P2cDownCmdEnum.屏显信息.getCmdType(), hintRequest);
        return p2cDownHandle.send(parkCode, serialNumber, message);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String serialNumber) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.屏显信息.getCmdType());
    }
}
