package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.FreeSpaceRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.FreeSpaceSyncService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.itc.impl.ItcFreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.ONE;
import static com.icetech.cloudcenter.domain.constants.RedisConstants.PARK_FULL_PROFILE;

@Service("p2cFreeSpaceServiceImpl")
@Slf4j
public class FreeSpaceServiceImpl extends AbstractService implements FreeSpaceSyncService, ResponseService<String>, DownService<FreeSpaceRequest, Void> {

    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ChannelRulesServiceImpl channelRulesService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ItcFreeSpaceServiceImpl itcFreeSpaceService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private LedService ledService;
    @Resource
    private LcdService lcdService;

    @Override
    public ObjectResponse<Void> send2Park(SendRequest sendRequest, Long parkId, String parkCode) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        ObjectResponse.notError(parkObjectResponse);
        Park park = parkObjectResponse.getData();
        if (NumberUtils.toPrimitive(park.getIsInterior()) == 0) {
            ParkFreespace parkFreespace = parkFreeSpaceService.getSpaceByPark(parkId).getData();
            if (parkFreespace == null) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "无车位数据"));
            }
            ParkRegion parkRegion = parkRegionDao.selectOutByParkid(parkId);
            if (parkRegion != null) {
                if (NumberUtils.toPrimitive(parkRegion.getIsFullForbidenter()) == 0
                        && NumberUtils.toPrimitive(parkRegion.getIsFullForbidMonthEnter()) == 0
                        && NumberUtils.toPrimitive(parkRegion.getIsFullForbidVIPEnter()) == 0
                        && NumberUtils.toPrimitive(parkRegion.getIsFullForbidReservEnter()) == 0
                        && NumberUtils.toPrimitive(parkRegion.getIsFullForbidStoreEnter()) == 0) {
                    log.info("[空车位下发接口] 没有配置车位满禁止入场, 无需下发临时车权限, parkCode[{}]", parkCode);
                } else {
                    //处理通道权限
                    handleChannelRule(parkCode, parkId, parkFreespace.getRealFreeSpace(), parkRegion);
                }
            }
            FreeSpaceRequest freeSpaceRequest = new FreeSpaceRequest();
            freeSpaceRequest.setFreeSpace(parkFreespace.getFreeSpace());
            freeSpaceRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
            freeSpaceRequest.setShowFreeSpace(parkFreespace.getFreeSpace());
            freeSpaceRequest.setTotalSpace(parkFreespace.getTotalNum());
            freeSpaceRequest.setTime(DateTools.unixTimestamp());
            sendRequest.setServiceType(P2cDownCmdEnum.剩余空车位.getCmdType());
            ObjectResponse<Void> objectResponse = sendMsgService.send2MasterChannel(sendRequest, parkCode, freeSpaceRequest);
            //下发给对讲立柱
            downItc(parkId, parkCode, null, freeSpaceRequest);
            return objectResponse;
        } else {
            ObjectResponse<List<ParkInoutdevice>> listResponse = parkService.getAllChannel(parkId);
            ObjectResponse.notError(listResponse);
            List<ParkInoutdevice> inOutDeviceList = listResponse.getData();
            Map<Long, ParkFreespace> freeSpaceMap = new HashMap<>();
            Map<Long, String> freeSpaceNameMap = new HashMap<>();
            for (ParkInoutdevice inoutdevice : inOutDeviceList) {
                Long regionId;
                if (inoutdevice.getLedLcdSource() == 1) {
                    ObjectResponse<LedConfig> objectResponse = ledService.getLedConfigByChannel(inoutdevice.getId());
                    if (!ObjectResponse.isSuccess(objectResponse)) {
                        continue;
                    }
                    regionId = objectResponse.getData().getRegionFreeSpace();
                } else {
                    ObjectResponse<LcdConfig> objectResponse = lcdService.getLcdConfigByChannel(inoutdevice.getId());
                    if (!ObjectResponse.isSuccess(objectResponse)) {
                        continue;
                    }
                    regionId = objectResponse.getData().getRegionFreeSpace();
                }
                regionId = regionId == null ? 0 : regionId;
                ParkFreespace parkFreespace = freeSpaceMap.get(regionId);
                if (parkFreespace == null) {
                    if (regionId == 0) {
                        parkFreespace = parkFreeSpaceService.getSpaceByPark(parkId).getData();
                    } else {
                        ParkRegion parkRegion1 = parkRegionDao.selectById(regionId);
                        if (parkRegion1 == null) {
                            freeSpaceMap.put(regionId, null);
                            continue;
                        }
                        parkFreespace = new ParkFreespace();
                        parkFreespace.setFreeSpace(parkRegion1.getFreePark());
                        parkFreespace.setRealFreeSpace(parkRegion1.getRealFreePark());
                        parkFreespace.setTotalNum(parkRegion1.getRegionPark());

                        freeSpaceNameMap.put(regionId, parkRegion1.getRegionName());
                    }
                    freeSpaceMap.put(regionId, parkFreespace);
                }

                if (inoutdevice.getRegionId() != null) {
                    ParkRegion parkRegion = parkRegionDao.selectById(inoutdevice.getRegionId());
                    if (NumberUtils.toPrimitive(parkRegion.getIsFullForbidenter()) == 0
                            && NumberUtils.toPrimitive(parkRegion.getIsFullForbidMonthEnter()) == 0
                            && NumberUtils.toPrimitive(parkRegion.getIsFullForbidVIPEnter()) == 0
                            && NumberUtils.toPrimitive(parkRegion.getIsFullForbidReservEnter()) == 0
                            && NumberUtils.toPrimitive(parkRegion.getIsFullForbidStoreEnter()) == 0) {
                        log.info("[空车位下发接口] 没有配置车位满禁止入场, 无需下发临时车权限, parkCode[{}]", parkCode);
                    } else {
                        //处理通道权限
                        handleRuleByChannel(parkCode, parkId, NumberUtils.toPrimitive(parkRegion.getFreePark()), inoutdevice, parkRegion);
                    }
                }
                FreeSpaceRequest freeSpaceRequest = new FreeSpaceRequest();
                freeSpaceRequest.setFreeSpace(parkFreespace.getFreeSpace());
                freeSpaceRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
                freeSpaceRequest.setTotalSpace(parkFreespace.getTotalNum());
                freeSpaceRequest.setShowFreeSpace(parkFreespace.getFreeSpace());
                if (regionId != 0) {
                    freeSpaceRequest.setShowFreeSpaceName(freeSpaceNameMap.get(regionId));
                }
                freeSpaceRequest.setTime(DateTools.unixTimestamp());
                sendRequest.setServiceType(P2cDownCmdEnum.剩余空车位.getCmdType());
                sendMsgService.send2Channel(sendRequest, parkCode, inoutdevice.getInandoutCode(), freeSpaceRequest);
                //下发给对讲立柱
                downItc2Channel(parkId, parkCode, inoutdevice.getInandoutCode(), freeSpaceRequest);
            }
            return ObjectResponse.success();
        }

    }
    @Override
    public void send2Region(SendRequest sendRequest, Long parkId, String parkCode, Long regionId) {
        ParkRegion parkRegion = parkRegionDao.selectById(regionId);
        AssertTools.notNull(parkRegion, CodeConstants.ERROR_404, "无车位数据");
        if (NumberUtils.toPrimitive(parkRegion.getIsFullForbidenter()) == 0
                && NumberUtils.toPrimitive(parkRegion.getIsFullForbidMonthEnter()) == 0
                && NumberUtils.toPrimitive(parkRegion.getIsFullForbidVIPEnter()) == 0
                && NumberUtils.toPrimitive(parkRegion.getIsFullForbidReservEnter()) == 0
                && NumberUtils.toPrimitive(parkRegion.getIsFullForbidStoreEnter()) == 0) {
            log.info("[空车位下发接口] 没有配置车位满禁止入场, 无需下发临时车权限, parkCode[{}]", parkCode);
        } else {
            //处理通道权限
            handleChannelRule(parkCode, parkId, NumberUtils.toPrimitive(parkRegion.getFreePark()), parkRegion);
        }
        ObjectResponse<List<ParkInoutdevice>> listResponse = parkService.getAllChannel(parkId);
        ObjectResponse.notError(listResponse);
        List<ParkInoutdevice> inOutDeviceList = listResponse.getData().stream().filter(inoutdevice ->
                inoutdevice.getRegionId() != null && inoutdevice.getRegionId().equals(regionId)).collect(Collectors.toList());
        Map<Long, ParkFreespace> freeSpaceMap = new HashMap<>();
        Map<Long, String> freeSpaceNameMap = new HashMap<>();
        for (ParkInoutdevice inoutdevice : inOutDeviceList) {
            Long regionId2;
            if (inoutdevice.getLedLcdSource() == 1) {
                ObjectResponse<LedConfig> objectResponse = ledService.getLedConfigByChannel(inoutdevice.getId());
                if (!ObjectResponse.isSuccess(objectResponse)) {
                    continue;
                }
                regionId2 = objectResponse.getData().getRegionFreeSpace();
            } else {
                ObjectResponse<LcdConfig> objectResponse = lcdService.getLcdConfigByChannel(inoutdevice.getId());
                if (!ObjectResponse.isSuccess(objectResponse)) {
                    continue;
                }
                regionId2 = objectResponse.getData().getRegionFreeSpace();
            }
            regionId2 = regionId2 == null ? 0 : regionId2;
            ParkFreespace parkFreespace = freeSpaceMap.get(regionId2);
            if (parkFreespace == null) {
                if (regionId2 == 0) {
                    parkFreespace = parkFreeSpaceService.getSpaceByPark(parkId).getData();
                } else {
                    ParkRegion parkRegion1 = parkRegionDao.selectById(regionId2);
                    if (parkRegion1 == null) {
                        freeSpaceMap.put(regionId2, null);
                        continue;
                    }
                    parkFreespace = new ParkFreespace();
                    parkFreespace.setFreeSpace(parkRegion1.getFreePark());
                    parkFreespace.setRealFreeSpace(parkRegion1.getRealFreePark());
                    parkFreespace.setTotalNum(parkRegion1.getRegionPark());

                    freeSpaceNameMap.put(regionId2, parkRegion1.getRegionName());
                }
                freeSpaceMap.put(regionId2, parkFreespace);

            }
            FreeSpaceRequest freeSpaceRequest = new FreeSpaceRequest();
            freeSpaceRequest.setFreeSpace(parkFreespace.getFreeSpace());
            freeSpaceRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
            freeSpaceRequest.setTotalSpace(parkFreespace.getTotalNum());
            freeSpaceRequest.setShowFreeSpace(parkFreespace.getFreeSpace());
            if (regionId2 != 0) {
                freeSpaceRequest.setShowFreeSpaceName(freeSpaceNameMap.get(regionId2));
            }
            freeSpaceRequest.setTime(DateTools.unixTimestamp());
            sendRequest.setServiceType(P2cDownCmdEnum.剩余空车位.getCmdType());
            sendMsgService.send2Channel(sendRequest, parkCode, inoutdevice.getInandoutCode(), freeSpaceRequest);
            //下发给对讲立柱
            downItc(parkId, parkCode, regionId, freeSpaceRequest);
        }
    }

    private void handleChannelRule(String parkCode, Long parkId, int realFreeSpace, ParkRegion parkRegion) {
        ObjectResponse<List<ParkInoutdevice>> listResponse = parkService.getChannelByType(parkId, 1);
        if (!ObjectResponse.isSuccess(listResponse)){
            return;
        }
        List<ParkInoutdevice> collect = listResponse.getData().stream().filter(parkInoutdevice ->
                parkInoutdevice.getRegionId() != null && parkInoutdevice.getRegionId().equals(parkRegion.getParkId())).collect(Collectors.toList());
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
        ObjectResponse.notError(configObjectResponse);
        ParkConfig parkConfig = configObjectResponse.getData();
        //判断空车位是否满并且下发空车位
        String key = PARK_FULL_PROFILE + parkCode + "_" + parkRegion.getId();

        int fullEmptynum = parkRegion.getFullEmptynum() == null ? 0 : parkRegion.getFullEmptynum();
        //空车位满且缓存KEY不存在，则下发不让临时车进
        if (realFreeSpace <= fullEmptynum && !redisUtils.exists(key)) {
            boolean ret = downChannelRule(parkCode, collect, parkConfig, 0);
            //开启该车场的临时车禁止入内开关
            if (ret) {
                redisUtils.set(key, 1);
            }
        }else if (realFreeSpace > fullEmptynum && redisUtils.exists(key)){
            boolean ret = downChannelRule(parkCode, collect, parkConfig, 1);
            //关闭该车场的临时车禁止入内开关
            if (ret){
                redisUtils.remove(key);
            }
        }
    }
    private void handleRuleByChannel(String parkCode, Long parkId, int realFreeSpace, ParkInoutdevice parkInoutdevice, ParkRegion parkRegion) {
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
        ObjectResponse.notError(configObjectResponse);
        ParkConfig parkConfig = configObjectResponse.getData();
        //判断空车位是否满并且下发空车位
        String key = PARK_FULL_PROFILE + parkCode + "_" + parkRegion.getId();

        int fullEmptynum = parkRegion.getFullEmptynum() == null ? 0 : parkRegion.getFullEmptynum();
        //空车位满且缓存KEY不存在，则下发不让临时车进
        if (realFreeSpace <= fullEmptynum && !redisUtils.exists(key)) {
            boolean ret = downRuleOneChannel(parkCode, parkConfig, 0, parkInoutdevice);
            //开启该车场的临时车禁止入内开关
            if (ret) {
                redisUtils.set(key, 1);
            }
        }else if (realFreeSpace > fullEmptynum && redisUtils.exists(key)){
            boolean ret = downRuleOneChannel(parkCode, parkConfig, 1, parkInoutdevice);
            //关闭该车场的临时车禁止入内开关
            if (ret){
                redisUtils.remove(key);
            }
        }
    }

    private boolean downChannelRule(String parkCode, List<ParkInoutdevice> listResponse, ParkConfig parkConfig, Integer isAllowTempCarRun) {
        boolean ret = true;
        for (ParkInoutdevice parkInoutdevice : listResponse) {
            ret = ret && downRuleOneChannel(parkCode, parkConfig, isAllowTempCarRun, parkInoutdevice);
        }
        return ret;
    }

    private boolean downRuleOneChannel(String parkCode, ParkConfig parkConfig, Integer isAllowTempCarRun, ParkInoutdevice parkInoutdevice) {
        String serialNumber = cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
        if (serialNumber == null) {
            return false;
        }
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(serialNumber);
        if (deviceInfo == null) {
            return false;
        }
        if (P2cVersionEnum.getIndex(deviceInfo.getVersion()) >= P2cVersionEnum.版本10.getIndex()) {
            return false;
        }
        parkInoutdevice.setIsAllowTempcarrun(isAllowTempCarRun);
        return channelRulesService.send2Channel(parkCode, P2cDownCmdEnum.通道权限下发.getCmdType(), parkConfig, parkInoutdevice);
    }

    private void downItc(Long parkId, String parkCode, Long regionId, FreeSpaceRequest freeSpaceRequest) {
        List<ParkConnectedDeviceVo> parkConnectList = itcCacheHandle.getParkConnectList(parkCode);
        if (CollectionUtils.isEmpty(parkConnectList)) {
            return;
        }
        log.info("准备下发空车位给[{}]车场的对讲柱列表{}", parkCode, parkConnectList);
        parkConnectList.stream()
                .filter(vo -> regionId == null || regionId.equals(vo.getRegionId()))
                .forEach(vo -> itcFreeSpaceService.send(parkId, vo.getDeviceNo(), freeSpaceRequest));
    }
    private void downItc2Channel(Long parkId, String parkCode, String channelCode, FreeSpaceRequest freeSpaceRequest) {
        List<ParkConnectedDeviceVo> parkConnectList = itcCacheHandle.getParkConnectList(parkCode);
        if (CollectionUtils.isEmpty(parkConnectList)) {
            return;
        }
        log.info("准备下发空车位给[{}]车场的对讲柱列表{}", parkCode, parkConnectList);
        parkConnectList.stream()
                .filter(vo -> channelCode == null || channelCode.equals(vo.getInandoutCode()))
                .forEach(vo -> itcFreeSpaceService.send(parkId, vo.getDeviceNo(), freeSpaceRequest));
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.剩余空车位.getCmdType());
    }

}
