package com.icetech.park.service.down.p2c.impl;


import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ExitSyncRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.ONE;

/**
 * 出场数据同步下发接口
 *
 * @author fangct
 */
@Service("p2cExitSyncServiceImpl")
public class ExitSyncServiceImpl extends AbstractService implements ResponseService<String>,DownService<ExitSyncRequest, Void>, NotifyService<String> {

    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderSonCarInfoDao orderSonCarInfoDao;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long parkId = sendRequest.getParkId();
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setId(sendRequest.getServiceId());
        ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
        if (!ObjectResponse.isSuccess(byOrderInfo)) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "订单信息未找到"));
        }
        OrderInfo infoData = byOrderInfo.getData();

        ExitSyncRequest exitSyncRequest = new ExitSyncRequest();
        exitSyncRequest.setType(infoData.getType());
        exitSyncRequest.setPlateNum(infoData.getPlateNum());
        exitSyncRequest.setOrderNum(infoData.getOrderNum());
        exitSyncRequest.setEnterTime(infoData.getEnterTime());
        exitSyncRequest.setExitTime(infoData.getExitTime());
        ObjectResponse<OrderCarInfo> carInfoResponse = orderCarInfoService.getCarInfo(infoData.getOrderNum(), parkId);
        ObjectResponse.notError(carInfoResponse);
        OrderCarInfo carInfo = carInfoResponse.getData();

        String channelId = carInfo.getExitChannelId();
        String deviceNo;
        try{
            deviceNo = cacheHandle.getSerialNumber(parkCode, channelId);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }

        ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(infoData.getParkId(), channelId);
        if (ObjectResponse.isSuccess(objectResponse)) {
            ParkInoutdevice inoutDevice = objectResponse.getData();
            exitSyncRequest.setRegionId(inoutDevice.getRegionId());
            exitSyncRequest.setIsMaster(inoutDevice.getIsMaster());
            ObjectResponse<ParkRegion> regionObjectResponse = parkService.getParkRegionById(inoutDevice.getRegionId());
            if (ObjectResponse.isSuccess(regionObjectResponse)) {
                ParkRegion parkRegion = regionObjectResponse.getData();
                exitSyncRequest.setRegionType(Long.valueOf(0).equals(parkRegion.getFatherRelationId()) ? 1 : 2);
            }
        }
        return sendMsgService.send2OtherMasterExit(deviceNo, sendRequest, parkCode, exitSyncRequest);

    }
    public ObjectResponse<?> send(SendRequest sendRequest, String parkCode, Object content) {
        OrderInfo infoData;
        OrderCarInfo orderCarInfo;
        if (P2cDownCmdEnum.出场数据同步.getCmdType().equals(sendRequest.getServiceType())) {
            infoData = (OrderInfo) content;
            orderCarInfo = orderCarInfoService.getCarInfo(infoData.getOrderNum(), infoData.getParkId()).getData();
        } else {
            infoData = (OrderSonInfo) content;
            orderCarInfo = orderSonCarInfoDao.selectByOrderSonId(infoData.getId());
        }
        if (infoData.getExitTime() == null) {
            infoData.setExitTime(infoData.getEnterTime());
        }
        ExitSyncRequest exitSyncRequest = new ExitSyncRequest();
        exitSyncRequest.setType(infoData.getType());
        exitSyncRequest.setPlateNum(infoData.getPlateNum());
        exitSyncRequest.setOrderNum(infoData.getOrderNum());
        exitSyncRequest.setEnterTime(infoData.getEnterTime());
        exitSyncRequest.setExitTime(infoData.getExitTime());

        if (orderCarInfo == null) {
            return ObjectResponse.success(CodeConstants.ERROR_406);
        }
        String channelId = orderCarInfo.getExitChannelId();
        String deviceNo;
        try{
            deviceNo = cacheHandle.getSerialNumber(parkCode, channelId);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        ObjectResponse<Park> objectResponse = parkService.findByParkId(sendRequest.getParkId());
        ObjectResponse.notError(objectResponse, "车场ID["+sendRequest.getParkId()+"]不存在");
        //场中场
        if (Integer.valueOf(1).equals(objectResponse.getData().getIsInterior())) {
            ObjectResponse<ParkInoutdevice> inoutDeviceObjectResponse = parkService.getInOutDeviceByCode(infoData.getParkId(), channelId);
            ObjectResponse.notError(inoutDeviceObjectResponse, "通道编号["+channelId+"]不存在");
            ParkInoutdevice inoutDevice = inoutDeviceObjectResponse.getData();
            exitSyncRequest.setRegionId(inoutDevice.getRegionId());
            exitSyncRequest.setIsMaster(inoutDevice.getIsMaster());
            ObjectResponse<ParkRegion> regionObjectResponse = parkService.getParkRegionById(inoutDevice.getRegionId());
            ObjectResponse.notError(regionObjectResponse, "区域ID["+inoutDevice.getRegionId()+"]不存在");
            ParkRegion parkRegion = regionObjectResponse.getData();
            exitSyncRequest.setRegionType(Long.valueOf(0).equals(parkRegion.getFatherRelationId()) ? 1 : 2);
        }
        return sendMsgService.send2OtherMasterExit(deviceNo, sendRequest, parkCode, exitSyncRequest);
    }
    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.出场数据同步.getCmdType());
    }

}
