package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.EnterSyncRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 入场数据同步下发接口
 *
 * @author fangct
 */
@Slf4j
@Service("p2cEnterSyncServiceImpl")
public class EnterSyncServiceImpl extends AbstractService implements ResponseService<String>,DownService<EnterSyncRequest, Void>, NotifyService<String> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private OrderService orderService;
    @Resource
    private OrderCarInfoService orderCarInfoService;
    @Resource
    private ParkService parkService;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long parkId = sendRequest.getParkId();
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setId(sendRequest.getServiceId());
        orderInfo.setServiceStatus(OrderStatusConstants.IN_PARK);
        ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
        if (byOrderInfo == null) {
            log.info("[端云-入场同步到出口] 查询失败, order表id[{}], 结果[{}]", sendRequest.getServiceId(), byOrderInfo);
            return ObjectResponse.failed(CodeConstants.ERROR);
        }
        if (byOrderInfo.getCode().equals(CodeConstants.ERROR_404)){
            log.info("[端云-入场同步到出口] 未找到入场记录或车场已出场，order表id[{}]", sendRequest.getServiceId());
            return ObjectResponse.failed(CodeConstants.ERROR_406, "未找到在场订单");
        }
        if (byOrderInfo.getData() == null) {
            log.info("[端云-入场同步到出口] 查询失败, order表id[{}], 结果[{}]", sendRequest.getServiceId(), byOrderInfo);
            return ObjectResponse.failed(byOrderInfo.getCode(), byOrderInfo.getMsg());
        }
        OrderInfo infoData = byOrderInfo.getData();

        EnterSyncRequest enterSyncRequest = new EnterSyncRequest();
        enterSyncRequest.setOrderNum(infoData.getOrderNum());
        enterSyncRequest.setPlateNum(infoData.getPlateNum());
        enterSyncRequest.setEnterTime(infoData.getEnterTime());
        enterSyncRequest.setType(infoData.getType());

        ObjectResponse<OrderCarInfo> infoObjectResponse = orderCarInfoService.getCarInfo(infoData.getOrderNum(), infoData.getParkId());
        if (ObjectResponse.isSuccess(infoObjectResponse) && infoObjectResponse.getData().getEnterChannelId() != null) {
            String enterChannelId = infoObjectResponse.getData().getEnterChannelId();
            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(infoData.getParkId(), enterChannelId);
            if (ObjectResponse.isSuccess(objectResponse)) {
                ParkInoutdevice inoutDevice = objectResponse.getData();
                enterSyncRequest.setRegionId(inoutDevice.getRegionId());
                enterSyncRequest.setIsMaster(inoutDevice.getIsMaster());
                ObjectResponse<ParkRegion> regionObjectResponse = parkService.getParkRegionById(inoutDevice.getRegionId());
                if (ObjectResponse.isSuccess(regionObjectResponse)) {
                    ParkRegion parkRegion = regionObjectResponse.getData();
                    enterSyncRequest.setRegionType(Long.valueOf(0).equals(parkRegion.getFatherRelationId()) ? 1 : 2);
                }
            }
        }
        return sendMsgService.send2MasterExit(sendRequest, parkCode, enterSyncRequest);
    }

    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode, Object content) {
        OrderInfo infoData;
        OrderCarInfo orderCarInfo = null;
        if (P2cDownCmdEnum.入场数据同步.getCmdType().equals(sendRequest.getServiceType())) {
            infoData = (OrderInfo) content;
            ObjectResponse<Park> objectResponse = parkService.findByParkId(sendRequest.getParkId());
            if (ObjectResponse.isSuccess(objectResponse)) {
                Integer isInterior = objectResponse.getData().getIsInterior();
                //场中场
                if (Integer.valueOf(1).equals(isInterior)) {
                    orderCarInfo = orderCarInfoService.getCarInfo(infoData.getOrderNum(), infoData.getParkId()).getData();
                }
            }
        } else {
            infoData = (OrderSonInfo) content;
            orderCarInfo = orderSonCarInfoDao.selectByOrderSonId(infoData.getId());
        }
        if (orderCarInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_406);
        }
        EnterSyncRequest enterSyncRequest = new EnterSyncRequest();
        enterSyncRequest.setOrderNum(infoData.getOrderNum());
        enterSyncRequest.setPlateNum(infoData.getPlateNum());
        enterSyncRequest.setEnterTime(infoData.getEnterTime());
        enterSyncRequest.setType(infoData.getType());

        if (orderCarInfo.getEnterChannelId() != null) {
            String enterChannelId = orderCarInfo.getEnterChannelId();
            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(infoData.getParkId(), enterChannelId);
            if (ObjectResponse.isSuccess(objectResponse)) {
                ParkInoutdevice inoutDevice = objectResponse.getData();
                enterSyncRequest.setRegionId(inoutDevice.getRegionId());
                enterSyncRequest.setIsMaster(inoutDevice.getIsMaster());
                ObjectResponse<ParkRegion> regionObjectResponse = parkService.getParkRegionById(inoutDevice.getRegionId());
                if (ObjectResponse.isSuccess(regionObjectResponse)) {
                    ParkRegion parkRegion = regionObjectResponse.getData();
                    enterSyncRequest.setRegionType(Long.valueOf(0).equals(parkRegion.getFatherRelationId()) ? 1 : 2);
                }
            }
        }
        return sendMsgService.send2MasterExit(sendRequest, parkCode, enterSyncRequest);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.入场数据同步.getCmdType());
    }

}
