package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ClearListRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import static com.icetech.basics.constants.TextConstant.ERROR_410;

@Service("p2cClearListServiceImpl")
@Slf4j
public class ClearListServiceImpl extends AbstractService implements ResponseService<String>, NotifyService<String> {

    @Resource
    private P2cDownHandle p2cDownHandle;

    public ObjectResponse<Void> execute(Long parkId, String parkCode, Integer dataType, Integer id){

        ClearListRequest clearListRequest = new ClearListRequest();
        clearListRequest.setDataType(dataType);
        clearListRequest.setId(id);

        Message<ClearListRequest> message = new Message<>(parkId, P2cDownCmdEnum.名单数据清空.getCmdType(), clearListRequest);
        String[] messageIdArr = p2cDownHandle.send2Park(parkCode, message);
        if (ArrayUtils.isEmpty(messageIdArr)){
            return ObjectResponse.failed(ERROR_410, "识别相机不在线");
        }else{
            return ObjectResponse.success();
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.名单数据清空.getCmdType());
    }
}
