package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ClearInparkRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderModifyRecordDao;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("p2cClearInparkServiceImpl")
@Slf4j
public class ClearInparkServiceImpl extends AbstractService implements ResponseService<String>, DownService<ClearInparkRequest, Void>, NotifyService<String> {

    @Autowired
    private P2cDownHandle p2CDownHandle;
    @Autowired
    private OrderModifyRecordDao orderModifyRecordDao;
    @Autowired
    private SendMsgServiceImpl sendMsgService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        OrderModifyRecord orderModifyRecord = orderModifyRecordDao.selectOneById(sendRequest.getServiceId());
        if (orderModifyRecord == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_406, "未找到操作记录");
        }
        if (orderModifyRecord.getAction() == 1) {
            return ObjectResponse.failed(CodeConstants.ERROR_406, "修改订单无需下发相机");
        }
        ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
        clearInparkRequest.setOrderNum(orderModifyRecord.getOrderNum());
        return sendMsgService.send2Park(sendRequest, parkCode, clearInparkRequest);
    }

    @Override
    public ObjectResponse<Void> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List<Long> ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List<OrderModifyRecord> list = orderModifyRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return ObjectResponse.failed(CodeConstants.ERROR_402);
        }
        Map<Long, String> idOrderNumMap = list.stream().collect(
                Collectors.toMap(OrderModifyRecord::getId, OrderModifyRecord::getOrderNum, (a, b) -> a));
        sendRequestList.forEach(sendRequest -> {
            ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
            String orderNum = idOrderNumMap.get(sendRequest.getServiceId());
            if (StringUtils.isNotBlank(orderNum)) {
                clearInparkRequest.setOrderNum(orderNum);
                sendMsgService.send2Park(sendRequest, parkCode, clearInparkRequest);
            }
        });
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> execute(Long parkId, String parkCode, String orderNum){

        ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
        clearInparkRequest.setOrderNum(orderNum);

        Message<ClearInparkRequest> message = new Message<>(parkId, P2cDownCmdEnum.在场车辆清除.getCmdType(), clearInparkRequest);
        String[] messageIdArr = p2CDownHandle.send2Park(parkCode, message);
        if (messageIdArr == null || messageIdArr[0] == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }else{
            return ObjectResponse.success();
        }
    }
    public ObjectResponse<Void> clearByDeviceNo(Long parkId, String parkCode, String orderNum, String serialNumber){

        ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
        clearInparkRequest.setOrderNum(orderNum);

        Message<ClearInparkRequest> message = new Message<>(parkId, P2cDownCmdEnum.在场车辆清除.getCmdType(), clearInparkRequest);
        String messageId = p2CDownHandle.send(parkCode, serialNumber, message);

        if (messageId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        } else {
            return ObjectResponse.success();
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2CDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.在场车辆清除.getCmdType());
    }
}
