package com.icetech.park.service.down.p2c.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.icetech.basics.domain.entity.charge.Charge24chargeSet;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeTypeDetail;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ChargeRuleRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

@Service("p2cChargeRuleServiceImpl")
@Slf4j
public class ChargeRuleServiceImpl extends AbstractConfigDownService implements ResponseService<String>, DownService<List<ChargeRuleRequest>, Void> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ChargeService chargeService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private BatchDownConfigHandle<List<ChargeRuleRequest>> batchDownConfigHandle;
    @Autowired
    private ChannelRulesServiceImpl channelRulesService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    public boolean send(String parkCode, String deviceNo, String version){
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park data = byParkCode.getData();
        Long parkId = data.getId();
        List<ChargeRuleRequest> chargeRuleRequests = buildRequest(parkId);
        //组装参数
        Message<List<ChargeRuleRequest>> message = new Message<>(parkId, P2cDownCmdEnum.计费规则.getCmdType(), chargeRuleRequests);
        String messageId = p2cDownHandle.send(parkCode, deviceNo, message);
        if (messageId == null){
            log.info("<端云-计费规则下发> 下发失败，参数:{}", chargeRuleRequests);
            return false;
        }else{
            return true;
        }
    }

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode){
        List<ChargeRuleRequest> chargeRuleRequests = buildRequest(sendRequest.getParkId());
        syncChannelRules(sendRequest.getParkId(), parkCode);
        return sendMsgService.send2Park(sendRequest, parkCode, chargeRuleRequests);

    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        Integer subTaskId = redisUtils.get(RedisConstants.BATCH_DOWN_MSGID + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null){
            batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.计费规则.getCmdType());
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo){
        Long parkId = vo.getParkId();
        List<ChargeRuleRequest> chargeRuleRequests = buildRequest(parkId);
        batchDownConfigHandle.batchDown(vo, chargeRuleRequests, P2cDownCmdEnum.计费规则.getCmdType());
        return ObjectResponse.success();
    }
    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo){
        Long parkId = vo.getParkId();
        List<ChargeRuleRequest> chargeRuleRequests = buildRequest(parkId);
        batchDownConfigHandle.repeatBatch(vo, chargeRuleRequests, P2cDownCmdEnum.计费规则.getCmdType());
        return ObjectResponse.success();
    }
    private List<ChargeRuleRequest> buildRequest(Long parkId) {
        ObjectResponse<List<ParkChargeconfig>> objectResponse = chargeService.getConfigs(parkId);
        ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(parkId);
        ObjectResponse.notError(objectResponse, "未找到计费规则");
        ObjectResponse.notError(parkConfigObjectResponse, "未找到高级配置");
        List<ParkChargeconfig> parkChargeconfigs = objectResponse.getData();
        List<ChargeRuleRequest> list = new ArrayList<>(parkChargeconfigs.size());
        for (ParkChargeconfig parkChargeconfig : parkChargeconfigs) {
            String billCode = parkChargeconfig.getBilltypecode();
            ChargeRuleRequest chargeRuleRequest = new ChargeRuleRequest();
            chargeRuleRequest.setBilltype(parkChargeconfig.getBilltype());
            chargeRuleRequest.setBilltypecode(parkChargeconfig.getBilltypecode());
            chargeRuleRequest.setBilltypename(parkChargeconfig.getBilltypename());
            chargeRuleRequest.setIsDefault(parkChargeconfig.getDefaultCharge());
            if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.通用自然天.type) {
                ObjectResponse<ChargeNaturalDayDetail> naturaldayObjectResponse =
                        chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
                if (ObjectResponse.isSuccess(naturaldayObjectResponse)) {
                    ChargeNaturalDayDetail naturalDayDetail = naturaldayObjectResponse.getData();
                    ChargeRuleRequest.NaturalDayRule naturalDayRule = new ChargeRuleRequest.NaturalDayRule();
                    BeanUtil.copyProperties(naturalDayDetail, naturalDayRule, CopyOptions.create().setIgnoreNullValue(true));

                    if (naturalDayDetail.getIsFreetimeOnce() == null || naturalDayDetail.getIsFreetimeOnce() >= 0){
                        naturalDayRule.setFreetime(0);
                    } else {
                        //按秒计费时，下发到相机要少1分钟；例：停车10分钟免费，相机在判断10分钟1秒时也认为免费，所以要由上报平台算费
                        if (Integer.valueOf(1).equals(parkConfigObjectResponse.getData().getBillPrecision())) {
                            naturalDayRule.setFreetime(
                                    NumberUtils.toPrimitive(naturalDayRule.getFreetime()) <= 0 ? 0 : naturalDayRule.getFreetime() - 1);
                        }
                    }
                    naturalDayRule.setOneBillmethod(naturalDayDetail.getBillmethod());
                    // 工作日计费方式
                    naturalDayRule.setFirstConfig(onceDyrationDetail(naturalDayDetail.getWorkdayDetail()));
                    // 是否区分工作日非工作日
                    if (naturalDayDetail.getIsspecialdaycharge() == 1) {
                        naturalDayRule.setTwoBillmethod(naturalDayDetail.getNoworkBillmethod());
                        naturalDayRule.setTwoConfig(onceDyrationDetail(naturalDayDetail.getHolidayDetail()));
                    }
                    chargeRuleRequest.setChargeRule(naturalDayRule);
                } else {
                    log.info("<端云-计费规则下发> 数据不完整，通用自然天计费配置查询失败，billCode：{}", billCode);
                    continue;
                }
            } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.白天夜间收费.type) {
                ObjectResponse<ChargeDayNightDetail> chargeDaynightObjectResponse =
                        chargeService.getDaynight(parkChargeconfig.getBilltypecode());
                if (ObjectResponse.isSuccess(chargeDaynightObjectResponse)) {
                    ChargeDayNightDetail dayNightDetail = chargeDaynightObjectResponse.getData();
                    ChargeRuleRequest.DayNightRule dayNightRule = new ChargeRuleRequest.DayNightRule();
                    BeanUtil.copyProperties(dayNightDetail, dayNightRule, CopyOptions.create().setIgnoreNullValue(true));

                    if (dayNightDetail.getIsFreetimeOnce() == null || dayNightDetail.getIsFreetimeOnce() >= 0){
                        dayNightRule.setFreetime(0);
                    } else {
                        //按秒计费时，下发到相机要少1分钟；例：停车10分钟免费，相机在判断10分钟1秒时也认为免费，所以要由上报平台算费
                        if (Integer.valueOf(1).equals(parkConfigObjectResponse.getData().getBillPrecision())) {
                            dayNightRule.setFreetime(
                                    NumberUtils.toPrimitive(dayNightRule.getFreetime()) <= 0 ? 0 :  dayNightRule.getFreetime() - 1);
                        }
                    }
                    dayNightRule.setDayBillmethod(dayNightDetail.getBillmethodday());
                    dayNightRule.setNightBillmethod(dayNightDetail.getBillmethodnight());
                    // 白天计费方式
                    dayNightRule.setDayConfig(onceDyrationDetail(dayNightDetail.getDailyDetail()));
                    // 夜间计费方式
                    dayNightRule.setNightConfig(onceDyrationDetail(dayNightDetail.getNightlyDetail()));
                    chargeRuleRequest.setChargeRule(dayNightRule);
                } else {
                    log.info("<端云-计费规则下发> 数据不完整，白天夜间计费配置查询失败，billCode：{}", billCode);
                    continue;
                }
            } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.二十四小时计费.type) {
                ObjectResponse<Charge24HourDetail> charge24chargeObjectResponse =
                        chargeService.get24Hours(parkChargeconfig.getBilltypecode());
                if (ObjectResponse.isSuccess(charge24chargeObjectResponse)) {
                    Charge24HourDetail hourDetail = charge24chargeObjectResponse.getData();
                    ChargeRuleRequest.Charge24Rule charge24Rule = new ChargeRuleRequest.Charge24Rule();
                    BeanUtil.copyProperties(hourDetail, charge24Rule, CopyOptions.create().setIgnoreNullValue(true));

                    if (hourDetail.getIsFreetimeOnce() == null || hourDetail.getIsFreetimeOnce() >= 0){
                        charge24Rule.setFreetime(0);
                    } else {
                        //按秒计费时，下发到相机要少1分钟；例：停车10分钟免费，相机在判断10分钟1秒时也认为免费，所以要由上报平台算费
                        if (Integer.valueOf(1).equals(parkConfigObjectResponse.getData().getBillPrecision())) {
                            charge24Rule.setFreetime(
                                    NumberUtils.toPrimitive(charge24Rule.getFreetime()) <= 0 ? 0 :  charge24Rule.getFreetime() - 1);
                        }
                    }
                    List<Charge24chargeSet> charge24chargeSets = hourDetail.getChargeDetails();
                    if (CollectionUtils.isNotEmpty(charge24chargeSets)) {
                        List<ChargeRuleRequest.Charge24RuleDetail> charge24RuleDetails = new ArrayList<>();
                        charge24chargeSets.forEach(charge24chargeSet -> {
                            ChargeRuleRequest.Charge24RuleDetail charge24RuleDetail = new ChargeRuleRequest.Charge24RuleDetail();
                            charge24RuleDetail.setFeespantime(charge24chargeSet.getFeespantime());
                            charge24RuleDetail.setFeespanrate(charge24chargeSet.getFeespanrate());
                            charge24RuleDetail.setFeespanrateBig(charge24chargeSet.getFeespanrateBig());
                            int recordStatus = charge24chargeSet.getFeespantime() % hourDetail.getDivisionTime() == 0 ? 1 : 0;
                            charge24RuleDetail.setRecordStatus(recordStatus);
                            charge24RuleDetails.add(charge24RuleDetail);
                        });
                        charge24Rule.setDetails(charge24RuleDetails);
                        chargeRuleRequest.setChargeRule(charge24Rule);
                    } else {
                        log.info("<端云-计费规则下发> 数据不完整，24小时计费配置查询失败，billCode：{}", billCode);
                        continue;
                    }
                } else {
                    log.info("<端云-计费规则下发> 数据不完整，24小时计费配置查询失败，billCode：{}", billCode);
                    continue;
                }
            }
            list.add(chargeRuleRequest);
        }
        return list;
    }

    /**
     * 更新相机的车场权限配置
     * @param parkId 车场ID
     * @param parkCode 为空时不下发车场权限
     */
    private void syncChannelRules(Long parkId, String parkCode) {
        if (parkCode != null) {
            //同步车场配置接口中的免费时长
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(parkId);
                sendRequest.setServiceType(P2cDownCmdEnum.车场权限下发.getCmdType());
                sendRequest.setServiceId(parkId);
                channelRulesService.send(sendRequest, parkCode);
            }));
        }
    }

    /**
     * 按次和按时长计费查询
     * @param typeDetail typeDetail
     * @return 响应
     */
    private Object onceDyrationDetail(ChargeTypeDetail typeDetail) {
        if (typeDetail.getChargeType() == 1) { //按次计费
            ChargeRuleRequest.ChargeOnce chargeOnceVo = new ChargeRuleRequest.ChargeOnce();
            if (typeDetail.getOnce() != null) {
                BeanUtil.copyProperties(typeDetail.getOnce(), chargeOnceVo, CopyOptions.create().setIgnoreNullValue(true));
                return chargeOnceVo;
            } else {
                log.warn("<端云-计费规则下发> 数据不完整，通用自然天按次计费查询失败");
                throw new ResponseBodyException(CodeConstants.ERROR_404, "通用自然天按次计费查询失败");
            }
        } else {    //按时计费
            // 非阶梯计费查询
            ChargeRuleRequest.ChargeDyration chargeDyrationVo = new ChargeRuleRequest.ChargeDyration();
            if (typeDetail.getDuration() != null) {
                // 非阶梯计费只会有一条记录
                BeanUtil.copyProperties(typeDetail.getDuration(), chargeDyrationVo, CopyOptions.create().setIgnoreNullValue(true));
            }
            // 阶梯计费查询
            if (CollectionUtils.isNotEmpty(typeDetail.getPeriodDurations())) {
                List<ChargeRuleRequest.StepChargeDetail> stepChargeDetailList = typeDetail.getPeriodDurations().stream()
                        .map(duration -> {
                            ChargeRuleRequest.StepChargeDetail stepChargeDetail = new ChargeRuleRequest.StepChargeDetail();
                            BeanUtil.copyProperties(duration, stepChargeDetail, CopyOptions.create().setIgnoreNullValue(true));
                            return stepChargeDetail;
                        }).collect(Collectors.toList());
                chargeDyrationVo.setStepChargeDetails(stepChargeDetailList);
            } else {
                log.warn("<端云-计费规则下发> 数据不完整，按时长计费配置查询失败");
                throw new ResponseBodyException(CodeConstants.ERROR_404, "按时长计费配置查询失败");
            }
            return chargeDyrationVo;
        }
    }
}
