package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ChargePlatetypeRelRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.ONE;

@Service("p2cChargePlatetypeRelServiceImpl")
@Slf4j
public class ChargePlatetypeRelServiceImpl extends AbstractConfigDownService
        implements DownService<List<ChargePlatetypeRelRequest>, Void>, ResponseService<String> {

    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Resource
    private ParkService parkService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        try {
            ObjectResponse<List<RegionChargeconfig>> listObjectResponse = parkService.selectRegionChargeconfigByParkId(sendRequest.getParkId());
            if (!ObjectResponse.isSuccess(listObjectResponse) || CollectionUtils.isEmpty(listObjectResponse.getData())) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "区域计费规则不存在"));
            }
            List<RegionChargeconfig> list = listObjectResponse.getData();
            List<ChargePlatetypeRelRequest> retList = new ArrayList<>();
            list.forEach(regionChargeconfig -> {
                ChargePlatetypeRelRequest chargePlatetypeRelRequest = new ChargePlatetypeRelRequest();
                chargePlatetypeRelRequest.setPlateType(regionChargeconfig.getLicensePlateType());
                chargePlatetypeRelRequest.setBilltypecode(regionChargeconfig.getBilltypecode());
                chargePlatetypeRelRequest.setRegionId(regionChargeconfig.getRegionId());
                retList.add(chargePlatetypeRelRequest);
            });
            return sendMsgService.send2Park(sendRequest, parkCode, retList);
        } catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), e);
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "区域计费规则下发失败"));
        }

    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.计费规则与车牌类型对应关系.getCmdType());
    }
}
