package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.ChannelRulesRequest;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.request.p2c.PropertySetRequest;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.vo.ParkChargeRuleVO;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.itc.impl.ItcPropertySetServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.ONE;
import static com.icetech.cloudcenter.domain.constants.RedisConstants.PARK_FULL_PROFILE;

@Service("p2cChannelRulesServiceImpl")
@Slf4j
public class ChannelRulesServiceImpl extends AbstractConfigDownService implements ResponseService<String>, DownService<ChannelRulesRequest, Void> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private PropertySetServiceImpl propertySetService;
    @Autowired
    private PropertyGetServiceImpl propertyGetService;
    @Autowired
    private ItcPropertySetServiceImpl itcPropertySetService;
    @Autowired
    private BatchDownConfigHandle<ChannelRulesRequest> batchDownConfigHandle;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private ParkRecoveryService parkRecoveryService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Value("${web.url}")
    private String webUrl;
    @Value("${custom.repeatEx.enable:false}")
    private boolean customRepeatExEnable;
    @Value("${custom.repeatEx.parkCodes:P}")
    private String customRepeatExParkCodes;
    @Autowired
    private ThirdInfoService thirdInfoService;

    public boolean send2Channel(String parkCode, Integer serviceType, ParkConfig parkConfig, ParkInoutdevice parkInoutdevice) {
        //组装参数
        ChannelRulesRequest channelRulesRequest = getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkConfig.getParkId());
        sendRequest.setServiceType(serviceType);
        ObjectResponse<Void> objectResponse = sendMsgService.send2Channel(sendRequest, parkCode,
                parkInoutdevice.getInandoutCode(), channelRulesRequest);
        return ObjectResponse.isSuccess(objectResponse);
    }

    public boolean send(String parkCode, String serialNumber){

        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park data = byParkCode.getData();
        Long parkId = data.getId();
        ParkConfig parkConfig = getParkConfig(parkId);
        ObjectResponse<ParkInoutdevice> channelInfoResponse = parkService.getChannelInfo(parkId, serialNumber);
        if (ObjectResponse.isSuccess(channelInfoResponse)){
            return send2Device(parkCode, P2cDownCmdEnum.通道权限下发.getCmdType(), parkConfig, channelInfoResponse.getData(), serialNumber);
        }else{
            return false;
        }

    }

    private boolean send2Device(String parkCode, Integer serviceType, ParkConfig parkConfig, ParkInoutdevice parkInoutdevice, String deviceNo) {
        //组装参数
        ChannelRulesRequest channelRulesRequest = getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkConfig.getParkId());
        sendRequest.setServiceType(serviceType);
        ObjectResponse<Void> objectResponse = sendMsgService.send2Devices(deviceNo, sendRequest, parkCode, channelRulesRequest);
        return ObjectResponse.isSuccess(objectResponse);
    }

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode){

        ParkConfig parkConfig = getParkConfig(sendRequest.getParkId());

        if (sendRequest.getServiceType().equals(P2cDownCmdEnum.通道权限下发.getCmdType())){
            /*
             * 车场通道权限修改时下发
             */
            ObjectResponse<ParkInoutdevice> inoutDeviceResponse = parkService.getInoutDeviceById(sendRequest.getServiceId());
            if (!ObjectResponse.isSuccess(inoutDeviceResponse)) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "出入口通道未找到"));
            }
            ParkInoutdevice parkInoutdevice = inoutDeviceResponse.getData();
            ChannelRulesRequest channelRulesRequest;
            try {
                channelRulesRequest = getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
            }catch (ResponseBodyException e) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "通道设备未找到"));
            }
            //异步处理通道类型变化的业务
            asyncDownChannel(parkCode, parkInoutdevice, parkConfig);
            return sendMsgService.send2Channel(sendRequest, parkCode, parkInoutdevice.getInandoutCode(), channelRulesRequest);
        }else{
            /*
             * 车场权限修改时下发所有设备
             */
            ObjectResponse<List<ParkInoutdevice>> listResponse = parkService.getAllChannel(parkConfig.getParkId());
            if (!ObjectResponse.isSuccess(listResponse)) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "出入口通道未找到"));
            }
            List<ParkInoutdevice> data = listResponse.getData();
            boolean success = true;
            for (int i = 0; data != null && i < data.size(); i++) {
                ParkInoutdevice parkInoutdevice = data.get(i);
                //组装参数
                ChannelRulesRequest channelRulesRequest;
                try {
                    channelRulesRequest = getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
                }catch (ResponseBodyException e) {
                    return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "通道设备未找到"));
                }
                //设置为NULL，为了避免被缓存，导致重复下发到某个设备
                sendRequest.setTaskId(null);

                ObjectResponse<Void> objectResponse = sendMsgService.send2Channel(sendRequest, parkCode,
                        parkInoutdevice.getInandoutCode(), channelRulesRequest);
                success = success && ObjectResponse.isSuccess(objectResponse);
            }
            //异步处理通道类型变化的业务
            asyncDownPark(parkCode, data, parkConfig);
            if (!success) {
                return ObjectResponse.failed(ERROR_410, "车场权限修改下发失败");
            }
        }
        return ObjectResponse.success();
    }

    private void asyncDownPark(String parkCode, List<ParkInoutdevice> parkInoutdevices, ParkConfig parkConfig) {
        for (int i = 0; parkInoutdevices != null && i < parkInoutdevices.size(); i++) {
            ParkInoutdevice parkInoutdevice = parkInoutdevices.get(i);
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                String serialNumber = cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
                if (serialNumber == null) {
                    return;
                }
                TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(serialNumber);
                if (deviceInfo == null) {
                    return;
                }
                if (P2cVersionEnum.getIndex(deviceInfo.getVersion()) < P2cVersionEnum.版本12.getIndex()) {
                    return;
                }
                PropertySetRequest propertySetRequest = new PropertySetRequest();
                propertySetRequest.setRetentionAlarm(1);
                propertySetRequest.setRetentionAlarmMethod(NumberUtils.toPrimitive(parkConfig.getRetentionAlarmMethod(), 1));
                propertySetRequest.setRetentionTimeThreshold(
                        NumberUtils.toPrimitive(parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60);
                propertySetRequest.setRetentionIntervalTime(NumberUtils.toPrimitive(parkConfig.getRetentionIntervalTime(), 600));
                if (P2cVersionEnum.getIndex(deviceInfo.getVersion()) >= P2cVersionEnum.版本18.getIndex()) {
                    //未开通欠费追缴功能时，虚假车牌配置以相机为准
                    List<ParkRecoveryVo> recoverys = parkRecoveryService.getOpenParkRecoveryByParkIds(Collections.singletonList(deviceInfo.getParkId()));
                    if (CollectionUtils.isNotEmpty(recoverys)) {
                        propertySetRequest.setEnableShamPlate(parkConfig.getEnableShamPlate());
                        propertySetRequest.setShamPlateMethod(parkConfig.getShamPlateMethod());
                    } else {
                        ObjectResponse<PropertyInfoRequest> response = propertyGetService.send(serialNumber, null);
                        if (ObjectResponse.isSuccess(response)) {
                            PropertyInfoRequest data = response.getData();
                            propertySetRequest.setEnableShamPlate(data.getEnableShamPlate());
                            propertySetRequest.setShamPlateMethod(data.getShamPlateMethod());
                        }
                    }
                }
                // 异步线程下发属性配置
                propertySetService.send(propertySetRequest, serialNumber);
                String itcSn = itcCacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
                if (itcSn == null){
                    return;
                }
                TokenDeviceVo itcDev = itcCacheHandle.getDeviceInfo(itcSn);
                if (itcDev == null) {
                    return;
                }
                //通道类型不匹配时下发更新
                if (itcDev.getInandoutType().equals(parkInoutdevice.getInandoutType())) {
                    return;
                }
                //区域ID不匹配时下发更新
                if (itcDev.getRegionId().equals(parkInoutdevice.getRegionId())) {
                    return;
                }
                itcDev.setInandoutType(parkInoutdevice.getInandoutType());
                itcDev.setInandoutName(parkInoutdevice.getInandoutName());
                itcDev.setRegionId(parkInoutdevice.getRegionId());
                itcCacheHandle.updateDeviceInfo(itcSn, itcDev);
                com.icetech.cloudcenter.domain.request.itc.PropertySetRequest itcPsq = new com.icetech.cloudcenter.domain.request.itc.PropertySetRequest();
                itcPsq.setEnexType(parkInoutdevice.getInandoutType());
                if (parkConfig.getCarenexTimelong() != null) {
                    itcPsq.setRetentionAlarm(parkConfig.getCarenexTimelong() != null ? 1 : 0);
                    itcPsq.setRetentionTimeThreshold(
                            NumberUtils.toPrimitive(parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60);
                }
                itcPropertySetService.send(itcPsq, itcSn);
            }));
        }
    }

    private void asyncDownChannel(String parkCode, ParkInoutdevice parkInoutdevice, ParkConfig parkConfig) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            String serialNumber = cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
            if (serialNumber == null){
                return;
            }
            TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(serialNumber);
            if (deviceInfo == null) {
                return;
            }
            if (P2cVersionEnum.getIndex(deviceInfo.getVersion()) < P2cVersionEnum.版本8.getIndex()) {
                return;
            }
            PropertySetRequest propertySetRequest = new PropertySetRequest();
            Integer inandoutType = deviceInfo.getInandoutType();
            if (!parkInoutdevice.getInandoutType().equals(inandoutType)
                    || !parkInoutdevice.getInandoutName().equals(deviceInfo.getInandoutName())
                   || !parkInoutdevice.getRegionId().equals(deviceInfo.getRegionId())) {
                deviceInfo.setInandoutType(parkInoutdevice.getInandoutType());
                deviceInfo.setInandoutName(parkInoutdevice.getInandoutName());
                deviceInfo.setRegionId(parkInoutdevice.getRegionId());
                cacheHandle.updateDeviceInfo(serialNumber, deviceInfo);
                propertySetRequest.setEnexType(parkInoutdevice.getInandoutType());
                //异步线程下发属性配置
                propertySetService.send(propertySetRequest, serialNumber);
            }
            String itcSn = itcCacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
            if (itcSn == null){
                return;
            }
            TokenDeviceVo itcDev = itcCacheHandle.getDeviceInfo(itcSn);
            if (itcDev == null) {
                return;
            }
            //通道类型不匹配时下发更新
            if (itcDev.getInandoutType().equals(parkInoutdevice.getInandoutType())) {
                return;
            }
            //区域ID不匹配时下发更新
            if (itcDev.getRegionId().equals(parkInoutdevice.getRegionId())) {
                return;
            }
            itcDev.setInandoutType(parkInoutdevice.getInandoutType());
            itcDev.setInandoutName(parkInoutdevice.getInandoutName());
            itcDev.setRegionId(parkInoutdevice.getRegionId());
            itcCacheHandle.updateDeviceInfo(itcSn, itcDev);
            com.icetech.cloudcenter.domain.request.itc.PropertySetRequest itcPsq = new com.icetech.cloudcenter.domain.request.itc.PropertySetRequest();
            itcPsq.setEnexType(parkInoutdevice.getInandoutType());
            if (parkConfig.getCarenexTimelong() != null) {
                itcPsq.setRetentionAlarm(parkConfig.getCarenexTimelong() != null ? 1 : 0);
                itcPsq.setRetentionTimeThreshold(
                        NumberUtils.toPrimitive(parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60);
            }
            itcPropertySetService.send(itcPsq, itcSn);
        }));
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo) {

        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        List<BatchSendVO.SubTaskInfo> subTaskInfos = vo.getSubTaskInfos();
        Long[] channelIds = subTaskInfos.stream().map(BatchSendVO.SubTaskInfo::getChannelId).distinct().toArray(Long[]::new);
        ObjectResponse<List<ParkInoutdevice>> listObjectResponse = parkService.getChannelsByIds(channelIds);
        List<ParkInoutdevice> inoutdeviceList = listObjectResponse.getData();
        //id和对象映射的关系map
        Map<Long, List<ParkInoutdevice>> listMap = inoutdeviceList.stream().collect(Collectors.groupingBy(ParkInoutdevice::getId));

        for (BatchSendVO.SubTaskInfo subTaskInfo : subTaskInfos) {
            BatchSendVO newVO = new BatchSendVO();
            newVO.setParkCode(parkCode);
            newVO.setParkId(parkId);
            newVO.setTaskId(vo.getTaskId());
            List<BatchSendVO.SubTaskInfo> list = new ArrayList<>();
            list.add(subTaskInfo);
            newVO.setSubTaskInfos(list);
            ParkInoutdevice parkInoutdevice = listMap.get(subTaskInfo.getChannelId()).get(0);
            ParkConfig parkConfig = getParkConfig(parkId);
            //组装参数
            ChannelRulesRequest channelRulesRequest;
            try {
                channelRulesRequest = getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
            } catch (ResponseBodyException e) {
                return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "通道设备未找到"));
            }
            batchDownConfigHandle.batchDown(newVO, channelRulesRequest, P2cDownCmdEnum.车场权限下发.getCmdType());
        }
        return ObjectResponse.success();
    }
    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        log.info("[通道权限批量下发] 参数[{}]", vo);
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        Long channelId = vo.getChannelId();
        ObjectResponse<ParkInoutdevice> parkInoutdeviceObjectResponse = parkService.getInoutDeviceById(channelId);
        ParkInoutdevice parkInoutdevice = parkInoutdeviceObjectResponse.getData();
        ParkConfig parkConfig = getParkConfig(parkId);
        //组装参数
        ChannelRulesRequest channelRulesRequest;
        try {
            channelRulesRequest = getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
        }catch (ResponseBodyException e) {
            return ObjectResponse.failed(ERROR_410, TextConstant.getDefaultMessage(ONE, "通道设备未找到"));
        }
        batchDownConfigHandle.repeatBatch(vo, channelRulesRequest, P2cDownCmdEnum.车场权限下发.getCmdType());
        return ObjectResponse.success();
    }

    /**
     * 获取车场配置
     * @param parkId 车场ID
     * @return 响应
     */
    private ParkConfig getParkConfig(Long parkId) {
        ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(parkId);
        ObjectResponse.notError(parkConfigObjectResponse);
        return parkConfigObjectResponse.getData();
    }

    private ChannelRulesRequest getChannelRulesRequest(ParkConfig parkConfig, ParkInoutdevice parkInoutdevice, String parkCode) {
        ObjectResponse<List<ParkDevice>> deviceByChannel = parkDeviceService.getDeviceByChannel(parkConfig.getParkId(), parkInoutdevice.getInandoutCode(), 1);
        ObjectResponse.notError(deviceByChannel);
        ParkDevice parkDevice = deviceByChannel.getData().get(0);
        ChannelRulesRequest channelRulesRequest = new ChannelRulesRequest();
        channelRulesRequest.setRunningMode(1);
        channelRulesRequest.setIssupTempcar(parkInoutdevice.getIsAllowTempcarrun());
        ParkRegion parkRegion = parkRegionDao.selectById(parkInoutdevice.getRegionId());
        AssertTools.notNull(parkRegion, CodeConstants.ERROR_404, "通道所属区域信息未找到");
        if (parkRegion.getOilCarFullFlag() == 1 || parkRegion.getChargeCarFullFlag() == 1) {
            //纯云模式
            channelRulesRequest.setRunningMode(2);
        }

        if (DingZhiFuncConstants.DZ001_PARKS.contains(parkCode)){
            channelRulesRequest.setIssupTempcar(0);
        }else if (P2cVersionEnum.getIndex(parkDevice.getProtocolVer()) < P2cVersionEnum.版本9.getIndex()){
            if (P2cVersionEnum.getIndex(parkDevice.getProtocolVer()) < P2cVersionEnum.版本5.getIndex()){
                if (NumberUtils.toPrimitive(parkConfig.getFilterTime()) > 0) {
                    //如果出入口共用一个通道，配置了离场X秒不让进场，则下发相机为不允许临时车进，以此来让相机询问云平台
                    channelRulesRequest.setIssupTempcar(0);
                }
            }
            if (redisUtils.exists(PARK_FULL_PROFILE + parkCode + "_" + parkRegion.getId())){
                //车位已满时，不允许临时车入场
                channelRulesRequest.setIssupTempcar(0);
            }

            //当允许临时车勾选且不勾选新能源车辆或蓝牌车辆时  下发不允许临时车进入
            if (Objects.nonNull(parkInoutdevice.getIsAllowBluerun())
                    &&Objects.nonNull(parkInoutdevice.getIsAllowNewenergycarrun()) && Objects.nonNull(parkInoutdevice.getIsAllowTempcarrun())){
                if (1 == parkInoutdevice.getIsAllowTempcarrun()
                        &&(0 ==parkInoutdevice.getIsAllowNewenergycarrun() || 0== parkInoutdevice.getIsAllowBluerun() )){
                    channelRulesRequest.setIssupTempcar(0);
                }
            }
            //当允许临时车勾选且只勾选新能源车辆或蓝牌车辆时  下发不允许临时车进入
            if (Objects.nonNull(parkInoutdevice.getIsAllowBluerun())
                    &&Objects.nonNull(parkInoutdevice.getIsAllowNewenergycarrun())
                    &&Objects.nonNull(parkInoutdevice.getIsAllowYellowcarrun())
                    &&Objects.nonNull(parkInoutdevice.getIsAllowTempcarrun())
                    &&Objects.nonNull(parkInoutdevice.getIsAllowNocardrun())){
                if (1 == parkInoutdevice.getIsAllowTempcarrun()
                        && 0 ==  parkInoutdevice.getIsAllowYellowcarrun()
                        && 0 == parkInoutdevice.getIsAllowNocardrun()
                        && (1==parkInoutdevice.getIsAllowBluerun() || 1==parkInoutdevice.getIsAllowNewenergycarrun())){
                    channelRulesRequest.setIssupTempcar(0);
                }
            }
           /* //当勾选储值卡车辆时 下发不允许临时车入场
            if(Objects.nonNull(parkInoutdevice.getIsAllowStoredCar())&& 1 == parkInoutdevice.getIsAllowStoredCar() ){
                channelRulesRequest.setIssupTempcar(0);
            }*/

            //当不允许vip车辆进入时  下发不允许临时车入场
            if(Objects.nonNull(parkInoutdevice.getIsAllowVipCar())&& 0 == parkInoutdevice.getIsAllowVipCar() ){
                channelRulesRequest.setIssupTempcar(0);
            }
            if (!StringUtils.isEmpty(parkInoutdevice.getVipCarTypeId())){
                channelRulesRequest.setIssupTempcar(0);
            }

            //当勾选月卡车时 且 AB 车不勾选时下发不开闸
            if ( Objects.nonNull(parkInoutdevice.getIsAllowMonthCar())
                    &&1 == parkInoutdevice.getIsAllowMonthCar()
                    && Objects.nonNull(parkInoutdevice.getIsAllowAbcar())
                    &&0 == parkInoutdevice.getIsAllowAbcar()){
                channelRulesRequest.setIssupTempcar(0);
            }

            //当空车为限制不让进的时候下发临时车不让进
            Integer integer = 1;
            if (integer.equals(parkRegion.getIsFullForbidenter())
                    || integer.equals(parkRegion.getIsFullForbidReservEnter())
                    || integer.equals(parkRegion.getIsFullForbidStoreEnter())) {
                channelRulesRequest.setIssupTempcar(0);
            }
        }

        boolean enableNotPay = false;
        //欠费追缴设置临时车不让进
        if (!Integer.valueOf(0).equals(channelRulesRequest.getIssupTempcar())) {
            int enterpayType = NumberUtils.toPrimitive(parkConfig.getEnterpayType());
            int exitpayType = NumberUtils.toPrimitive(parkConfig.getExitpayType());
            if (Integer.valueOf(1).equals(parkInoutdevice.getInandoutType()) && enterpayType == 1) {
                channelRulesRequest.setIssupTempcar(0);
                enableNotPay = true;
            }
            if (Integer.valueOf(2).equals(parkInoutdevice.getInandoutType()) && exitpayType == 1) {
                channelRulesRequest.setIssupTempcar(0);
                enableNotPay = true;
            }
        }

        //实际对应无牌车扫码进出
        channelRulesRequest.setIsAllowNocardrun(parkInoutdevice.getIsAllowNocardrun());
        //模糊匹配情况，0：不支持，1：去汉字2：去汉字一位，3：去汉字两位
        int isOpenVaguetype = NumberUtils.toPrimitive(parkInoutdevice.getIsOpenVaguetype());
        channelRulesRequest.setVagueInfo(isOpenVaguetype == 1 ? NumberUtils.toPrimitive(parkInoutdevice.getVaguetype()) + 1 : 0);

        channelRulesRequest.setFreetime(0);
//        if (parkConfig.getIsreleaseFreetm() == 0){
//            channelRulesRequest.setFreetime(0);
//        }else if (NumberUtils.toPrimitive(parkInoutdevice.getIsAllowTempcarrun(), 1) == 0){
//            channelRulesRequest.setFreetime(0);
//        }else{
//            //免费时长
//            ObjectResponse<ParkChargeRuleVO> objectResponse = parkService.getMinFreeTime(parkConfig.getParkId());
//            if (!objectResponse.getCode().equals(CodeConstants.SUCCESS)){
//                log.info("<端云-通道权限> 获取免费停车时长失败，返回：{}", objectResponse);
//                channelRulesRequest.setFreetime(0);
//            }else{
//                ParkChargeRuleVO vo = objectResponse.getData();
//                if (Integer.valueOf(1).equals(vo.getIsFreetimeOnce())){
//                    log.info("[端云-通道权限] 开启了24小时只使用一次免费时长的配置，下发时长改为0分钟, parkId[{}]", parkConfig.getParkId());
//                    channelRulesRequest.setFreetime(0);
//                }else{
//                    //按秒计费时，下发到相机要少1分钟；例：停车10分钟免费，相机在判断10分钟1秒时也认为免费，所以要由上报平台算费
//                    if (Integer.valueOf(1).equals(parkConfig.getBillPrecision())) {
//                        channelRulesRequest.setFreetime(
//                                NumberUtils.toPrimitive(vo.getFreeTime()) <= 0 ? 0 : vo.getFreeTime() - 1);
//                    } else {
//                        channelRulesRequest.setFreetime(vo.getFreeTime());
//                    }
//                }
//            }
//        }
//        if (enableNotPay) {
//            channelRulesRequest.setFreetime(0);
//        }
//        //海大穿行收费下发免费时长为0
//        if (Objects.nonNull(thirdInfoService.selectHaiDaChuanXIng(parkConfig.getParkId()))) {
//            channelRulesRequest.setFreetime(0);
//        }
        //预缴费后离场预留免费时长（分钟）
        channelRulesRequest.setIsfreeAfterpay(parkConfig.getIsfreeAfterpay(15));
        //是否允许军警车免费停车，0：否，1：是
        channelRulesRequest.setIsfreeSpecialcar(parkConfig.getIsfreeSpecialcar());
        //是否支持多位多车管理，0：否，1：是
        channelRulesRequest.setIssupAbmanage(NumberUtils.toPrimitive(parkConfig.getIssupAbmanage()));
        //是否上报车辆进出场图片，0：否，1：是
        channelRulesRequest.setIsupimage(parkConfig.getIsupimage());
        //是否允许黄牌车进入，0：否，1：是
        channelRulesRequest.setIsAllowYellowcarrun(parkInoutdevice.getIsAllowYellowcarrun());
        channelRulesRequest.setCacheExpires(parkInoutdevice.getCacheExpires());
        /*
         * 1.3脱机计费新增
         */
        channelRulesRequest.setOvertimeBillType(parkConfig.getOvertimeBillType());
        channelRulesRequest.setIsnotgetsmallchange(parkConfig.getIsnotgetsmallchange());
        channelRulesRequest.setFreetimeStatus(parkConfig.getFreetimeStatus());
        channelRulesRequest.setIsFilltime(parkConfig.getIsFilltime());
        channelRulesRequest.setIsallowfreetmonce(parkConfig.getIsallowfreetmonce() == null ? 1 : parkConfig.getIsallowfreetmonce());
        channelRulesRequest.setChargeVersionNum(parkConfig.getChargeVersionNum() == null ? 0 : parkConfig.getChargeVersionNum());
        channelRulesRequest.setBillPrecision(parkConfig.getBillPrecision());
        channelRulesRequest.setIsfixedfees(parkConfig.getIsfixedfees());
        channelRulesRequest.setFixedfeevalue(parkConfig.getFixedfeevalue() != null ? parkConfig.getFixedfeevalue() * 100 : null);

        channelRulesRequest.setIsSpecialPark(0);
        if (NumberUtils.toPrimitive(parkConfig.getFilterTime()) > 0) {
            if (NumberUtils.toPrimitive(parkConfig.getPlateFilterType(), 1) == 1) {
                channelRulesRequest.setIsSpecialPark(1);
                channelRulesRequest.setEnexMinTime(parkConfig.getFilterTime());
                channelRulesRequest.setExenMinTime(parkConfig.getFilterTime());
            } else {
                //相机不支持通道过滤，所以由平台处理临时车
                channelRulesRequest.setIssupTempcar(0);
            }
        }
        channelRulesRequest.setIsAllowBlackCar(parkInoutdevice.getIsAllowBackCar());
        channelRulesRequest.setIsAllowBluerun(parkInoutdevice.getIsAllowBluerun());
        channelRulesRequest.setIsAllowNewenergycarrun(parkInoutdevice.getIsAllowNewenergycarrun());
        channelRulesRequest.setIsAllowVisitCar(parkInoutdevice.getIsAllowVisitCar());
        channelRulesRequest.setIsAllowMonthCar(parkInoutdevice.getIsAllowMonthCar());
        int overTimeDayToCamera = NumberUtils.toPrimitive(parkConfig.getIsAllowOvertimeCar()) == 1
                ? NumberUtils.toPrimitive(parkConfig.getOverTimeDay(), 999999999) : 0;
        int expireMcDays = NumberUtils.toPrimitive(parkConfig.getIsExpireMc()) == 1
                ? NumberUtils.toPrimitive(parkConfig.getExpireMcDays()) : 0;
        if (Integer.valueOf(1).equals(parkConfig.getIsAllowOvertimeCar()) || Integer.valueOf(1).equals(parkConfig.getIsExpireMc())) {
            channelRulesRequest.setOverTimeDay(Math.min(overTimeDayToCamera, expireMcDays));
        } else {
            channelRulesRequest.setOverTimeDay(0);
        }
        if (customRepeatExEnable && customRepeatExParkCodes.contains(parkCode)) {
            channelRulesRequest.setIssupTempcar(0);
            channelRulesRequest.setFreetime(0);
        }
        channelRulesRequest.setIsExpireMc(parkConfig.getIsExpireMc());
        channelRulesRequest.setIsAllowAbcar(parkInoutdevice.getIsAllowAbcar());
        channelRulesRequest.setIsAllowStoredCar(parkInoutdevice.getIsAllowStoredCar());
        channelRulesRequest.setIsAllowVipCar(parkInoutdevice.getIsAllowVipCar());
        channelRulesRequest.setVipCarTypeId(parkInoutdevice.getVipCarTypeId());
        channelRulesRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig() != null ? parkConfig.getFixedFeeValueBig() * 100 : null);

        //since V1.5.1
        channelRulesRequest.setFullEmptynum(parkRegion.getFullEmptynum());
        //文档语义和数据库中的反了，所以做了兼容，0改为1，1改为0下发
        channelRulesRequest.setIsFullForbidenter(NumberUtils.toPrimitive(parkRegion.getIsFullForbidenter(), 0) == 0 ? 1 : 0);
        channelRulesRequest.setIsFullForbidmonthenter(NumberUtils.toPrimitive(parkRegion.getIsFullForbidMonthEnter(), 0) == 0 ? 1 : 0);
        channelRulesRequest.setIsFullForbidreserventer(NumberUtils.toPrimitive(parkRegion.getIsFullForbidReservEnter(), 0) == 0 ? 1 : 0);
        channelRulesRequest.setIsFullForbidstoreenter(NumberUtils.toPrimitive(parkRegion.getIsFullForbidStoreEnter(), 0) == 0 ? 1 : 0);
        channelRulesRequest.setIsFullForbidblackenter(NumberUtils.toPrimitive(parkRegion.getIsFullForbidblackenter(), 0) == 0 ? 1 : 0);
        channelRulesRequest.setIsFullForbidvipenter(NumberUtils.toPrimitive(parkRegion.getIsFullForbidVIPEnter(), 0) == 0 ? 1 : 0);
        channelRulesRequest.setFullVipCarTypeId(parkRegion.getVipCarTypeId());
        if (parkConfig.getIsCardcount() != null){
            channelRulesRequest.setIsCardcount(parkConfig.getIsCardcount() == 2 ? 0 : 1);
        } else {
            channelRulesRequest.setIsCardcount(0);
        }

        //since V1.5.2
        if (Integer.valueOf(0).equals(parkConfig.getFreeCarReenter())) {
            channelRulesRequest.setIsAllowMonthCar(0);
            if (Integer.valueOf(1).equals(channelRulesRequest.getIsAllowVipCar())
                && StringUtils.isNotBlank(channelRulesRequest.getVipCarTypeId())) {
                String[] strings = channelRulesRequest.getVipCarTypeId().split(",");
                String[] newArray = Arrays.stream(strings)
                        .filter(StringUtils::isNotBlank)
                        .filter(id -> {
                            VipTypeDto vipTypeDto = vipTypeDao.selectById(Integer.valueOf(id));
                            return vipTypeDto != null && !DiscountTypeEnum.全免.getType().equals(vipTypeDto.getType());
                        }).toArray(String[]::new);
                channelRulesRequest.setVipCarTypeId(StringUtils.joinWith(",", newArray));
            }
        }
        String qrCodeUr;
        if (NumberUtils.toPrimitive(parkInoutdevice.getInandoutType()) == 1) {
            qrCodeUr = webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + parkInoutdevice.getInandoutCode();
        } else {
            qrCodeUr = webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + parkInoutdevice.getInandoutCode();
        }
        channelRulesRequest.setShowQrCodeUrl(qrCodeUr);
        channelRulesRequest.setMoneyunitType(parkConfig.getMoneyunitType());
        //场中场需求
        ObjectResponse<Park> objectResponse = parkService.findByParkId(parkConfig.getParkId());
        ObjectResponse.notError(objectResponse, "车场不存在");
        Park park = objectResponse.getData();
        if (Integer.valueOf(1).equals(park.getIsInterior())) {
            channelRulesRequest.setRegionId(parkInoutdevice.getRegionId());
            channelRulesRequest.setNestType(parkRegion.getPositionType());
            channelRulesRequest.setRegionName(parkRegion.getRegionName());
            channelRulesRequest.setRegionType(Long.valueOf(0).equals(parkRegion.getFatherRelationId()) ? 1 : 2);
            channelRulesRequest.setIsMaster(parkInoutdevice.getIsMaster());
            channelRulesRequest.setSwitchFreeTime(park.getSwitchFeeTime());
        } else {
            channelRulesRequest.setNestType(0);
        }
        return channelRulesRequest;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        Integer subTaskId = redisUtils.get(RedisConstants.BATCH_DOWN_MSGID + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null){
            batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.通道权限下发.getCmdType());
    }
}
