package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service("p2cBizBatchDownServiceImpl")
@Slf4j
public class BizBatchDownServiceImpl extends AbstractService
        implements ResponseService<String>, DownService<Void, Void>, NotifyService<String> {

    @Resource
    private P2cDownHandle p2cDownHandle;

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.批量下发.getCmdType());
    }
}
