package com.icetech.park.service.down.p2c;

import com.icetech.basics.domain.SendMessage;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.SendMsgCommon;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static com.icetech.basics.constants.TextConstant.CAMERA_OFF_LINE;
import static com.icetech.basics.constants.TextConstant.CAMERA_VERSION_LOW;
import static com.icetech.basics.constants.TextConstant.ERROR_410;
import static com.icetech.basics.constants.TextConstant.ONE;
import static com.icetech.basics.constants.TextConstant.TIME_OUT_SEND_FAIL;

@Service
@Slf4j
public class SendMsgServiceImpl extends SendMsgCommon {

    @Autowired
    private P2cDownHandle p2cDownHandle;

    @Override
    public   <T, R> ObjectResponse<R> send(Message<T> message, String sendDevices, String parkCode) {
        T payload = message.getPayload();
        String[] targetArr = sendDevices.split(";");
        if (targetArr.length == 0){
            return ObjectResponse.success();
        }
        SendMessage sendMessage = SendMessage.builder()
                .type(ONE)
                .build();
        boolean hasFail = false;
        String lastDeviceVersion = null;
        List<SendMessage.Describe> offLineDescribes = new ArrayList<>();
        List<SendMessage.Describe> failDescribes = new ArrayList<>();
        List<SendMessage.Describe> lowVerDescribes = new ArrayList<>();
        for (String serialNumber : targetArr) {
            if (serialNumber == null || serialNumber.trim().isEmpty()) {
                continue;
            }
            TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(serialNumber);
            if (tokenDeviceVo == null) {
                hasFail = true;
                if (CollectionUtils.isNotEmpty(offLineDescribes)) {
                    for (SendMessage.Describe describe : offLineDescribes) {
                        List<String> serialNumbers = describe.getSerialNumbers();
                        if (CollectionUtils.isEmpty(serialNumbers)) {
                            serialNumbers.add(serialNumber);
                        } else {
                            if (!serialNumbers.contains(serialNumber)) {
                                serialNumbers.add(serialNumber);
                            }
                        }
                    }
                } else {
                    List<String> nums = new ArrayList<>();
                    nums.add(serialNumber);
                    offLineDescribes.add(SendMessage.Describe.builder()
                            .failType(CAMERA_OFF_LINE)
                            .serialNumbers(nums)
                            .build());
                }
                log.info("[下发业务数据] 设备序列号[{}]不在线", serialNumber);
                continue;
            }
            //多位多车月卡车 脱机计费前的版本不下发
            if (message.getServiceType().equals(P2cDownCmdEnum.月卡.getCmdType())
                    && P2cVersionEnum.版本4.getIndex() > P2cVersionEnum.getIndex(tokenDeviceVo.getVersion())) {
                MonthCardRequest monthCardRequest = (MonthCardRequest) message.getPayload();
                if (monthCardRequest.getDetails().size() == 1) {
                    MonthCardRequest.Details details = monthCardRequest.getDetails().get(0);
                    int plateNums = details.getPlateNum().split(",").length;
                    if (plateNums > details.getPlotCount()) {
                        //删除以前可能下发的月卡信息，防止编辑后变成了多位多车的情况
                        clearListService.execute(message.getParkId(), parkCode,
                                QueryListRequest.DataType.月卡.getVal(), details.getCardId());
                        sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder()
                                .serialNumbers(Collections.singletonList(tokenDeviceVo.getDeviceNo()))
                                .failType(CAMERA_VERSION_LOW)
                                .versions(Collections.singletonList(tokenDeviceVo.getVersion()))
                                .build()));
                        return ObjectResponse.failed(CodeConstants.ERROR_407, JsonUtils.toJson(sendMessage));
                    }
                }
            }
            //屏显语音根据出入口下发不同的颜色
//            if (message.getServiceType().equals(P2cDownCmdEnum.自定义语音屏显配置.getCmdType())
//                    && P2cVersionEnum.版本3.getIndex() <= P2cVersionEnum.getIndex(tokenDeviceVo.getVersion())) {
//                LedsoundConfigRequest ledsoundConfigRequest = (LedsoundConfigRequest) message.getPayload();
//                if (NumberUtils.toPrimitive(tokenDeviceVo.getInandoutType()) == 2) {
//                    if (ledsoundConfigRequest.getFreePerLineColorExit() != null) {
//                        ledsoundConfigRequest.setFreePerLineColor(ledsoundConfigRequest.getFreePerLineColorExit());
//                    }
//                    if (ledsoundConfigRequest.getBusyPerLineColorExit() != null) {
//                        ledsoundConfigRequest.setBusyPerLineColor(ledsoundConfigRequest.getBusyPerLineColorExit());
//                    }
//                } else {
//                    ledsoundConfigRequest.setFreePerLineColor(ledsoundConfigRequest.getFreePerLineColorEnter());
//                    ledsoundConfigRequest.setBusyPerLineColor(ledsoundConfigRequest.getBusyPerLineColorEnter());
//                }
//            }
            if (tokenDeviceVo.getVersion() != null && !tokenDeviceVo.getVersion().equals(lastDeviceVersion)) {
                try {
                    //根据版本号，重新构建参数
                    if (payload instanceof List) {
                        List list = (List) payload;
                        Object object = list.get(0);
                        if (object instanceof Request) {
                            for (Object o : list) {
                                Request request = (Request) o;
                                request.buildByVersion(tokenDeviceVo.getVersion());
                            }
                        }
                    } else if (payload instanceof Request) {
                        Request request = (Request) payload;
                        request.buildByVersion(tokenDeviceVo.getVersion());
                    }
                } catch (ResponseBodyException re) {
                    hasFail = true;
                    if (CollectionUtils.isNotEmpty(lowVerDescribes)) {
                        for (SendMessage.Describe describe : lowVerDescribes) {
                            List<String> serialNumbers = describe.getSerialNumbers();
                            List<String> versions = describe.getVersions();
                            if (CollectionUtils.isEmpty(serialNumbers)) {
                                serialNumbers.add(serialNumber);
                                versions.add(tokenDeviceVo.getVersion());
                            } else {
                                if (!serialNumbers.contains(serialNumber)) {
                                    serialNumbers.add(serialNumber);
                                    versions.add(tokenDeviceVo.getVersion());
                                }
                            }
                        }
                    } else {
                        List<String> nums = new ArrayList<>();
                        nums.add(serialNumber);
                        List<String> versions = new ArrayList<>();
                        versions.add(tokenDeviceVo.getVersion());
                        lowVerDescribes.add(SendMessage.Describe.builder()
                                .failType(CAMERA_VERSION_LOW)
                                .serialNumbers(nums)
                                .versions(versions)
                                .build());
                    }
                    continue;
                }
            }

            //下发
            String messageId = p2cDownHandle.send(parkCode, serialNumber, message);
            if (messageId == null) {
                hasFail = true;
                if (CollectionUtils.isEmpty(failDescribes)) {
                    List<String> nums = new ArrayList<>();
                    nums.add(serialNumber);
                    offLineDescribes.add(SendMessage.Describe.builder()
                            .failType(TIME_OUT_SEND_FAIL)
                            .serialNumbers(nums)
                            .build());
                } else {
                    for (SendMessage.Describe describe : offLineDescribes) {
                        List<String> serialNumbers = describe.getSerialNumbers();
                        if (CollectionUtils.isEmpty(serialNumbers)) {
                            serialNumbers.add(serialNumber);
                        } else {
                            if (!serialNumbers.contains(serialNumber)) {
                                serialNumbers.add(serialNumber);
                            }
                        }
                    }
                }
            }
            lastDeviceVersion = tokenDeviceVo.getVersion();
        }
        if (hasFail){
            offLineDescribes.addAll(failDescribes);
            offLineDescribes.addAll(lowVerDescribes);
            sendMessage.setDescribes(offLineDescribes);
            log.info("[端云-业务数据下发] 设备不在线或响应超时, 参数[{}]", message);
            return ObjectResponse.failed(ERROR_410, JsonUtils.toJson(sendMessage));
        }else{
            return ObjectResponse.success();
        }
    }

}
