package com.icetech.park.service.down.p2c;

import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.utils.ReflectUtils;

import java.lang.reflect.Type;

/**
 * 统一调用接口
 */
public interface ResponseService<T> {

    /**
     * 处理响应
     * @param p2cBaseResponse 响应
     * @return null
     */
    default void dealResponse(P2cBaseResponse<T> p2cBaseResponse, Long parkId, String parkCode, String serialNumber) {
    }
    default void dealResponse(P2cBaseResponse<T> p2cBaseResponse, String cmd, Long parkId, String parkCode, String serialNumber) {
    }

    default Type getGenericType() {
        return ReflectUtils.getInterfaceGenericTypeWrapper(ResponseService.class, this, P2cBaseResponse.class);
    }

}
