package com.icetech.park.service.down.p2c;

import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;

import java.util.List;

/**
 * 端云下发接口
 * @author fangct
 */
public interface DownService<T, R> {

    /**
     * 下发
     * @param sendRequest 参数
     * @param parkCode 车场编号
     * @return 响应
     */
    default ObjectResponse<R> send(SendRequest sendRequest, String parkCode){
        return ObjectResponse.success();
    };

    /**
     * 批量下发
     * @param vo 参数
     * @return 响应
     */
    default ObjectResponse<R> batchSend(BatchSendVO vo){
        return ObjectResponse.success();
    }
    default ObjectResponse<R> batchSend(BatchSendVO vo, BatchSendVO.SubTaskInfo subTaskInfo){
        return ObjectResponse.success();
    }

    /**
     * 批量下发
     * @param sendRequestList 参数列表 
     * @return 响应
     */
    default ObjectResponse<R> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode){
        return ObjectResponse.success();
    }

    /**
     * 重复下发
     * @param batchSendRepeatVO 参数
     * @return 响应
     */
    default ObjectResponse<R> batchSendRepeat(BatchSendRepeatVO batchSendRepeatVO){
        return ObjectResponse.success();
    }

    default ObjectResponse<R> send(T t, String sn) {
        return ObjectResponse.success();
    }
}
